/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_SyncData;
import harmonised.pmmo.network.clientpackets.CP_SyncData_ClearXp;
import harmonised.pmmo.network.clientpackets.CP_UpdateExperience;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.util.Reference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;

public class CmdNodeAdmin {
    private static final String SKILL_ARG = "Skill Name";
    private static final String TARGET_ARG = "Target";
    private static final String TYPE_ARG = "Change Type";
    private static final String VALUE_ARG = "New Value";
    private static final SuggestionProvider<CommandSourceStack> SKILL_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest(Config.skills().skills().keySet(), (SuggestionsBuilder)builder);

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(p -> p.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)TARGET_ARG, (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"set").then(Commands.argument((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).then(Commands.argument((String)TYPE_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(List.of("level", "xp"), (SuggestionsBuilder)builder)).then(Commands.argument((String)VALUE_ARG, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> CmdNodeAdmin.adminSetOrAdd((CommandContext<CommandSourceStack>)ctx, true))))))).then(Commands.literal((String)"add").then(Commands.argument((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).then(Commands.argument((String)TYPE_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(List.of("level", "xp"), (SuggestionsBuilder)builder)).then(Commands.argument((String)VALUE_ARG, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> CmdNodeAdmin.adminSetOrAdd((CommandContext<CommandSourceStack>)ctx, false))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(CmdNodeAdmin::adminClear)).then(Commands.argument((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).executes(CmdNodeAdmin::adminClearSkill)))).then(((LiteralArgumentBuilder)Commands.literal((String)"attributes").then(Commands.literal((String)"refresh").executes(CmdNodeAdmin::rebuildAttributes))).then(Commands.literal((String)"clear").executes(CmdNodeAdmin::clearAttributes)))).then(Commands.literal((String)"ignoreReqs").executes(CmdNodeAdmin::exemptAdmin))).then(Commands.literal((String)"adminBonus").then(Commands.argument((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests(SKILL_SUGGESTIONS).then(Commands.argument((String)VALUE_ARG, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(CmdNodeAdmin::adminBonuses))))).executes(CmdNodeAdmin::displayPlayer));
    }

    public static int adminSetOrAdd(CommandContext<CommandSourceStack> ctx, boolean isSet) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(ctx, (String)TARGET_ARG);
        String skillName = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        boolean isLevel = StringArgumentType.getString(ctx, (String)TYPE_ARG).equalsIgnoreCase("level");
        long value = LongArgumentType.getLong(ctx, (String)VALUE_ARG);
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : players) {
            Experience exp = data.getXpMap(player.getUUID()).computeIfAbsent(skillName, s -> new Experience());
            if (isSet) {
                if (isLevel) {
                    exp.setLevel(value);
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.SET_LEVEL.asComponent(skillName, value, player.getName()), true);
                } else {
                    exp.setXp(value);
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.SET_XP.asComponent(skillName, value, player.getName()), true);
                }
            } else if (isLevel) {
                exp.addLevel(value);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.ADD_LEVEL.asComponent(skillName, value, player.getName()), true);
            } else {
                exp.addXp(value);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.ADD_XP.asComponent(skillName, value, player.getName()), true);
            }
            Networking.sendToClient(new CP_UpdateExperience(skillName, exp, 0L), player);
        }
        return 0;
    }

    public static int adminClear(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)TARGET_ARG)) {
            data.setXpMap(player.getUUID(), new HashMap<String, Experience>());
            Networking.sendToClient(new CP_SyncData_ClearXp(""), player);
        }
        return 0;
    }

    public static int adminClearSkill(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        String specifiedSkill = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)TARGET_ARG)) {
            data.getXpMap(player.getUUID()).remove(specifiedSkill);
            Networking.sendToClient(new CP_SyncData_ClearXp(specifiedSkill), player);
        }
        return 0;
    }

    public static int rebuildAttributes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)TARGET_ARG)) {
            Core.get(LogicalSide.SERVER).getPerkRegistry().executePerkFiltered(EventType.SKILL_UP, (Player)player, "perk", "pmmo:attribute", new CompoundTag());
        }
        return 0;
    }

    public static int clearAttributes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)TARGET_ARG)) {
            player.getAttributes().attributes.values().forEach(instance -> {
                List<ResourceLocation> ids = instance.getModifiers().stream().filter(mod -> mod.id().getPath().startsWith("perk/")).map(AttributeModifier::id).toList();
                ids.forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
            });
        }
        return 0;
    }

    public static int displayPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        IDataStorage data = Core.get(LogicalSide.SERVER).getData();
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)TARGET_ARG)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> ((ServerPlayer)player).getName(), false);
            for (Map.Entry<String, Experience> skillMap : data.getXpMap(player.getUUID()).entrySet()) {
                long level = skillMap.getValue().getLevel().getLevel();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)((String)skillMap.getKey() + ": " + level + " | " + String.valueOf(skillMap.getValue()))), false);
            }
        }
        return 0;
    }

    public static int exemptAdmin(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Core core = Core.get((Level)((CommandSourceStack)ctx.getSource()).getLevel());
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)TARGET_ARG);
        ResourceLocation playerID = Reference.mc(player.getUUID().toString());
        PlayerData existing = core.getLoader().PLAYER_LOADER.getData().get(playerID);
        boolean exists = existing != null;
        PlayerData updated = new PlayerData(true, !exists || !existing.ignoreReq(), exists ? existing.bonuses() : Map.of());
        core.getLoader().PLAYER_LOADER.getData().put(playerID, updated);
        Networking.sendToClient(new CP_SyncData(ObjectType.PLAYER, core.getLoader().PLAYER_LOADER.getData()), player);
        return 0;
    }

    public static int adminBonuses(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        double bonus = DoubleArgumentType.getDouble(ctx, (String)VALUE_ARG);
        String skill = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        Core core = Core.get((Level)((CommandSourceStack)ctx.getSource()).getLevel());
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)TARGET_ARG);
        ResourceLocation playerID = Reference.mc(player.getUUID().toString());
        PlayerData existing = core.getLoader().PLAYER_LOADER.getData().get(playerID);
        boolean exists = existing != null;
        HashMap<String, Double> bonuses = exists ? new HashMap<String, Double>(existing.bonuses()) : new HashMap();
        bonuses.put(skill, bonus);
        if (skill.equals("clear")) {
            bonuses.clear();
        }
        PlayerData updated = new PlayerData(true, !exists || !existing.ignoreReq(), bonuses);
        core.getLoader().PLAYER_LOADER.getData().put(playerID, updated);
        Networking.sendToClient(new CP_SyncData(ObjectType.PLAYER, core.getLoader().PLAYER_LOADER.getData()), player);
        return 0;
    }
}

