/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import harmonised.pmmo.commands.CmdNodeAdmin;
import harmonised.pmmo.commands.CmdNodeParty;
import harmonised.pmmo.commands.CmdNodeStore;
import harmonised.pmmo.config.writers.PackGenerator;
import harmonised.pmmo.setup.datagen.LangProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.fml.ModList;

public class CmdPmmoRoot {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pmmo").then(CmdNodeAdmin.register(dispatcher))).then(CmdNodeParty.register(dispatcher))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"genData").requires(ctx -> ctx.hasPermission(2))).then(Commands.literal((String)"begin").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.RESET)))).then(Commands.literal((String)"withoutObjects").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.OBJECTS)))).then(Commands.literal((String)"withOverride").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.OVERRIDE)))).then(Commands.literal((String)"disabler").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.DISABLER)))).then(Commands.literal((String)"withDefaults").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.DEFAULT)))).then(Commands.literal((String)"withConfigs").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.CONFIG)))).then(Commands.literal((String)"simplified").executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.SIMPLIFY)))).then(Commands.literal((String)"modFilter").then(Commands.argument((String)"namespace", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(ModList.get().getMods().stream().map(modInfo -> modInfo.getNamespace()).filter(modid -> !modid.equals("pmmo") && !modid.equals("forge")), (SuggestionsBuilder)builder)).executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.FILTER))))).then(Commands.literal((String)"forPlayers").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> CmdPmmoRoot.set((CommandContext<CommandSourceStack>)ctx, Setting.PLAYER))))).then(Commands.literal((String)"create").executes(ctx -> PackGenerator.generatePack(((CommandSourceStack)ctx.getSource()).getServer()))))).then(CmdNodeStore.register(dispatcher))).then((ArgumentBuilder)Commands.literal((String)"debug"))).then(Commands.literal((String)"help").executes(ctx -> CmdPmmoRoot.help((CommandContext<CommandSourceStack>)ctx)))).executes(ctx -> CmdPmmoRoot.credits((CommandContext<CommandSourceStack>)ctx)));
    }

    public static int credits(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Mod by Harmony and Caltinor"), false);
        return 0;
    }

    public static int help(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        MutableComponent wiki = Component.literal((String)"the wiki").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Caltinor/Project-MMO-2.0/blob/main/wiki/home.md")));
        MutableComponent discord = Component.literal((String)"the discord").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/5NVNkNB")));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Help can be found on ").append((Component)wiki).append(" or in ").append((Component)discord), false);
        return 0;
    }

    public static int set(CommandContext<CommandSourceStack> context, Setting setting) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> switch (setting.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                MutableComponent var2_2;
                PackGenerator.applyDefaults = false;
                PackGenerator.applyOverride = false;
                PackGenerator.applyDisabler = false;
                PackGenerator.applySimple = false;
                PackGenerator.applyObjects = true;
                PackGenerator.applyConfigs = false;
                PackGenerator.players.clear();
                PackGenerator.namespaceFilter.clear();
                yield var2_2 = LangProvider.PACK_BEGIN.asComponent();
            }
            case 1 -> {
                MutableComponent var2_3;
                PackGenerator.applyDefaults = true;
                yield var2_3 = LangProvider.PACK_DEFAULTS.asComponent();
            }
            case 2 -> {
                MutableComponent var2_4;
                PackGenerator.applyOverride = true;
                yield var2_4 = LangProvider.PACK_OVERRIDE.asComponent();
            }
            case 3 -> {
                MutableComponent var2_5;
                PackGenerator.applyDisabler = true;
                yield var2_5 = LangProvider.PACK_DISABLER.asComponent();
            }
            case 5 -> {
                MutableComponent var2_6;
                PackGenerator.applySimple = true;
                yield var2_6 = LangProvider.PACK_SIMPLE.asComponent();
            }
            case 4 -> {
                MutableComponent var2_7;
                try {
                    PackGenerator.players.addAll(EntityArgument.getPlayers((CommandContext)context, (String)"players"));
                }
                catch (CommandSyntaxException var3_11) {
                    // empty catch block
                }
                yield var2_7 = LangProvider.PACK_PLAYERS.asComponent();
            }
            case 6 -> {
                MutableComponent var2_8;
                PackGenerator.namespaceFilter.add(StringArgumentType.getString((CommandContext)context, (String)"namespace"));
                yield var2_8 = LangProvider.PACK_FILTER.asComponent();
            }
            case 8 -> {
                MutableComponent var2_9;
                PackGenerator.applyObjects = false;
                yield var2_9 = LangProvider.PACK_OBJECTS.asComponent();
            }
            case 7 -> {
                MutableComponent var2_10;
                PackGenerator.applyConfigs = true;
                yield var2_10 = LangProvider.PACK_CONFIGS.asComponent();
            }
        }, true);
        return 0;
    }

    private static enum Setting {
        RESET,
        DEFAULT,
        OVERRIDE,
        DISABLER,
        PLAYER,
        SIMPLIFY,
        FILTER,
        CONFIG,
        OBJECTS;

    }
}

