/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.GlobalsConfig;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.ServerData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.features.anticheese.AntiCheeseConfig;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public static final ConfigListener CONFIG = new ConfigListener();
    public static ModConfigSpec CLIENT_CONFIG;
    public static ModConfigSpec COMMON_CONFIG;
    public static ModConfigSpec.ConfigValue<Double> SKILL_LIST_OFFSET_X;
    public static ModConfigSpec.ConfigValue<Double> SKILL_LIST_OFFSET_Y;
    public static ModConfigSpec.BooleanValue SKILL_LIST_USE_ICONS;
    public static ModConfigSpec.ConfigValue<Double> VEIN_GAUGE_OFFSET_X;
    public static ModConfigSpec.ConfigValue<Double> VEIN_GAUGE_OFFSET_Y;
    public static ModConfigSpec.ConfigValue<Double> GAIN_LIST_OFFSET_X;
    public static ModConfigSpec.ConfigValue<Double> GAIN_LIST_OFFSET_Y;
    public static ModConfigSpec.ConfigValue<Boolean> SKILL_LIST_DISPLAY;
    public static ModConfigSpec.ConfigValue<Boolean> GAIN_LIST_DISPLAY;
    public static ModConfigSpec.ConfigValue<Boolean> VEIN_GAUGE_DISPLAY;
    public static ModConfigSpec.ConfigValue<Integer> SECTION_HEADER_COLOR;
    public static ModConfigSpec.ConfigValue<Integer> SALVAGE_ITEM_COLOR;
    public static ModConfigSpec.ConfigValue<Integer> GAIN_LIST_LINGER_DURATION;
    public static ModConfigSpec.ConfigValue<List<? extends String>> GAIN_BLACKLIST;
    public static ModConfigSpec.BooleanValue HIDE_SKILL_BUTTON;
    public static ModConfigSpec.ConfigValue<Integer> SKILL_BUTTON_X;
    public static ModConfigSpec.ConfigValue<Integer> SKILL_BUTTON_Y;
    public static ModConfigSpec.BooleanValue SKILLUP_UNLOCKS;
    public static ModConfigSpec.BooleanValue SKILLUP_UNLOCKS_STRICT;
    public static ModConfigSpec.BooleanValue HIDE_MET_REQS;
    private static ModConfigSpec.BooleanValue[] TOOLTIP_REQ_ENABLED;
    private static ModConfigSpec.BooleanValue[] TOOLTIP_XP_ENABLED;
    private static ModConfigSpec.BooleanValue[] TOOLTIP_BONUS_ENABLED;
    private static final String TOOLTIP_SUFFIX = " tooltip enabled";
    public static ModConfigSpec.IntValue VEIN_LIMIT;
    public static ModConfigSpec.BooleanValue BREAK_NERF_HIGHLIGHTS;
    public static ModConfigSpec.BooleanValue BLOCK_OWNER_HIGHLIGHTS;
    public static ModConfigSpec.BooleanValue SALVAGE_HIGHLIGHTS;
    public static ModConfigSpec.BooleanValue BREAK_SPEED_PERKS;
    public static ModConfigSpec.ConfigValue<List<? extends String>> INFO_LOGGING;
    public static ModConfigSpec.ConfigValue<List<? extends String>> DEBUG_LOGGING;
    public static ModConfigSpec.ConfigValue<List<? extends String>> WARN_LOGGING;
    public static ModConfigSpec.ConfigValue<List<? extends String>> ERROR_LOGGING;
    public static ModConfigSpec.ConfigValue<List<? extends String>> FATAL_LOGGING;

    public static ServerData server() {
        return CONFIG.server();
    }

    public static AutoValueConfig autovalue() {
        return CONFIG.autovalues();
    }

    public static GlobalsConfig globals() {
        return CONFIG.globals();
    }

    public static PerksConfig perks() {
        return CONFIG.perks();
    }

    public static SkillsConfig skills() {
        return CONFIG.skills();
    }

    public static AntiCheeseConfig anticheese() {
        return CONFIG.anticheese();
    }

    private static void setupClient(ModConfigSpec.Builder builder) {
        builder.comment("PMMO Client Configuration").push("Client");
        Config.buildGUI(builder);
        Config.buildTooltips(builder);
        Config.buildVein(builder);
        Config.buildTutorial(builder);
        builder.pop();
    }

    private static void buildGUI(ModConfigSpec.Builder builder) {
        builder.comment("Configuration settings for the guis").push("GUI");
        SKILL_LIST_OFFSET_X = builder.comment("how far right from the top left corner the skill list should be").defineInRange("Skill List Xoffset", 0.01, 0.0, 1.0);
        SKILL_LIST_OFFSET_Y = builder.comment("how far down from the top left corner the skill list should be").defineInRange("Skill List Yoffset", 5.0E-4, 0.0, 1.0);
        SKILL_LIST_USE_ICONS = builder.comment("if true, uses the icon from the skill list instead of the skill name").define("Skill List Use Icons", false);
        SKILL_LIST_DISPLAY = builder.comment("Should the skill list be displayed").define("Display Skill List", true);
        VEIN_GAUGE_OFFSET_X = builder.comment("how far right from the bottom left corner the vein guage sholud be").defineInRange("Vein Gauge Xoffset", 0.01, 0.0, 1.0);
        VEIN_GAUGE_OFFSET_Y = builder.comment("how far up from the bottm left corner the vein guage should be").defineInRange("Vein Gauge Yoffset", 0.95, 0.0, 1.0);
        VEIN_GAUGE_DISPLAY = builder.comment("Should the vein charge data be displayed").define("Display Vein Gauge", true);
        GAIN_LIST_OFFSET_X = builder.comment("how far offset from center the gain list should be").defineInRange("Gain List Xoffset", 0.45, 0.0, 1.0);
        GAIN_LIST_OFFSET_Y = builder.comment("how far down from the top left corner the gain list should be").defineInRange("Gain List Yoffset", 5.0E-4, 0.0, 1.0);
        GAIN_LIST_DISPLAY = builder.comment("Should the Gain list be displayed").define("Display Gain List", true);
        SECTION_HEADER_COLOR = builder.comment("what color should the background be for the section header lines in the glossary").define("Section Header Color", (Object)352630048);
        SALVAGE_ITEM_COLOR = builder.comment("What color should the background be for the salvage item lines in the glossary").define("Salvage Item Color", (Object)366125849);
        GAIN_LIST_LINGER_DURATION = builder.comment("How long, in ticks, items on the gain list should stay on screen before disappearing").define("Gain List Linger Duration", (Object)100);
        GAIN_BLACKLIST = builder.comment("skills that should not show their gains in the gain list.  this can be used to limit spammy skills").defineList("Gain Blacklist", new ArrayList(), s -> s instanceof String);
        HIDE_SKILL_BUTTON = builder.comment("if true, removes the skills button from the inventory screen").define("hide skill button", false);
        SKILL_BUTTON_X = builder.comment(new String[]{"the horizontal location of the skill button in the inventory.", "Default = 126.  For removing overlaps, 150 is a good setting"}).define("skill_button_x", (Object)126);
        SKILL_BUTTON_Y = builder.comment(new String[]{"the vertical location (from center) of the skill button in the inventory.", "Default = -22"}).define("skill_button_y", (Object)-22);
        SKILLUP_UNLOCKS = builder.comment("If enabled, lists in chat all features unlocked when a skill levels up.").define("skillup_unlocks", true);
        SKILLUP_UNLOCKS_STRICT = builder.comment("should skillups only show in chat if content is actually unlocked.").define("strict_skillup_unlocks", true);
        builder.pop();
    }

    public static ModConfigSpec.BooleanValue tooltipReqEnabled(ReqType type) {
        return TOOLTIP_REQ_ENABLED[type.ordinal()];
    }

    public static ModConfigSpec.BooleanValue tooltipXpEnabled(EventType type) {
        return TOOLTIP_XP_ENABLED[type.ordinal()];
    }

    public static ModConfigSpec.BooleanValue tooltipBonusEnabled(ModifierDataType type) {
        return TOOLTIP_BONUS_ENABLED[type.ordinal()];
    }

    private static void buildTooltips(ModConfigSpec.Builder builder) {
        builder.comment("Generic Tooltip Settings").push("ToolTip_Settings");
        HIDE_MET_REQS = builder.comment("Should met reqs be hidden on the tooltip.").define("Hide Met Req Tooltips", true);
        builder.pop();
        builder.comment("This section covers the various tooltip elements and whether they should be enabled").push("Tooltip_Visibility");
        ArrayList<ReqType> rawReqList = new ArrayList<ReqType>(Arrays.asList(ReqType.values()));
        builder.push("Requirement_Tooltips");
        TOOLTIP_REQ_ENABLED = (ModConfigSpec.BooleanValue[])rawReqList.stream().map(t -> builder.define(t.toString() + " Req  tooltip enabled", true)).toArray(ModConfigSpec.BooleanValue[]::new);
        builder.pop();
        ArrayList<EventType> rawEventList = new ArrayList<EventType>(Arrays.asList(EventType.values()));
        builder.push("Xp_Gain_Tooltips");
        TOOLTIP_XP_ENABLED = (ModConfigSpec.BooleanValue[])rawEventList.stream().map(t -> builder.define(t.toString() + " XP Gain  tooltip enabled", true)).toArray(ModConfigSpec.BooleanValue[]::new);
        builder.pop();
        ArrayList<ModifierDataType> rawBonusList = new ArrayList<ModifierDataType>(Arrays.asList(ModifierDataType.values()));
        builder.push("Bonus_Tooltips");
        TOOLTIP_BONUS_ENABLED = (ModConfigSpec.BooleanValue[])rawBonusList.stream().map(t -> builder.define(t.toString() + " Bonus  tooltip enabled", true)).toArray(ModConfigSpec.BooleanValue[]::new);
        builder.pop();
        builder.pop();
    }

    private static void buildVein(ModConfigSpec.Builder builder) {
        builder.comment("Client Settings Related to the Vein Mining Ability").push("Vein_Miner");
        VEIN_LIMIT = builder.comment("The max blocks a vein activation should consume regardless of charge").defineInRange("Vein_Limit", 64, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    private static void buildTutorial(ModConfigSpec.Builder builder) {
        builder.comment("Toggles for helpful features related to mechanics").push("Tutorial");
        BREAK_NERF_HIGHLIGHTS = builder.comment("Should blocks affected by Reuse Penalty show a red outline?").define("Enable Reuse Penalty Highlights", true);
        BLOCK_OWNER_HIGHLIGHTS = builder.comment("Should the owner of a block show when hovering?").define("Enable Owner Highlights", true);
        SALVAGE_HIGHLIGHTS = builder.comment("Should hovering over a salvage block show helpful tips?").define("Enable Salvage Tips", true);
        BREAK_SPEED_PERKS = builder.comment("Are break speed perks enabled. can be toggled in-game with a keybind").define("break_speed_enabled", true);
        builder.pop();
    }

    private static void setupCommon(ModConfigSpec.Builder builder) {
        builder.comment(new String[]{"===============================================", "", "", "Project MMO is primarily configured with datapacks.", "you can generate one via in-game commands", "start by running '/pmmo genData begin' to clear any previous settings", "then run         '/pmmo genData withConfigs' to include the settings typically found in server configs", "then run         '/pmmo genData create' to have a new datapack created in your world's datapacks folder", "", "Under every mod id, you will find pmmo folders with files for all of the items/blocks/entities in the game.", "Under '/data/pmmo/configs/' are all of the server configs for things like xp, mob scaling, and AutoValues", "", "If you are not fond of datapacks, PMMO also provides a script-like option via '.pmmo' files.", "If you would like more information on scripting or more details on the datapack configs, please check out the wiki", "https://moddedmc.wiki/en/project/pmmo/1.21.1/docs", "", "", "==============================================="}).push("Common");
        Config.buildMsLoggy(builder);
        builder.pop();
    }

    private static void buildMsLoggy(ModConfigSpec.Builder builder) {
        builder.comment(new String[]{"PMMO Error Logging Configuration", "", "===================================================", "To enable Logging with MsLoggy, enter a logging", "keyword into the logging level list that you want.", "the list of keywords are (lowercase only):", "'api', 'autovalues', 'chunk', 'data', 'event', ", "'feature', 'gui', 'loading', 'network', 'req', and 'xp'", "==================================================="}).push("Ms Loggy");
        INFO_LOGGING = builder.comment(new String[]{"Which MsLoggy info logging should be enabled?  This will flood your log with data, but provides essential details", " when trying to find data errors and bug fixing.  "}).defineList("Info Logging", new ArrayList<String>(List.of(MsLoggy.LOG_CODE.LOADING.code, MsLoggy.LOG_CODE.NETWORK.code, MsLoggy.LOG_CODE.API.code)), s -> s instanceof String);
        DEBUG_LOGGING = builder.comment(new String[]{"Which MsLoggy debug logging should be enabled?  This will flood your log with data, but provides essential details", " when trying to find bugs. DEVELOPER SETTING (mostly).  "}).defineList("Debug Logging", new ArrayList<String>(List.of(MsLoggy.LOG_CODE.AUTO_VALUES.code)), s -> s instanceof String);
        WARN_LOGGING = builder.comment("Which MsLoggy warn logging should be enabled?  This log type is helpful for catching important but non-fatal issues").defineList("Warn Logging", new ArrayList<String>(List.of(MsLoggy.LOG_CODE.API.code)), s -> s instanceof String);
        ERROR_LOGGING = builder.comment(new String[]{"Which Error Logging should be enabled.  it is highly recommended this stay true.  however, you can", "disable it to remove pmmo errors from the log."}).defineList("Error Logging", new ArrayList<String>(List.of(MsLoggy.LOG_CODE.DATA.code, MsLoggy.LOG_CODE.API.code)), s -> s instanceof String);
        FATAL_LOGGING = builder.comment("Which MsLoggy fatal logging should be enabled?  I can't imagine a situation where you'd want this off, but here you go.").defineList("Fatal Logging", new ArrayList<String>(List.of(MsLoggy.LOG_CODE.API.code)), s -> s instanceof String);
        builder.pop();
    }

    static {
        ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        Config.setupClient(CLIENT_BUILDER);
        Config.setupCommon(COMMON_BUILDER);
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

