/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.util.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;

public record LocationData(boolean override, Set<String> tagValues, Map<ModifierDataType, Map<String, Double>> bonusMap, Map<ResourceLocation, Integer> positive, Map<ResourceLocation, Integer> negative, List<ResourceLocation> veinBlacklist, Map<String, Long> travelReq, List<MobModifier> globalModifiers, Map<ResourceLocation, List<MobModifier>> mobModifiers) implements DataSource<LocationData>
{
    public static final MapCodec<LocationData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("override").forGetter(ld -> Optional.of(ld.override())), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("isTagFor").forGetter(ld -> Optional.of(new ArrayList<String>(ld.tagValues()))), (App)Codec.optionalField((String)"bonus", (Codec)Codec.simpleMap(ModifierDataType.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])ModifierDataType.values())).codec(), (boolean)false).forGetter(ld -> Optional.of(ld.bonusMap())), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).optionalFieldOf("positive_effect").forGetter(ld -> Optional.of(ld.positive())), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).optionalFieldOf("negative_effect").forGetter(ld -> Optional.of(ld.negative())), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("vein_blacklist").forGetter(ld -> Optional.of(ld.veinBlacklist())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.LONG).optionalFieldOf("travel_req").forGetter(ld -> Optional.of(ld.travelReq())), (App)MobModifier.CODEC.listOf().optionalFieldOf("global_mob_modifier").forGetter(ld -> Optional.of(ld.globalModifiers)), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)MobModifier.CODEC.listOf()).optionalFieldOf("mob_modifier").forGetter(ld -> Optional.of(ld.mobModifiers()))).apply((Applicative)instance, (override, tags, bonus, pos, neg, vein, req, global, mobs) -> new LocationData(override.orElse(false), new HashSet<String>(tags.orElse(List.of())), DataSource.clearEmptyValues(bonus.orElse(new HashMap())), DataSource.clearEmptyValues(pos.orElse(new HashMap())), DataSource.clearEmptyValues(neg.orElse(new HashMap())), new ArrayList<ResourceLocation>(vein.orElse(new ArrayList())), DataSource.clearEmptyValues(req.orElse(new HashMap())), new ArrayList<MobModifier>(global.orElse(new ArrayList())), DataSource.clearEmptyValues(mobs.orElse(new HashMap())))));

    public LocationData(boolean override) {
        this(override, new HashSet<String>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<ResourceLocation, Integer>(), new ArrayList<ResourceLocation>(), new HashMap<String, Long>(), new ArrayList<MobModifier>(), new HashMap<ResourceLocation, List<MobModifier>>());
    }

    public LocationData() {
        this(false, new HashSet<String>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<ResourceLocation, Integer>(), new ArrayList<ResourceLocation>(), new HashMap<String, Long>(), new ArrayList<MobModifier>(), new HashMap<ResourceLocation, List<MobModifier>>());
    }

    @Override
    public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return this.bonusMap().getOrDefault(type, new HashMap());
    }

    @Override
    public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
        this.bonusMap().put(type, bonuses);
    }

    @Override
    public Map<String, Long> getReqs(ReqType type, CompoundTag nbt) {
        return this.travelReq();
    }

    @Override
    public void setReqs(ReqType type, Map<String, Long> reqs) {
        this.travelReq().clear();
        this.travelReq().putAll(reqs);
    }

    @Override
    public Map<ResourceLocation, Integer> getNegativeEffect() {
        return this.negative();
    }

    @Override
    public void setNegativeEffects(Map<ResourceLocation, Integer> neg) {
        this.negative().clear();
        this.negative().putAll(neg);
    }

    @Override
    public Map<ResourceLocation, Integer> getPositiveEffect() {
        return this.positive();
    }

    @Override
    public void setPositiveEffects(Map<ResourceLocation, Integer> pos) {
        this.positive().clear();
        this.positive().putAll(pos);
    }

    @Override
    public Set<String> getTagValues() {
        return this.tagValues();
    }

    @Override
    public LocationData combine(LocationData two) {
        HashSet<String> tagValues = new HashSet<String>();
        HashMap<ModifierDataType, Map<String, Double>> bonusMap = new HashMap<ModifierDataType, Map<String, Double>>();
        HashMap<ResourceLocation, Integer> positive = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, Integer> negative = new HashMap<ResourceLocation, Integer>();
        ArrayList<ResourceLocation> veinBlacklist = new ArrayList<ResourceLocation>();
        HashMap<String, Long> travelReq = new HashMap<String, Long>();
        ArrayList<MobModifier> globalModifiers = new ArrayList<MobModifier>();
        HashMap<ResourceLocation, List<MobModifier>> mobModifiers = new HashMap<ResourceLocation, List<MobModifier>>();
        BiConsumer<LocationData, LocationData> bothOrNeither = (o, t) -> {
            tagValues.addAll(o.tagValues());
            t.tagValues().forEach(rl -> {
                if (!tagValues.contains(rl)) {
                    tagValues.add((String)rl);
                }
            });
            bonusMap.putAll(o.bonusMap());
            t.bonusMap().forEach((key, value) -> bonusMap.merge((ModifierDataType)key, (Map<String, Double>)value, (oldV, newV) -> {
                HashMap mergedMap = new HashMap(oldV);
                newV.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            positive.putAll(o.positive());
            t.positive().forEach((key, value) -> positive.merge((ResourceLocation)key, (Integer)value, (o1, n1) -> o1 > n1 ? o1 : n1));
            negative.putAll(o.negative());
            t.negative().forEach((key, value) -> negative.merge((ResourceLocation)key, (Integer)value, (o1, n1) -> o1 > n1 ? o1 : n1));
            veinBlacklist.addAll(o.veinBlacklist());
            t.veinBlacklist().forEach(rl -> {
                if (!veinBlacklist.contains(rl)) {
                    veinBlacklist.add((ResourceLocation)rl);
                }
            });
            travelReq.putAll(o.travelReq());
            t.travelReq().forEach((key, value) -> travelReq.merge((String)key, (Long)value, (o1, n1) -> o1 > n1 ? o1 : n1));
            globalModifiers.addAll(o.globalModifiers());
            t.globalModifiers().forEach(modifier -> {
                if (!globalModifiers.contains(modifier)) {
                    globalModifiers.add((MobModifier)modifier);
                }
            });
            mobModifiers.putAll(o.mobModifiers());
            t.mobModifiers().forEach((key, value) -> mobModifiers.computeIfAbsent((ResourceLocation)key, id -> new ArrayList()).addAll(value));
        };
        Functions.biPermutation(this, two, this.override(), two.override(), (o, t) -> {
            tagValues.addAll(o.tagValues().isEmpty() ? t.tagValues() : o.tagValues());
            bonusMap.putAll(o.bonusMap().isEmpty() ? t.bonusMap() : o.bonusMap());
            positive.putAll(o.positive().isEmpty() ? t.positive() : o.positive());
            negative.putAll(o.negative().isEmpty() ? t.negative() : o.negative());
            veinBlacklist.addAll(o.veinBlacklist().isEmpty() ? t.veinBlacklist() : o.veinBlacklist());
            travelReq.putAll(o.travelReq().isEmpty() ? t.travelReq() : o.travelReq());
            globalModifiers.addAll(o.globalModifiers().isEmpty() ? t.globalModifiers() : o.globalModifiers());
            mobModifiers.putAll(o.mobModifiers().isEmpty() ? t.mobModifiers() : o.mobModifiers());
        }, bothOrNeither, bothOrNeither);
        return new LocationData(this.override() || two.override(), tagValues, bonusMap, positive, negative, veinBlacklist, travelReq, globalModifiers, mobModifiers);
    }

    @Override
    public boolean isUnconfigured() {
        return this.bonusMap.values().stream().allMatch(map -> map.isEmpty()) && this.positive.isEmpty() && this.negative.isEmpty() && this.veinBlacklist.isEmpty() && this.travelReq.isEmpty() && this.mobModifiers.isEmpty();
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        boolean override = false;
        Set<String> tagValues = new HashSet<String>();
        Map<ModifierDataType, Map<String, Double>> bonusMap = new HashMap<ModifierDataType, Map<String, Double>>();
        Map<ResourceLocation, Integer> positive = new HashMap<ResourceLocation, Integer>();
        Map<ResourceLocation, Integer> negative = new HashMap<ResourceLocation, Integer>();
        List<ResourceLocation> veinBlacklist = new ArrayList<ResourceLocation>();
        Map<String, Long> travelReq = new HashMap<String, Long>();
        List<MobModifier> globalModifiers = new ArrayList<MobModifier>();
        Map<ResourceLocation, List<MobModifier>> mobModifiers = new HashMap<ResourceLocation, List<MobModifier>>();

        protected Builder() {
        }

        public Builder setOverride(boolean override) {
            this.override = override;
            return this;
        }

        public Builder addTag(String ... id) {
            this.tagValues.addAll(Arrays.asList(id));
            return this;
        }

        public Builder addTag(TagKey<?> ... id) {
            List<String> ids = Arrays.stream(id).map(key -> "#" + String.valueOf(key.location())).toList();
            this.tagValues.addAll(ids);
            return this;
        }

        public Builder addReq(Map<String, Long> req) {
            this.travelReq.putAll(req);
            return this;
        }

        public Builder addNegativeEffect(Holder<MobEffect> id, int level) {
            this.negative.put(((ResourceKey)id.unwrapKey().get()).location(), level);
            return this;
        }

        public Builder addPositiveEffect(Holder<MobEffect> id, int level) {
            this.positive.put(((ResourceKey)id.unwrapKey().get()).location(), level);
            return this;
        }

        public Builder addBonus(ModifierDataType type, Map<String, Double> bonus) {
            this.bonusMap.put(type, bonus);
            return this;
        }

        public Builder addVeinBlacklist(ResourceLocation ... id) {
            this.veinBlacklist.addAll(Arrays.stream(id).toList());
            return this;
        }

        public Builder addGlobalModifier(MobModifier ... modifiers) {
            this.globalModifiers.addAll(Arrays.stream(modifiers).toList());
            return this;
        }

        public Builder addMobModifier(ResourceLocation mobId, MobModifier modifier) {
            this.mobModifiers.computeIfAbsent(mobId, id -> new ArrayList()).add(modifier);
            return this;
        }

        public LocationData end() {
            return new LocationData(this.override, this.tagValues, this.bonusMap, this.positive, this.negative, this.veinBlacklist, this.travelReq, this.globalModifiers, this.mobModifiers);
        }
    }
}

