/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.readers;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHelper {
    static final Logger LOGGER = LogManager.getLogger();

    private ConfigHelper() {
    }

    public static <T> T register(ModConfig.Type configType, Function<ModConfigSpec.Builder, T> configFactory) {
        return ConfigHelper.register(configType, configFactory, null);
    }

    public static <T> T register(ModConfig.Type configType, Function<ModConfigSpec.Builder, T> configFactory, @Nullable String configName) {
        ModLoadingContext modContext = ModLoadingContext.get();
        org.apache.commons.lang3.tuple.Pair entry = new ModConfigSpec.Builder().configure(configFactory);
        Object config = entry.getLeft();
        ModConfigSpec spec = (ModConfigSpec)entry.getRight();
        if (configName == null) {
            modContext.getActiveContainer().registerConfig(configType, (IConfigSpec)spec);
        } else {
            modContext.getActiveContainer().registerConfig(configType, (IConfigSpec)spec, configName + ".toml");
        }
        return (T)config;
    }

    public static <T> ConfigObject<T> defineObject(ModConfigSpec.Builder builder, String name, Codec<T> codec, T defaultObject) {
        DataResult encodeResult = codec.encodeStart((DynamicOps)TomlConfigOps.INSTANCE, defaultObject);
        Object encodedObject = encodeResult.getOrThrow();
        ModConfigSpec.ConfigValue value = builder.define(name, encodedObject);
        return new ConfigObject<T>((ModConfigSpec.ConfigValue<Object>)value, codec, defaultObject, encodedObject);
    }

    public static class TomlConfigOps
    implements DynamicOps<Object> {
        public static final TomlConfigOps INSTANCE = new TomlConfigOps();

        public Object empty() {
            return NullObject.NULL_OBJECT;
        }

        public <U> U convertTo(DynamicOps<U> outOps, Object input) {
            if (input instanceof Config) {
                return (U)this.convertMap(outOps, input);
            }
            if (input instanceof Collection) {
                return (U)this.convertList(outOps, input);
            }
            if (input == null || input instanceof NullObject) {
                return (U)outOps.empty();
            }
            if (input instanceof Enum) {
                return (U)outOps.createString(((Enum)input).name());
            }
            if (input instanceof Temporal) {
                return (U)outOps.createString(input.toString());
            }
            if (input instanceof String) {
                String s = (String)input;
                return (U)outOps.createString(s);
            }
            if (input instanceof Boolean) {
                Boolean b = (Boolean)input;
                return (U)outOps.createBoolean(b.booleanValue());
            }
            if (input instanceof Number) {
                Number n = (Number)input;
                return (U)outOps.createNumeric(n);
            }
            throw new UnsupportedOperationException("TomlConfigOps was unable to convert toml value: " + String.valueOf(input));
        }

        public DataResult<Number> getNumberValue(Object input) {
            DataResult dataResult;
            if (input instanceof Number) {
                Number n = (Number)input;
                dataResult = DataResult.success((Object)n);
            } else {
                dataResult = DataResult.error(() -> "Not a number: " + String.valueOf(input));
            }
            return dataResult;
        }

        public DataResult<Boolean> getBooleanValue(Object input) {
            if (input instanceof Boolean) {
                Boolean b = (Boolean)input;
                return DataResult.success((Object)b);
            }
            if (input instanceof Number) {
                Number n = (Number)input;
                return DataResult.success((Object)(n.intValue() > 0 ? 1 : 0));
            }
            return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
        }

        public Object createBoolean(boolean value) {
            return value;
        }

        public boolean compressMaps() {
            return false;
        }

        public Object createNumeric(Number i) {
            return i;
        }

        public DataResult<String> getStringValue(Object input) {
            if (input instanceof Config || input instanceof Collection) {
                return DataResult.error(() -> "Not a string: " + String.valueOf(input));
            }
            return DataResult.success((Object)String.valueOf(input));
        }

        public Object createString(String value) {
            return value;
        }

        public DataResult<Object> mergeToList(Object list, Object value) {
            if (!(list instanceof Collection) && list != this.empty()) {
                return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            if (list != this.empty()) {
                Collection listAsCollection = (Collection)list;
                result.addAll(listAsCollection);
            }
            result.add(value);
            return DataResult.success(result);
        }

        public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
            if (!(map instanceof Config) && map != this.empty()) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
            }
            DataResult<String> stringResult = this.getStringValue(key);
            Optional badResult = stringResult.error();
            if (badResult.isPresent()) {
                return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
            }
            return stringResult.flatMap(s -> {
                CommentedConfig output = TomlFormat.newConfig();
                if (map != this.empty()) {
                    Config oldConfig = (Config)map;
                    output.addAll((UnmodifiableConfig)oldConfig);
                }
                output.add(s, value);
                return DataResult.success((Object)output);
            });
        }

        public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
            if (!(input instanceof Config)) {
                return DataResult.error(() -> "Not a Config: " + String.valueOf(input));
            }
            Config config = (Config)input;
            return DataResult.success(config.entrySet().stream().map(entry -> Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
        }

        public Object createMap(Stream<Pair<Object, Object>> map) {
            CommentedConfig result = TomlFormat.newConfig();
            map.forEach(arg_0 -> this.lambda$createMap$9((Config)result, arg_0));
            return result;
        }

        public DataResult<Stream<Object>> getStream(Object input) {
            if (input instanceof Collection) {
                Collection collection = (Collection)input;
                return DataResult.success(collection.stream());
            }
            return DataResult.error(() -> "Not a collection: " + String.valueOf(input));
        }

        public Object createList(Stream<Object> input) {
            return input.toList();
        }

        public Object remove(Object input, String key) {
            if (input instanceof Config) {
                Config oldConfig = (Config)input;
                CommentedConfig result = TomlFormat.newConfig();
                oldConfig.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(arg_0 -> TomlConfigOps.lambda$remove$12((Config)result, arg_0));
                return result;
            }
            return input;
        }

        public String toString() {
            return "TOML";
        }

        private static /* synthetic */ void lambda$remove$12(Config result, Config.Entry entry) {
            result.add(entry.getKey(), entry.getValue());
        }

        private /* synthetic */ void lambda$createMap$9(Config result, Pair p) {
            result.add((String)this.getStringValue(p.getFirst()).getOrThrow(), p.getSecond());
        }
    }

    public static class ConfigObject<T>
    implements Supplier<T> {
        @Nonnull
        private final ModConfigSpec.ConfigValue<Object> value;
        @Nonnull
        private final Codec<T> codec;
        @Nonnull
        private Object cachedObject;
        @Nonnull
        private T parsedObject;
        @Nonnull
        private T defaultObject;

        private ConfigObject(ModConfigSpec.ConfigValue<Object> value, Codec<T> codec, T defaultObject, Object encodedDefaultObject) {
            this.value = value;
            this.codec = codec;
            this.defaultObject = defaultObject;
            this.parsedObject = defaultObject;
            this.cachedObject = encodedDefaultObject;
        }

        @Override
        @Nonnull
        public T get() {
            Object freshObject = this.value.get();
            if (!Objects.equals(this.cachedObject, freshObject)) {
                this.cachedObject = freshObject;
                this.parsedObject = this.getReparsedObject(freshObject);
            }
            return this.parsedObject;
        }

        private T getReparsedObject(Object obj) {
            DataResult parseResult = this.codec.parse((DynamicOps)TomlConfigOps.INSTANCE, obj);
            return (T)parseResult.resultOrPartial(err -> LOGGER.error("Config failure: Using default config value due to parsing error: {}", err)).orElseGet(() -> this.defaultObject);
        }
    }
}

