/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.scripting;

import harmonised.pmmo.config.scripting.Expression;
import harmonised.pmmo.util.MsLoggy;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.neoforged.fml.loading.FMLPaths;

public class Scripting {
    public static void readFiles(RegistryAccess access) {
        Path filePath = FMLPaths.CONFIGDIR.get();
        try (Stream<Path> stream = Files.walk(filePath, new FileVisitOption[0]);){
            for (Path path2 : stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".pmmo")).toList()) {
                MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Loading script from {}", path2);
                Scripting.read(access, new String(Files.readAllBytes(path2)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void read(RegistryAccess access, String rawString) {
        Scripting.read(access, rawString.lines().filter(str -> !str.startsWith("//")).toList());
    }

    public static void read(RegistryAccess access, List<String> lines) {
        Object currentNode = "";
        StringBuilder multiLine = new StringBuilder();
        ArrayList<Expression> builders = new ArrayList<Expression>();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String str;
            int eolci = (str = iterator.next()).indexOf("//");
            String strippedOfComments = str.substring(0, eolci == -1 ? Math.max(0, str.length()) : eolci);
            String trimmed = strippedOfComments.replaceAll("^[ \\t]+", "").replaceAll("[ \\t]+$", "");
            if (trimmed.isEmpty()) continue;
            if (trimmed.startsWith("WITH")) {
                currentNode = trimmed.replaceAll("^WITH ?", "");
                if (!((String)currentNode).endsWith(".")) {
                    currentNode = (String)currentNode + ".";
                }
                multiLine = new StringBuilder();
                continue;
            }
            if (trimmed.startsWith("END")) {
                currentNode = "";
                multiLine = new StringBuilder();
                continue;
            }
            if (!trimmed.endsWith(";")) {
                multiLine.append(trimmed);
                continue;
            }
            List<Expression> exprs = Expression.create(access, (String)currentNode + String.valueOf(multiLine) + trimmed).stream().filter(Expression::isValid).toList();
            multiLine = new StringBuilder();
            builders.addAll(exprs);
        }
        builders.forEach(Expression::commit);
    }
}

