/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.writers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.Reference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagFile;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.LogicalSide;

public class PackGenerator {
    public static final String PACKNAME = "generated_pack";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static boolean applyOverride = false;
    public static boolean applyDefaults = false;
    public static boolean applyDisabler = false;
    public static boolean applySimple = false;
    public static boolean applyObjects = true;
    public static boolean applyConfigs = false;
    public static List<String> namespaceFilter = new ArrayList<String>();
    public static Set<ServerPlayer> players = new HashSet<ServerPlayer>();
    private static final Filter defaultFilter = new Filter(List.of(new BlockFilter(Optional.empty(), Optional.of("pmmo"))));

    public static int generatePack(MinecraftServer server) {
        Path filepath = server.getWorldPath(LevelResource.DATAPACK_DIR).resolve(PACKNAME);
        filepath.toFile().mkdirs();
        Path packPath = filepath.resolve("pack.mcmeta");
        try {
            Files.writeString(packPath, (CharSequence)gson.toJson(PackGenerator.getPackObject(applyDisabler)), Charset.defaultCharset(), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.out.println("Error While Generating pack.mcmeta for Generated Data: " + e.toString());
        }
        for (Category category : Category.values()) {
            if (category.equals((Object)Category.CONFIGS) && !applyConfigs || !category.equals((Object)Category.CONFIGS) && !category.equals((Object)Category.TAGS) && !applyObjects) continue;
            List<ResourceLocation> filteredList = namespaceFilter.isEmpty() || category == Category.TAGS ? (List<ResourceLocation>)((Object)category.valueList.apply(server)) : category.valueList.apply(server).stream().filter(id -> namespaceFilter.contains(id.getNamespace())).toList();
            for (ResourceLocation id2 : filteredList) {
                int index = id2.getPath().lastIndexOf(47);
                String pathRoute = id2.getPath().substring(0, Math.max(index, 0));
                Path finalPath = filepath.resolve("data/" + id2.getNamespace() + "/" + category.route + "/" + pathRoute);
                finalPath.toFile().mkdirs();
                try {
                    Files.writeString(finalPath.resolve(id2.getPath().substring(id2.getPath().lastIndexOf(47) + 1) + ".json"), (CharSequence)category.defaultData.apply(id2), Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    System.out.println("Error While Generating Pack File For: " + id2.toString() + " (" + e.toString() + ")");
                }
            }
        }
        PackGenerator.generatePlayerConfigs(server, players);
        return 0;
    }

    public static void generatePlayerConfigs(MinecraftServer server, Collection<ServerPlayer> players) {
        Path filepath = server.getWorldPath(LevelResource.DATAPACK_DIR).resolve("generated_pack/data/minecraft/pmmo/players/");
        filepath.toFile().mkdirs();
        for (ServerPlayer player : players) {
            String idString = player.getUUID().toString();
            try {
                Files.writeString(filepath.resolve(idString + ".json"), (CharSequence)gson.toJson((JsonElement)PlayerData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new PlayerData()).result().get()), Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                System.out.println("Error While Generating Pack File For: " + idString + " (" + String.valueOf(e) + ")");
            }
        }
    }

    private static JsonElement getPackObject(boolean isDisabler) {
        McMeta pack = new McMeta(new Pack(isDisabler ? "Generated Resources including a disabler filter for PMMO's defaults" : "Generated Resources", 9), isDisabler ? Optional.of(defaultFilter) : Optional.empty());
        return (JsonElement)McMeta.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pack).result().get();
    }

    private static enum Category {
        ITEMS("pmmo/items", server -> BuiltInRegistries.ITEM.keySet(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            ObjectData existing = core.getLoader().ITEM_LOADER.getData((ResourceLocation)id);
            ObjectData data = new ObjectData(applyOverride, new HashSet<String>(), Arrays.stream(ReqType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? existing.reqs().getOrDefault(r, AutoValues.getRequirements(r, id, ObjectType.ITEM)) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(ReqType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? (List)existing.nbtReqs().getOrDefault(r, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), applyDefaults ? existing.negativeEffects() : new HashMap<ResourceLocation, Integer>(), Arrays.stream(EventType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? existing.xpValues().getOrDefault(e, AutoValues.getExperienceAward(e, id, ObjectType.ITEM)) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Stream.of(EventType.RECEIVE_DAMAGE, EventType.DEAL_DAMAGE).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (Map)existing.damageXpValues().getOrDefault(e, new HashMap()) : new HashMap())), Stream.of(EventType.RECEIVE_DAMAGE, EventType.DEAL_DAMAGE).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (Map)existing.nbtDamageValues().getOrDefault(e, new HashMap()) : new HashMap())), Arrays.stream(EventType.ITEM_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (List)existing.nbtXpValues().getOrDefault(e, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), Arrays.stream(new ModifierDataType[]{ModifierDataType.WORN, ModifierDataType.HELD}).collect(Collectors.toMap(m -> m, m -> applyDefaults ? (Map)existing.bonuses().getOrDefault(m, new HashMap()) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(new ModifierDataType[]{ModifierDataType.WORN, ModifierDataType.HELD}).collect(Collectors.toMap(m -> m, m -> applyDefaults ? (List)existing.nbtBonuses().getOrDefault(m, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, m -> (List)m.getValue())), applyDefaults ? existing.salvage() : Map.of(Reference.of("modid:item"), APIUtils.SalvageBuilder.start().build()), applyDefaults ? existing.veinData() : VeinData.EMPTY);
            JsonObject raw = ((JsonElement)ObjectData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            return gson.toJson((JsonElement)raw);
        }),
        BLOCKS("pmmo/blocks", server -> BuiltInRegistries.BLOCK.keySet(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            ObjectData existing = core.getLoader().BLOCK_LOADER.getData((ResourceLocation)id);
            ObjectData data = new ObjectData(applyOverride, new HashSet<String>(), Arrays.stream(ReqType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? existing.reqs().getOrDefault(r, AutoValues.getRequirements(r, id, ObjectType.BLOCK)) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(ReqType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? (List)existing.nbtReqs().getOrDefault(r, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ResourceLocation, Integer>(), Arrays.stream(EventType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? existing.xpValues().getOrDefault(e, AutoValues.getExperienceAward(e, id, ObjectType.BLOCK)) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), new HashMap<EventType, Map<String, Map<String, Long>>>(), new HashMap<EventType, Map<String, List<LogicEntry>>>(), Arrays.stream(EventType.BLOCK_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (List)existing.nbtXpValues().getOrDefault(e, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), applyDefaults ? existing.veinData() : new VeinData(Optional.empty(), Optional.empty(), Optional.of(1)));
            JsonObject raw = ((JsonElement)ObjectData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            raw.remove("negative_effect");
            raw.remove("bonuses");
            raw.remove("damage_type_xp");
            raw.remove("nbt_damage_type_xp");
            raw.remove("nbt_bonuses");
            raw.remove("salvage");
            return gson.toJson((JsonElement)raw);
        }),
        ENTITIES("pmmo/entities", server -> BuiltInRegistries.ENTITY_TYPE.keySet(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            ObjectData existing = core.getLoader().ENTITY_LOADER.getData((ResourceLocation)id);
            ObjectData data = new ObjectData(applyOverride, new HashSet<String>(), Arrays.stream(ReqType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? existing.reqs().getOrDefault(r, AutoValues.getRequirements(r, id, ObjectType.ENTITY)) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Arrays.stream(ReqType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(r -> r, r -> applyDefaults ? (List)existing.nbtReqs().getOrDefault(r, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ResourceLocation, Integer>(), Arrays.stream(EventType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? existing.xpValues().getOrDefault(e, AutoValues.getExperienceAward(e, id, ObjectType.ENTITY)) : new HashMap())).entrySet().stream().filter(entry -> !applySimple || !((Map)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (Map)e.getValue())), Stream.of(EventType.RECEIVE_DAMAGE, EventType.DEAL_DAMAGE).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (Map)existing.damageXpValues().getOrDefault(e, new HashMap()) : new HashMap())), Stream.of(EventType.RECEIVE_DAMAGE, EventType.DEAL_DAMAGE).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (Map)existing.nbtDamageValues().getOrDefault(e, new HashMap()) : new HashMap())), Arrays.stream(EventType.ENTITY_APPLICABLE_EVENTS).collect(Collectors.toMap(e -> e, e -> applyDefaults ? (List)existing.nbtXpValues().getOrDefault(e, new ArrayList()) : new ArrayList())).entrySet().stream().filter(entry -> !applySimple || !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> (List)e.getValue())), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), VeinData.EMPTY);
            JsonObject raw = ((JsonElement)ObjectData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            raw.remove("negative_effect");
            raw.remove("bonuses");
            raw.remove("nbt_bonuses");
            raw.remove("salvage");
            raw.remove("vein_data");
            return gson.toJson((JsonElement)raw);
        }),
        DIMENSIONS("pmmo/dimensions", server -> new HashSet<ResourceLocation>(server.levelKeys().stream().map(ResourceKey::location).toList()), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            LocationData existing = core.getLoader().DIMENSION_LOADER.getData((ResourceLocation)id);
            LocationData data = new LocationData(applyOverride, new HashSet<String>(), applyDefaults ? existing.bonusMap() : Map.of(ModifierDataType.DIMENSION, new HashMap()), new HashMap<ResourceLocation, Integer>(), new HashMap<ResourceLocation, Integer>(), applyDefaults ? existing.veinBlacklist() : new ArrayList<ResourceLocation>(), applyDefaults ? existing.travelReq() : new HashMap<String, Long>(), applyDefaults ? existing.globalModifiers() : new ArrayList<MobModifier>(), applyDefaults ? existing.mobModifiers() : new HashMap<ResourceLocation, List<MobModifier>>());
            JsonObject raw = ((JsonElement)LocationData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            raw.remove("positive_effect");
            raw.remove("negative_effect");
            raw.remove("isTagFor");
            return gson.toJson((JsonElement)raw);
        }),
        BIOMES("pmmo/biomes", server -> server.registryAccess().registryOrThrow(Registries.BIOME).keySet(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            LocationData existing = core.getLoader().BIOME_LOADER.getData((ResourceLocation)id);
            LocationData data = new LocationData(applyOverride, new HashSet<String>(), applyDefaults ? existing.bonusMap() : Map.of(ModifierDataType.BIOME, new HashMap()), applyDefaults ? existing.positive() : new HashMap<ResourceLocation, Integer>(), applyDefaults ? existing.negative() : new HashMap<ResourceLocation, Integer>(), applyDefaults ? existing.veinBlacklist() : new ArrayList<ResourceLocation>(), applyDefaults ? existing.travelReq() : new HashMap<String, Long>(), applyDefaults ? existing.globalModifiers() : new ArrayList<MobModifier>(), applyDefaults ? existing.mobModifiers() : new HashMap<ResourceLocation, List<MobModifier>>());
            JsonObject raw = ((JsonElement)LocationData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).result().get()).getAsJsonObject();
            return gson.toJson((JsonElement)raw);
        }),
        ENCHANTMENTS("pmmo/enchantments", server -> server.registryAccess().registryOrThrow(Registries.ENCHANTMENT).keySet(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            EnhancementsData existing = core.getLoader().ENCHANTMENT_LOADER.getData((ResourceLocation)id);
            return gson.toJson((JsonElement)EnhancementsData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new EnhancementsData(applyOverride, applyDefaults ? existing.skillArray() : new HashMap<Integer, Map<String, Long>>())).result().get());
        }),
        EFFECTS("pmmo/effects", server -> BuiltInRegistries.MOB_EFFECT.keySet(), id -> {
            Core core = Core.get(LogicalSide.SERVER);
            EnhancementsData existing = core.getLoader().EFFECT_LOADER.getData((ResourceLocation)id);
            return gson.toJson((JsonElement)EnhancementsData.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new EnhancementsData(applyOverride, applyDefaults ? existing.skillArray() : new HashMap<Integer, Map<String, Long>>())).result().get());
        }),
        TAGS("tags", server -> Set.of(Functions.pathPrepend(Reference.CROPS.location(), "blocks"), Functions.pathPrepend(Reference.CASCADING_BREAKABLES.location(), "blocks"), Functions.pathPrepend(Reference.BREEDABLE_TAG.location(), "entity_type"), Functions.pathPrepend(Reference.NO_XP_DAMAGE_DEALT.location(), "entity_type"), Functions.pathPrepend(Reference.MOB_TAG.location(), "entity_type"), Functions.pathPrepend(Reference.RIDEABLE_TAG.location(), "entity_type"), Functions.pathPrepend(Reference.TAMABLE_TAG.location(), "entity_type"), Functions.pathPrepend(Reference.BREWABLES.location(), "items"), Functions.pathPrepend(Reference.SMELTABLES.location(), "items"), Functions.pathPrepend(Reference.FROM_ENVIRONMENT.location(), "damage_type"), Functions.pathPrepend(Reference.FROM_IMPACT.location(), "damage_type"), Functions.pathPrepend(Reference.FROM_MAGIC.location(), "damage_type"), Functions.pathPrepend(Reference.FROM_GUN.location(), "damage_type")), id -> gson.toJson((JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(List.of(), false, List.of())).result().get())),
        CONFIGS("config", server -> Arrays.stream(ConfigListener.ServerConfigs.values()).map(sc -> Reference.rl(sc.filename)).collect(Collectors.toSet()), id -> {
            ConfigListener.ServerConfigs sc = ConfigListener.ServerConfigs.fromFilename(id.getPath());
            return sc == null ? "" : gson.toJson((JsonElement)ConfigListener.ServerConfigs.MAPPER.encodeStart((DynamicOps)JsonOps.INSTANCE, Config.CONFIG.get(sc)).result().get());
        });

        public String route;
        public Function<MinecraftServer, Set<ResourceLocation>> valueList;
        private Function<ResourceLocation, String> defaultData;

        private Category(String route, Function<MinecraftServer, Set<ResourceLocation>> values, Function<ResourceLocation, String> defaultData) {
            this.route = route;
            this.valueList = values;
            this.defaultData = defaultData;
        }
    }

    private record McMeta(Pack pack, Optional<Filter> filter) {
        public static final Codec<McMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Pack.CODEC.fieldOf("pack").forGetter(McMeta::pack), (App)Filter.CODEC.optionalFieldOf("filter").forGetter(McMeta::filter)).apply((Applicative)instance, McMeta::new));
    }

    private record Pack(String description, int format) {
        public static final Codec<Pack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(Pack::description), (App)Codec.INT.fieldOf("pack_format").forGetter(Pack::format)).apply((Applicative)instance, Pack::new));
    }

    private record Filter(List<BlockFilter> block) {
        public static final Codec<Filter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockFilter.CODEC.listOf().fieldOf("block").forGetter(Filter::block)).apply((Applicative)instance, Filter::new));
    }

    private record BlockFilter(Optional<String> namespace, Optional<String> path) {
        public static final Codec<BlockFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("namespace").forGetter(BlockFilter::namespace), (App)Codec.STRING.optionalFieldOf("path").forGetter(BlockFilter::path)).apply((Applicative)instance, BlockFilter::new));
    }
}

