/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import com.google.common.collect.LinkedListMultimap;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.commons.lang3.function.TriFunction;

@EventBusSubscriber(modid="pmmo", bus=EventBusSubscriber.Bus.GAME)
public class FeaturePerks {
    private static final CompoundTag NONE = new CompoundTag();
    private static final Map<String, Holder.Reference<Attribute>> attributeCache = new HashMap<String, Holder.Reference<Attribute>>();
    public static final Perk ATTRIBUTE = Perk.begin().addDefaults(TagBuilder.start().withDouble("max_boost", 0.0).withDouble("per_level", 0.0).withDouble("base", 0.0).withBool("multiplicative", false).build()).setStart((player, nbt) -> {
        double perLevel = nbt.getDouble("per_level");
        double maxBoost = nbt.getDouble("max_boost");
        AttributeInstance instance = player.getAttribute(FeaturePerks.getAttribute(nbt));
        if (instance == null) {
            return NONE;
        }
        double boost = Math.min(perLevel * (double)nbt.getInt("level"), maxBoost) + nbt.getDouble("base");
        AttributeModifier.Operation operation = nbt.getBoolean("multiplicative") ? AttributeModifier.Operation.ADD_MULTIPLIED_BASE : AttributeModifier.Operation.ADD_VALUE;
        ResourceLocation attributeID = FeaturePerks.attributeID(nbt.getString("attribute"), nbt.getString("skill"));
        AttributeModifier modifier = new AttributeModifier(attributeID, boost, operation);
        instance.removeModifier(attributeID);
        instance.addPermanentModifier(modifier);
        return NONE;
    }).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
        double perLevel = settings.getDouble("per_level");
        String skillname = settings.getString("skill");
        int skillLevel = settings.getInt("level");
        String attrName = FeaturePerks.getAttribute(settings) == null ? settings.getString("attribute") : ((Attribute)FeaturePerks.getAttribute(settings).value()).getDescriptionId();
        return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(Component.translatable((String)attrName)), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(perLevel, Component.translatable((String)("pmmo." + skillname))), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(perLevel * (double)skillLevel));
    }).build();
    private static final LinkedListMultimap<Player, AttributeRecord> respawnAttributes = LinkedListMultimap.create();
    public static final Perk TEMP_ATTRIBUTE = Perk.begin().addDefaults(ATTRIBUTE.propertyDefaults()).setStart((player, nbt) -> {
        double perLevel = nbt.getDouble("per_level");
        double maxBoost = nbt.getDouble("max_boost");
        AttributeInstance instance = player.getAttribute(FeaturePerks.getAttribute(nbt));
        double boost = Math.min(perLevel * (double)nbt.getInt("level"), maxBoost) + nbt.getDouble("base");
        AttributeModifier.Operation operation = nbt.getBoolean("multiplicative") ? AttributeModifier.Operation.ADD_MULTIPLIED_BASE : AttributeModifier.Operation.ADD_VALUE;
        ResourceLocation attributeID = Reference.rl("temp+perk/" + nbt.getString("attribute").replace(':', '_') + "/" + nbt.getString("skill"));
        AttributeModifier modifier = new AttributeModifier(attributeID, boost, operation);
        if (instance.hasModifier(modifier.id())) {
            instance.removeModifier(attributeID);
        }
        instance.addTransientModifier(modifier);
        return NONE;
    }).setStop((player, nbt) -> {
        ResourceLocation attributeID = Reference.rl("temp+perk/" + nbt.getString("attribute").replace(':', '_') + "/" + nbt.getString("skill"));
        player.getAttribute(FeaturePerks.getAttribute(nbt)).removeModifier(attributeID);
        return NONE;
    }).setDescription(ATTRIBUTE.description()).setStatus(ATTRIBUTE.status()).build();
    public static BiFunction<Player, CompoundTag, CompoundTag> EFFECT_SETTER = (player, nbt) -> {
        Holder effect = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Reference.of(nbt.getString("effect"))).get();
        if (effect != null) {
            int skillLevel = nbt.getInt("level");
            int configDuration = nbt.getInt("duration");
            double perLevel = nbt.getDouble("per_level");
            int base = nbt.getInt("base");
            int calculatedDuration = (int)((double)skillLevel * (double)configDuration * perLevel) + base;
            calculatedDuration = Math.min(nbt.getInt("max_boost"), calculatedDuration);
            int duration = player.hasEffect(effect) && player.getEffect(effect).getDuration() > calculatedDuration ? player.getEffect(effect).getDuration() : calculatedDuration;
            int amplifier = nbt.getInt("modifier");
            boolean ambient = nbt.getBoolean("ambient");
            boolean visible = nbt.getBoolean("visible");
            boolean showIcon = nbt.getBoolean("show_icon");
            player.addEffect(new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon));
        }
        return NONE;
    };
    public static final Perk EFFECT = Perk.begin().addDefaults(TagBuilder.start().withString("effect", "modid:effect").withInt("duration", 100).withDouble("base", 0.0).withInt("per_level", 1).withInt("min_level", 1).withInt("max_boost", Integer.MAX_VALUE).withInt("modifier", 0).withBool("ambient", false).withBool("visible", true).withBool("show_icon", true).build()).setStart(EFFECT_SETTER).setTick((TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(player, nbt, ticks) -> EFFECT_SETTER.apply((Player)player, (CompoundTag)nbt))).setDescription(LangProvider.PERK_EFFECT_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_EFFECT_STATUS_1.asComponent(Component.translatable((String)((MobEffect)BuiltInRegistries.MOB_EFFECT.get(Reference.of(nbt.getString("effect")))).getDescriptionId())), LangProvider.PERK_EFFECT_STATUS_2.asComponent(nbt.getInt("modifier"), (double)nbt.getInt("duration") * nbt.getDouble("per_level") * (double)nbt.getInt("level") / 20.0))).build();
    private static BiFunction<Player, CompoundTag, List<MutableComponent>> JUMP_LINES = (player, nbt) -> List.of(LangProvider.PERK_JUMP_BOOST_STATUS_1.asComponent(nbt.getInt("per_level") * nbt.getInt("level")));
    private static CompoundTag JUMP_DEFAULTS = TagBuilder.start().withDouble("base", 0.0).withDouble("per_level", 5.0E-4).withDouble("max_boost", 0.25).build();
    public static final Perk JUMP_CLIENT = Perk.begin().addDefaults(JUMP_DEFAULTS).setStart((player, nbt) -> {
        double jumpBoost = Math.min(nbt.getDouble("max_boost"), -0.011 + (double)nbt.getInt("level") * nbt.getDouble("per_level")) + nbt.getDouble("base");
        player.setDeltaMovement(player.getDeltaMovement().add(0.0, jumpBoost, 0.0));
        player.hurtMarked = true;
        return NONE;
    }).setDescription(LangProvider.PERK_JUMP_BOOST_DESC.asComponent()).setStatus(JUMP_LINES).build();
    public static final Perk JUMP_SERVER = Perk.begin().addDefaults(JUMP_DEFAULTS).setStart((player, nbt) -> {
        double jumpBoost = Math.min(nbt.getDouble("max_boost"), -0.011 + (double)nbt.getInt("level") * nbt.getDouble("per_level")) + nbt.getDouble("base");
        return TagBuilder.start().withDouble("jump_boost_output", player.getDeltaMovement().y + jumpBoost).build();
    }).setDescription(LangProvider.PERK_JUMP_BOOST_DESC.asComponent()).setStatus(JUMP_LINES).build();
    public static final Perk BREATH = Perk.begin().addConditions((player, nbt) -> player.getAirSupply() < 2).addDefaults(TagBuilder.start().withLong("cooldown", 600L).withDouble("base", 0.0).withDouble("per_level", 1.0).withInt("max_boost", Integer.MAX_VALUE).build()).setStart((player, nbt) -> {
        int perLevel = Math.max(1, (int)((double)nbt.getInt("level") * nbt.getDouble("per_level"))) + nbt.getInt("base");
        perLevel = Math.min(nbt.getInt("max_boost"), perLevel);
        player.setAirSupply(player.getAirSupply() + perLevel);
        player.sendSystemMessage((Component)LangProvider.PERK_BREATH_REFRESH.asComponent());
        return NONE;
    }).setDescription(LangProvider.PERK_BREATH_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_BREATH_STATUS_1.asComponent((int)((double)nbt.getInt("level") * nbt.getDouble("per_level"))), LangProvider.PERK_BREATH_STATUS_2.asComponent(nbt.getInt("cooldown") / 20))).build();
    public static final Perk DAMAGE_REDUCE = Perk.begin().addConditions((player, nbt) -> {
        String perkApplicableDamageType = nbt.getString("for_damage");
        Registry damageRegistry = (Registry)player.level().registryAccess().registry(Registries.DAMAGE_TYPE).get();
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)damageRegistry.key(), (ResourceLocation)Reference.of(nbt.getString("damage_type")));
        if (perkApplicableDamageType.startsWith("#") && damageRegistry.getTag(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Reference.of(perkApplicableDamageType.substring(1)))).stream().anyMatch(typeTag -> typeTag.contains((Holder)damageRegistry.getHolder(resourceKey).get()))) {
            return true;
        }
        if (perkApplicableDamageType.endsWith(":*") && perkApplicableDamageType.substring(0, perkApplicableDamageType.indexOf(58)).equals(nbt.getString("damage_type").substring(0, nbt.getString("damage_type").indexOf(58)))) {
            return true;
        }
        return perkApplicableDamageType.equals(nbt.getString("damage_type"));
    }).addDefaults(TagBuilder.start().withDouble("per_level", 0.025).withDouble("base", 0.0).withFloat("damageIn", 0.0f).withString("damage_type", "missing").withInt("max_boost", Integer.MAX_VALUE).withString("for_damage", "omitted").build()).setStart((player, nbt) -> {
        float saved = nbt.getFloat("per_level") * (float)nbt.getInt("level") + nbt.getFloat("base");
        saved = Math.min(nbt.getFloat("max_boost"), saved);
        float baseDamage = nbt.contains("damage") ? nbt.getFloat("damage") : nbt.getFloat("damageIn");
        nbt.putFloat("damage", Math.max(baseDamage - saved, 0.0f));
        return nbt;
    }).setDescription(LangProvider.PERK_FALL_SAVE_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_FALL_SAVE_STATUS_1.asComponent((double)nbt.getInt("level") * nbt.getDouble("per_level")), LangProvider.PERK_BREATH_STATUS_2.asComponent(nbt.getInt("cooldown") / 20))).build();
    public static final String APPLICABLE_TO = "applies_to";
    public static final Perk DAMAGE_BOOST = Perk.begin().addConditions((player, nbt) -> {
        String perkApplicableDamageType = nbt.getString("damage_type");
        List<String> dmgType = nbt.getList("for_damage", 8).stream().map(Tag::getAsString).toList();
        boolean damageMatch = dmgType.isEmpty() || dmgType.stream().anyMatch(key -> {
            if (key.startsWith("#") && RegistryUtil.isInTag(player.level().registryAccess(), Registries.DAMAGE_TYPE, perkApplicableDamageType, key.substring(1))) {
                return true;
            }
            if (key.endsWith(":*") && Reference.of(perkApplicableDamageType).getNamespace().equals(key.replace(":*", ""))) {
                return true;
            }
            return key.equals(perkApplicableDamageType);
        });
        List<String> type = nbt.getList(APPLICABLE_TO, 8).stream().map(Tag::getAsString).toList();
        boolean weaponMatch = type.isEmpty() || type.stream().anyMatch(key -> {
            if (key.startsWith("#") && RegistryUtil.isInTag(player.level().registryAccess(), Registries.ITEM, RegistryUtil.getId(player.level().registryAccess(), player.getMainHandItem()), key.substring(1))) {
                return true;
            }
            if (key.endsWith(":*") && RegistryUtil.getId(player.getMainHandItem().getItemHolder()).getNamespace().equals(key.replace(":*", ""))) {
                return true;
            }
            return key.equals(RegistryUtil.getId(player.level().registryAccess(), player.getMainHandItem()).toString());
        });
        return weaponMatch && damageMatch;
    }).addDefaults(TagBuilder.start().withFloat("damageIn", 0.0f).withFloat("damage", 0.0f).withList("applies_to", new Tag[0]).withDouble("per_level", 0.05).withDouble("base", 1.0).withInt("max_boost", Integer.MAX_VALUE).withBool("multiplicative", true).build()).setStart((player, nbt) -> {
        float damageModification = (float)(nbt.getDouble("base") + nbt.getDouble("per_level") * (double)nbt.getInt("level"));
        damageModification = Math.min((float)nbt.getInt("max_boost"), damageModification);
        float damage = nbt.getBoolean("multiplicative") ? nbt.getFloat("damage") * damageModification : nbt.getFloat("damage") + damageModification;
        return TagBuilder.start().withFloat("damage", damage).build();
    }).setDescription(LangProvider.PERK_DAMAGE_BOOST_DESC.asComponent()).setStatus((player, nbt) -> {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        MutableComponent line1 = LangProvider.PERK_DAMAGE_BOOST_STATUS_1.asComponent();
        for (Tag entry : nbt.getList(APPLICABLE_TO, 8)) {
            Item item;
            MutableComponent description = Component.literal((String)entry.getAsString());
            if (ResourceLocation.tryParse((String)entry.getAsString()) != null && !(item = (Item)BuiltInRegistries.ITEM.get(Reference.of(entry.getAsString()))).equals(Items.AIR)) {
                description = item.getDescription();
            }
            line1.append((Component)description);
            line1.append((Component)Component.literal((String)", "));
        }
        lines.add(line1);
        lines.add(LangProvider.PERK_DAMAGE_BOOST_STATUS_2.asComponent(nbt.getBoolean("multiplicative") ? "x" : "+", (double)nbt.getInt("level") * nbt.getDouble("per_level")));
        return lines;
    }).build();
    private static final String COMMAND = "command";
    private static final String FUNCTION = "function";
    public static final Perk RUN_COMMAND = Perk.begin().setStart((p, nbt) -> {
        if (!(p instanceof ServerPlayer)) {
            return NONE;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (nbt.contains(FUNCTION)) {
            player.getServer().getFunctions().execute((CommandFunction)player.getServer().getFunctions().get(Reference.of(nbt.getString(FUNCTION))).get(), player.createCommandSourceStack().withSuppressedOutput().withMaximumPermission(2));
        } else if (nbt.contains(COMMAND)) {
            player.getServer().getCommands().performPrefixedCommand(player.createCommandSourceStack().withSuppressedOutput().withMaximumPermission(2), nbt.getString(COMMAND));
        }
        return NONE;
    }).setDescription(LangProvider.PERK_COMMAND_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_COMMAND_STATUS_1.asComponent(nbt.contains(FUNCTION) ? "Function" : "Command", nbt.contains(FUNCTION) ? nbt.getString(FUNCTION) : nbt.getString(COMMAND)))).build();
    public static final Perk VILLAGER_TRADING = Perk.begin().addConditions((player, tag) -> tag.getString("target").equals("minecraft:villager")).addDefaults(TagBuilder.start().withString("target", "missing").withDouble("base", 0.0).withInt("entity_id", -1).withDouble("per_level", 0.05).withLong("cooldown", 1000L).build()).setStart((player, nbt) -> {
        int villagerID = nbt.getInt("entity_id");
        Villager villager = (Villager)player.level().getEntity(villagerID);
        villager.onReputationEventFrom(ReputationEventType.ZOMBIE_VILLAGER_CURED, (Entity)player);
        player.sendSystemMessage((Component)LangProvider.PERK_VILLAGE_FEEDBACK.asComponent());
        return NONE;
    }).setDescription(LangProvider.PERK_VILLAGER_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_VILLAGE_STATUS_1.asComponent((double)nbt.getInt("level") * nbt.getDouble("per_level")))).build();

    private static Holder.Reference<Attribute> getAttribute(CompoundTag nbt) {
        return attributeCache.computeIfAbsent(nbt.getString("attribute"), name -> BuiltInRegistries.ATTRIBUTE.getHolder(Reference.of(name)).orElse(null));
    }

    private static ResourceLocation attributeID(String attribute, String skill) {
        return Reference.rl("perk/" + attribute.replace(':', '_') + "/" + skill);
    }

    @SubscribeEvent
    public static void saveAttributesOnDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (CompoundTag nbt : ((List)Config.perks().perks().getOrDefault(EventType.SKILL_UP, new ArrayList())).stream().filter(tag -> tag.getString("perk").equals("pmmo:attribute")).toList()) {
                Holder.Reference<Attribute> attribute = FeaturePerks.getAttribute(nbt);
                AttributeInstance instance = player.getAttributes().getInstance(attribute);
                if (instance == null) continue;
                instance.getModifiers().stream().filter(mod -> mod.id().equals((Object)FeaturePerks.attributeID(nbt.getString("attribute"), nbt.getString("skill")))).forEach(mod -> respawnAttributes.put((Object)player, (Object)new AttributeRecord((Holder<Attribute>)attribute, (AttributeModifier)mod)));
            }
        }
    }

    @SubscribeEvent
    public static void restoreAttributesOnSpawn(PlayerEvent.PlayerRespawnEvent event) {
        if (respawnAttributes.containsKey((Object)event.getEntity())) {
            respawnAttributes.get((Object)event.getEntity()).stream().filter(mod -> {
                AttributeInstance instance = event.getEntity().getAttribute(mod.attribute());
                return instance != null && !instance.hasModifier(mod.modifier().id());
            }).forEach(mod -> {
                AttributeInstance instance = event.getEntity().getAttribute(mod.attribute());
                if (instance != null) {
                    instance.addPermanentModifier(mod.modifier());
                }
            });
            respawnAttributes.get((Object)event.getEntity()).clear();
        }
    }

    private record AttributeRecord(Holder<Attribute> attribute, AttributeModifier modifier) {
    }
}

