/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class DeathHandler {
    public static void handle(LivingDeathEvent event) {
        if (event.getSource().getEntity() == null) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LivingEntity target = event.getEntity();
            if (target == null) {
                return;
            }
            if (target.equals((Object)player)) {
                return;
            }
            Core core = Core.get(player.level());
            if (!core.isActionPermitted(ReqType.WEAPON, player.getMainHandItem(), player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.WEAPON, player, player.getMainHandItem().getDisplayName());
                return;
            }
            if (!core.isActionPermitted(ReqType.KILL, (Entity)target, player)) {
                event.setCanceled(true);
                Messenger.sendDenialMsg(ReqType.KILL, player, target.getName());
                return;
            }
            boolean serverSide = player instanceof ServerPlayer;
            CompoundTag hookOutput = new CompoundTag();
            if (serverSide && (hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.DEATH, (Event)event, new CompoundTag())).getBoolean("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.DEATH, player, hookOutput));
            if (serverSide) {
                Map<String, Long> xpAward = core.getExperienceAwards(EventType.DEATH, (Entity)target, player, hookOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }
}

