/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.storage.Experience;
import java.math.BigInteger;
import java.util.HashMap;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class PlayerDeathHandler {
    public static void handle(LivingDeathEvent event) {
        if (Config.server().levels().lossOnDeath() == 0.0) {
            return;
        }
        Player player = (Player)event.getEntity();
        Core core = Core.get(player.level());
        new HashMap<String, Experience>(core.getData().getXpMap(player.getUUID())).forEach((skill, xp) -> {
            long lossScaled = Double.valueOf(Config.server().levels().lossOnDeath() * 10000.0).longValue();
            if (Config.server().levels().loseOnlyExcess()) {
                xp.addXp(-(xp.getXp() * lossScaled / 10000L));
            } else {
                BigInteger totalXp = BigInteger.valueOf(0L);
                for (long i = 0L; i < xp.getLevel().getLevel(); ++i) {
                    totalXp = totalXp.add(BigInteger.valueOf(Experience.XpLevel.getXpForNextLevel(i)));
                }
                totalXp = totalXp.multiply(BigInteger.valueOf(lossScaled));
                totalXp = totalXp.divide(BigInteger.valueOf(10000L));
                while (totalXp.longValue() > xp.getXp()) {
                    long currentXp = xp.getXp();
                    long upperLimit = xp.getLevel().getXpToGain() - 1L;
                    xp.getLevel().decrement();
                    xp.setXp(upperLimit);
                    totalXp.subtract(BigInteger.valueOf(currentXp));
                }
                xp.setXp(totalXp.longValue());
            }
            core.getData().getXpMap(player.getUUID()).put((String)skill, (Experience)xp);
        });
    }
}

