/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.anticheese.CheeseTracker;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.features.penalties.EffectManager;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PlayerTickHandler {
    private static final Map<UUID, Float> healthLast = new HashMap<UUID, Float>();
    private static final Map<UUID, Vec3> moveLast = new HashMap<UUID, Vec3>();

    public static void handle(PlayerTickEvent.Post event) {
        float healthDiff;
        if (event.getEntity().tickCount % 10 != 0) {
            return;
        }
        Player player = event.getEntity();
        Core core = Core.get(event.getEntity().level());
        if (player instanceof ServerPlayer) {
            VeinMiningLogic.regenerateVein((ServerPlayer)player);
            EffectManager.applyEffects(core, player);
        }
        if (!healthLast.containsKey(player.getUUID())) {
            healthLast.put(player.getUUID(), Float.valueOf(player.getHealth()));
        }
        if ((double)Math.abs(healthDiff = player.getHealth() - healthLast.getOrDefault(player.getUUID(), Float.valueOf(0.0f)).floatValue()) >= 0.01) {
            PlayerTickHandler.processEvent(healthDiff > 0.0f ? EventType.HEALTH_INCREASE : EventType.HEALTH_DECREASE, core, (PlayerTickEvent)event);
        }
        if (player.isPassenger()) {
            PlayerTickHandler.processEvent(EventType.RIDING, core, (PlayerTickEvent)event);
        }
        if (!player.getActiveEffects().isEmpty()) {
            PlayerTickHandler.processEvent(EventType.EFFECT, core, (PlayerTickEvent)event);
        }
        if (player.isUnderWater()) {
            PlayerTickHandler.processEvent(EventType.SUBMERGED, core, (PlayerTickEvent)event);
            Vec3 vec = player.getDeltaMovement();
            if (player.isSprinting()) {
                PlayerTickHandler.processEvent(EventType.SWIM_SPRINTING, core, (PlayerTickEvent)event);
            }
            double sinkingRate = 0.01;
            if (vec.y() > sinkingRate) {
                PlayerTickHandler.processEvent(EventType.SURFACING, core, (PlayerTickEvent)event);
            } else if (vec.y() < -sinkingRate) {
                PlayerTickHandler.processEvent(EventType.DIVING, core, (PlayerTickEvent)event);
            }
        } else if (player.isInWater()) {
            PlayerTickHandler.processEvent(EventType.SWIMMING, core, (PlayerTickEvent)event);
        } else if (player.isSprinting()) {
            PlayerTickHandler.processEvent(EventType.SPRINTING, core, (PlayerTickEvent)event);
        } else if (player.isCrouching()) {
            PlayerTickHandler.processEvent(EventType.CROUCH, core, (PlayerTickEvent)event);
        }
        healthLast.put(player.getUUID(), Float.valueOf(player.getHealth()));
        moveLast.put(player.getUUID(), player.position());
    }

    private static void processEvent(EventType type, Core core, PlayerTickEvent event) {
        CompoundTag eventHookOutput = new CompoundTag();
        boolean serverSide = core.getSide().equals((Object)LogicalSide.SERVER);
        if (serverSide) {
            eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(type, (Event)event, new CompoundTag());
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(type, event.getEntity(), eventHookOutput));
        if (serverSide) {
            Map<String, Double> ratio = Config.server().xpGains().playerXp(type);
            ResourceLocation source = Reference.mc("player");
            HashMap<String, Long> xpAward = perkOutput.contains("serialized_award_map") ? CoreUtils.deserializeAwardMap(perkOutput.getCompound("serialized_award_map")) : new HashMap();
            switch (type) {
                case HEALTH_INCREASE: 
                case HEALTH_DECREASE: {
                    PlayerTickHandler.processHealthChange(ratio, core, event.getEntity(), xpAward);
                    break;
                }
                case RIDING: {
                    source = RegistryUtil.getId(event.getEntity().getVehicle());
                    xpAward.putAll(core.getExperienceAwards(type, event.getEntity().getVehicle(), event.getEntity(), perkOutput));
                    break;
                }
                case EFFECT: {
                    for (MobEffectInstance mei : event.getEntity().getActiveEffects()) {
                        source = ((ResourceKey)mei.getEffect().unwrapKey().get()).location();
                        xpAward.putAll(core.getExperienceAwards(mei, event.getEntity(), perkOutput));
                    }
                    break;
                }
                case SPRINTING: {
                    Vec3 vec = event.getEntity().position();
                    Vec3 old = moveLast.getOrDefault(event.getEntity().getUUID(), vec);
                    double magnitude = Math.sqrt(Math.pow(Math.abs(vec.x() - old.x()), 2.0) + Math.pow(Math.abs(vec.y() - old.y()), 2.0) + Math.pow(Math.abs(vec.z() - old.z()), 2.0));
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.getEntity()).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
                case SUBMERGED: {
                    ratio.keySet().forEach(skill -> xpAward.put((String)skill, ratio.getOrDefault(skill, 0.0).longValue()));
                    break;
                }
                case SWIMMING: 
                case DIVING: 
                case SURFACING: 
                case SWIM_SPRINTING: {
                    Vec3 vec = event.getEntity().getDeltaMovement();
                    double magnitude = Math.sqrt(Math.pow(vec.x(), 2.0) + Math.pow(vec.y(), 2.0) + Math.pow(vec.z(), 2.0));
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * magnitude * core.getConsolidatedModifierMap(event.getEntity()).getOrDefault(skill, 1.0);
                        xpAward.put((String)skill, value.longValue());
                    });
                    break;
                }
            }
            CheeseTracker.applyAntiCheese(type, source, event.getEntity(), xpAward);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    private static void processHealthChange(Map<String, Double> ratio, Core core, Player player, Map<String, Long> xpAward) {
        float diff = Math.abs(healthLast.getOrDefault(player.getUUID(), Float.valueOf(0.0f)).floatValue() - player.getHealth());
        ratio.keySet().forEach(skill -> {
            Double value = ratio.getOrDefault(skill, 0.0) * (double)diff * core.getConsolidatedModifierMap(player).getOrDefault(skill, 1.0);
            xpAward.put((String)skill, value.longValue());
        });
    }
}

