/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.anticheese;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.codecs.ConfigData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.config.scripting.Functions;
import harmonised.pmmo.features.anticheese.CheeseTracker;
import java.util.HashMap;
import java.util.Map;

public record AntiCheeseConfig(boolean afkSubtract, Map<EventType, CheeseTracker.Setting> afk, Map<EventType, CheeseTracker.Setting> diminish, Map<EventType, CheeseTracker.Setting> normal) implements ConfigData<AntiCheeseConfig>
{
    private static final String AFK = "afk";
    private static final String AFK_SUB = "afk_can_subtract";
    private static final String DIM = "diminishing_xp";
    private static final String NORM = "normalization";
    private static final String EVENT = "event";
    public static final MapCodec<AntiCheeseConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf(AFK_SUB).forGetter(AntiCheeseConfig::afkSubtract), (App)Codec.unboundedMap(EventType.CODEC, CheeseTracker.Setting.CODEC).fieldOf(AFK).forGetter(AntiCheeseConfig::afk), (App)Codec.unboundedMap(EventType.CODEC, CheeseTracker.Setting.CODEC).fieldOf(DIM).forGetter(AntiCheeseConfig::diminish), (App)Codec.unboundedMap(EventType.CODEC, CheeseTracker.Setting.CODEC).fieldOf(NORM).forGetter(AntiCheeseConfig::normal)).apply((Applicative)instance, AntiCheeseConfig::new));

    public AntiCheeseConfig() {
        this(false, Map.of(EventType.SUBMERGED, CheeseTracker.Setting.build().minTime(200).reduction(0.1).cooloff(1).build(), EventType.SWIMMING, CheeseTracker.Setting.build().minTime(200).reduction(0.1).cooloff(1).build(), EventType.DIVING, CheeseTracker.Setting.build().minTime(200).reduction(0.1).cooloff(1).build(), EventType.SURFACING, CheeseTracker.Setting.build().minTime(200).reduction(0.1).cooloff(1).build(), EventType.SWIM_SPRINTING, CheeseTracker.Setting.build().minTime(200).reduction(0.1).cooloff(1).build()), Map.of(EventType.RIDING, CheeseTracker.Setting.build().source("minecraft:horse", "minecraft:boat").retention(200).reduction(0.005).build(), EventType.SWIMMING, CheeseTracker.Setting.build().retention(200).reduction(0.01).build(), EventType.DIVING, CheeseTracker.Setting.build().retention(200).reduction(0.01).build(), EventType.SURFACING, CheeseTracker.Setting.build().retention(200).reduction(0.01).build(), EventType.SWIM_SPRINTING, CheeseTracker.Setting.build().retention(200).reduction(0.01).build()), Map.of(EventType.SPRINTING, CheeseTracker.Setting.build().retention(400).tolerance(0.1).tolerance(10).build()));
    }

    @Override
    public MapCodec<AntiCheeseConfig> getCodec() {
        return CODEC;
    }

    @Override
    public ConfigListener.ServerConfigs getType() {
        return ConfigListener.ServerConfigs.ANTICHEESE;
    }

    @Override
    public ConfigData<AntiCheeseConfig> getFromScripting(String param, Map<String, String> value) {
        boolean afk_sub = param.equals(AFK_SUB) ? Functions.getBool(value) : this.afkSubtract();
        AntiCheeseConfig config = new AntiCheeseConfig(afk_sub, new HashMap<EventType, CheeseTracker.Setting>(this.afk()), new HashMap<EventType, CheeseTracker.Setting>(this.diminish()), new HashMap<EventType, CheeseTracker.Setting>(this.normal()));
        if (!value.containsKey(EVENT)) {
            return config;
        }
        EventType type = EventType.byName(value.get(EVENT));
        if (type == null) {
            return config;
        }
        switch (param) {
            case "afk": {
                config.afk().put(type, CheeseTracker.Setting.build().fromScripting(value));
                break;
            }
            case "diminishing_xp": {
                config.diminish().put(type, CheeseTracker.Setting.build().fromScripting(value));
                break;
            }
            case "normalization": {
                config.normal().put(type, CheeseTracker.Setting.build().fromScripting(value));
                break;
            }
        }
        return config;
    }

    @Override
    public AntiCheeseConfig combine(AntiCheeseConfig two) {
        return two;
    }

    @Override
    public boolean isUnconfigured() {
        return false;
    }
}

