/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.features.autovalues.AutoBlock;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class AutoItem {
    private static final double BASE_ATK_SPD = 1.6;
    private static final double BASE_DURABILITY = 59.0;
    private static final double BASE_DAMAGE = 4.0;
    public static final ReqType[] REQTYPES = new ReqType[]{ReqType.WEAR, ReqType.USE_ENCHANTMENT, ReqType.TOOL, ReqType.WEAPON};
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.ANVIL_REPAIR, EventType.BLOCK_PLACE, EventType.CRAFT, EventType.CONSUME, EventType.ENCHANT, EventType.FISH, EventType.SMELT};

    public static Map<String, Long> processReqs(ReqType type, ResourceLocation stackID) {
        if (!type.itemApplicable || !Config.autovalue().reqEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(stackID));
        switch (type) {
            case WEAR: {
                if (stack.getItem() instanceof TieredItem) {
                    if (stack.getItem() instanceof SwordItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                        break;
                    }
                    if (stack.getItem() instanceof AxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                        break;
                    }
                    if (stack.getItem() instanceof PickaxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                        break;
                    }
                    if (stack.getItem() instanceof ShovelItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                        break;
                    }
                    if (!(stack.getItem() instanceof HoeItem)) break;
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                    break;
                }
                if (stack.getItem() instanceof ArmorItem) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, true));
                    break;
                }
                if (!(stack.getItem() instanceof ElytraItem)) break;
                outMap.putAll(AutoItem.getWearableData(type, stack, false));
                break;
            }
            case USE_ENCHANTMENT: {
                double scale = 0.0;
                for (Object2IntMap.Entry entry : stack.getEnchantments().entrySet()) {
                    scale += (double)entry.getIntValue() / (double)((Enchantment)((Holder)entry.getKey()).value()).getMaxLevel();
                }
                for (Map.Entry entry : Config.autovalue().reqs().req(type).entrySet()) {
                    outMap.put((String)entry.getKey(), (long)((double)((Long)entry.getValue()).longValue() * scale));
                }
                break;
            }
            case TOOL: {
                if (!(stack.getItem() instanceof TieredItem)) break;
                if (stack.getItem() instanceof SwordItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, false));
                    break;
                }
                if (stack.getItem() instanceof AxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                    break;
                }
                if (stack.getItem() instanceof PickaxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                    break;
                }
                if (stack.getItem() instanceof ShovelItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                    break;
                }
                if (!(stack.getItem() instanceof HoeItem)) break;
                outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                break;
            }
            case WEAPON: {
                if (!(stack.getItem() instanceof TieredItem)) break;
                if (stack.getItem() instanceof SwordItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                    break;
                }
                if (stack.getItem() instanceof AxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, true));
                    break;
                }
                if (stack.getItem() instanceof PickaxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, true));
                    break;
                }
                if (stack.getItem() instanceof ShovelItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, true));
                    break;
                }
                if (!(stack.getItem() instanceof HoeItem)) break;
                outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, true));
                break;
            }
            case BREAK: {
                if (!(stack.getItem() instanceof BlockItem)) break;
                outMap.putAll(AutoBlock.processReqs(type, stackID));
                break;
            }
        }
        return outMap;
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation stackID) {
        if (!type.itemApplicable || !Config.autovalue().xpEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(stackID));
        switch (type) {
            case ANVIL_REPAIR: {
                if (!stack.isRepairable()) break;
                Config.autovalue().xpAwards().item(type).forEach((skill, xp) -> outMap.put((String)skill, (long)((double)xp.longValue() * ((double)stack.getMaxDamage() * 0.25))));
                break;
            }
            case BLOCK_PLACE: 
            case BLOCK_BREAK: {
                if (!(stack.getItem() instanceof BlockItem)) break;
                outMap.putAll(AutoBlock.processXpGains(type, RegistryUtil.getId(((BlockItem)stack.getItem()).getBlock())));
                break;
            }
            case CRAFT: {
                if (stack.getItem() instanceof TieredItem) {
                    if (stack.getItem() instanceof SwordItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                        break;
                    }
                    if (stack.getItem() instanceof AxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                        break;
                    }
                    if (stack.getItem() instanceof PickaxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                        break;
                    }
                    if (stack.getItem() instanceof ShovelItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                        break;
                    }
                    if (!(stack.getItem() instanceof HoeItem)) break;
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                    break;
                }
                if (stack.getItem() instanceof ArmorItem) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, true));
                    break;
                }
                if (stack.getItem() instanceof ElytraItem) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, false));
                    break;
                }
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
            case CONSUME: {
                FoodProperties foodProperties = stack.getFoodProperties(null);
                if (foodProperties instanceof FoodProperties) {
                    FoodProperties properties = foodProperties;
                    Config.autovalue().xpAwards().item(type).forEach((skill, xp) -> {
                        Float nutritionScale = Float.valueOf((float)properties.nutrition() * properties.saturation());
                        Float xpAward = Float.valueOf(nutritionScale.floatValue() * (float)xp.longValue());
                        outMap.put((String)skill, xpAward.longValue());
                    });
                }
            }
            case BREW: {
                if (!stack.is(Reference.BREWABLES)) break;
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
            case SMELT: {
                if (!stack.is(Reference.SMELTABLES)) break;
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
            case ENCHANT: 
            case FISH: {
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
        }
        return outMap;
    }

    private static Map<String, Long> getUtensilData(AutoValueConfig.UtensilTypes utensil, ReqType type, ItemStack stack, boolean asWeapon) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        if (stack.getItem() instanceof TieredItem && AutoItem.getTier((TieredItem)stack.getItem()) <= 0.0) {
            return outMap;
        }
        double scale = AutoItem.getUtensilAttributes(utensil, stack, asWeapon);
        Map<String, Long> configValue = type == ReqType.TOOL || type == ReqType.WEAR && !asWeapon ? Config.autovalue().reqs().getToolReq(stack) : (type == ReqType.WEAR && asWeapon ? Config.autovalue().reqs().req(ReqType.WEAPON) : Config.autovalue().reqs().req(type));
        configValue.forEach((skill, level) -> outMap.put((String)skill, (long)Math.max(0.0, (double)level.longValue() * scale)));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Req Map: " + MsLoggy.mapToString(outMap), new Object[0]);
        return outMap;
    }

    private static Map<String, Long> getUtensilData(AutoValueConfig.UtensilTypes utensil, EventType type, ItemStack stack, boolean asWeapon) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double scale = AutoItem.getUtensilAttributes(utensil, stack, asWeapon);
        Config.autovalue().xpAwards().item(type).forEach((skill, level) -> outMap.put((String)skill, Double.valueOf(Math.max(0.0, (double)level.longValue() * scale)).longValue()));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem XpGain Map: " + MsLoggy.mapToString(outMap), new Object[0]);
        return outMap;
    }

    private static Map<String, Long> getWearableData(ReqType type, ItemStack stack, boolean isArmor) {
        ArmorItem armorItem;
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        Item item = stack.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getMaterial().equals((Object)ArmorMaterials.LEATHER)) {
            return outMap;
        }
        double scale = AutoItem.getWearableAttributes(AutoValueConfig.WearableTypes.fromSlot(stack.getEquipmentSlot(), !isArmor), stack, isArmor);
        Config.autovalue().reqs().req(type).forEach((skill, level) -> outMap.put((String)skill, (long)Math.max(0.0, (double)level.longValue() * scale)));
        return outMap;
    }

    private static Map<String, Long> getWearableData(EventType type, ItemStack stack, boolean isArmor) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double scale = AutoItem.getWearableAttributes(AutoValueConfig.WearableTypes.fromSlot(stack.getEquipmentSlot(), !isArmor), stack, isArmor);
        Config.autovalue().xpAwards().item(type).forEach((skill, level) -> outMap.put((String)skill, Double.valueOf(Math.max(0.0, (double)level.longValue() * scale)).longValue()));
        return outMap;
    }

    private static double getAttributeAmount(ItemStack stack, EquipmentSlot slot, Holder<Attribute> attribute) {
        return stack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.attribute().is(attribute)).mapToDouble(a -> a.modifier().amount()).sum();
    }

    private static double getTier(TieredItem item) {
        return item.getTier().getAttackDamageBonus();
    }

    private static double getDamage(ItemStack stack) {
        return AutoItem.getAttributeAmount(stack, EquipmentSlot.MAINHAND, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) - 4.0;
    }

    private static double getAttackSpeed(ItemStack stack) {
        return Math.abs(AutoItem.getAttributeAmount(stack, EquipmentSlot.MAINHAND, (Holder<Attribute>)Attributes.ATTACK_SPEED)) - 1.6;
    }

    private static double getDurability(ItemStack stack) {
        return (double)stack.getMaxDamage() - 59.0;
    }

    private static double getUtensilAttributes(AutoValueConfig.UtensilTypes type, ItemStack stack, boolean asWeapon) {
        double durabilityScale = AutoItem.getDurability(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.DUR);
        double tierScale = AutoItem.getTier((TieredItem)stack.getItem()) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.TIER);
        double damageScale = asWeapon ? AutoItem.getDamage(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.DMG) : 0.0;
        double atkSpdScale = asWeapon ? AutoItem.getAttackSpeed(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.SPD) : 0.0;
        double digSpeedScale = asWeapon ? 0.0 : (double)stack.getDestroySpeed(Blocks.COBWEB.defaultBlockState()) + Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.DIG);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Attributes: DUR=" + durabilityScale + " TIER=" + tierScale + " DMG=" + damageScale + " SPD=" + atkSpdScale + " DIG=" + digSpeedScale, new Object[0]);
        return damageScale + atkSpdScale + digSpeedScale + durabilityScale + tierScale;
    }

    private static double getWearableAttributes(AutoValueConfig.WearableTypes type, ItemStack stack, boolean isArmor) {
        if (type == null) {
            return 1.0;
        }
        double durabilityScale = (double)stack.getMaxDamage() * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.DUR);
        ArmorMaterial material = isArmor ? (ArmorMaterial)((ArmorItem)stack.getItem()).getMaterial().value() : null;
        double armorScale = isArmor ? (double)material.getDefense(((ArmorItem)stack.getItem()).getType()) * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.AMR) : 0.0;
        double toughnessScale = isArmor ? (double)material.toughness() * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.TUF) : 0.0;
        double knockbackScale = isArmor ? (double)material.knockbackResistance() * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.KBR) : 0.0;
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Attributes: DUR=" + durabilityScale + " ARM=" + armorScale + " TUF=" + toughnessScale + " KBR=" + knockbackScale, new Object[0]);
        return durabilityScale + armorScale + toughnessScale + knockbackScale;
    }
}

