/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.mobscaling;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

@EventBusSubscriber(modid="pmmo", bus=EventBusSubscriber.Bus.GAME)
public class MobAttributeHandler {
    private static final ResourceLocation ADDITION_MODIFIER_ID = Reference.rl("mob_scaling_modifier");
    private static final ResourceLocation MULTIPLY_BASE_MODIFIER_ID = Reference.rl("mob_scaling_modifier_m");
    private static final ResourceLocation MULTIPLY_TOTAL_MODIFIER_ID = Reference.rl("mob_scaling_modifier_mt");
    private static final Map<ResourceLocation, Float> CAPS = Map.of(((ResourceKey)Attributes.MAX_HEALTH.unwrapKey().get()).location(), Float.valueOf(1024.0f), ((ResourceKey)Attributes.MOVEMENT_SPEED.unwrapKey().get()).location(), Float.valueOf(1.5f), ((ResourceKey)Attributes.ATTACK_DAMAGE.unwrapKey().get()).location(), Float.valueOf(2048.0f), ((ResourceKey)Attributes.SPAWN_REINFORCEMENTS_CHANCE.unwrapKey().get()).location(), Float.valueOf(1.0f));

    @SubscribeEvent
    public static void onBossAdd(MobSpawnEvent.PositionCheck event) {
        Mob mob;
        if (!Config.server().mobScaling().enabled()) {
            return;
        }
        if (event.getEntity().getType().is(Tags.EntityTypes.BOSSES) && (mob = event.getEntity()) instanceof LivingEntity) {
            Mob entity = mob;
            mob = event.getLevel();
            if (mob instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)mob;
                MobAttributeHandler.handle((LivingEntity)entity, level, new Vec3(entity.getX(), entity.getY(), entity.getZ()), level.getDifficulty().getId());
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.PositionCheck event) {
        if (!Config.server().mobScaling().enabled()) {
            return;
        }
        if (event.getEntity().getType().is(Reference.MOB_TAG)) {
            MobAttributeHandler.handle((LivingEntity)event.getEntity(), event.getLevel().getLevel(), new Vec3(event.getX(), event.getY(), event.getZ()), event.getLevel().getDifficulty().getId());
        }
    }

    private static void handle(LivingEntity entity, ServerLevel level, Vec3 spawnPos, int diffScale) {
        int range = Config.server().mobScaling().aoe();
        TargetingConditions targetCondition = TargetingConditions.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight().range(Math.pow(range, 2.0) * 3.0);
        List nearbyPlayers = level.getNearbyPlayers(targetCondition, entity, AABB.ofSize((Vec3)spawnPos, (double)range, (double)range, (double)range));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "NearbyPlayers on Spawn: " + MsLoggy.listToString(nearbyPlayers), new Object[0]);
        Core core = Core.get((Level)level.getLevel());
        LocationData dimData = core.getLoader().DIMENSION_LOADER.getData(level.getLevel().dimension().location());
        LocationData bioData = core.getLoader().BIOME_LOADER.getData(RegistryUtil.getId(level.getBiome(entity.getOnPos())));
        List dimMods = dimData.mobModifiers().getOrDefault(RegistryUtil.getId((Entity)entity), new ArrayList(0));
        List bioMods = bioData.mobModifiers().getOrDefault(RegistryUtil.getId((Entity)entity), new ArrayList(0));
        List<MobModifier> globalDimMods = dimData.globalModifiers();
        List<MobModifier> globalBioMods = bioData.globalModifiers();
        List<MobModifier> mergedModifiers = MobAttributeHandler.mergeModifiers(Stream.of(dimMods, bioMods, globalDimMods, globalBioMods).collect(Collectors.toList()));
        float bossMultiplier = entity.getType().is(Tags.EntityTypes.BOSSES) ? Config.server().mobScaling().bossScaling().floatValue() : 1.0f;
        MobAttributeHandler.computeAndApplyModifiers(entity, mergedModifiers, nearbyPlayers, diffScale, bossMultiplier);
        entity.setHealth(entity.getMaxHealth());
    }

    private static List<MobModifier> mergeModifiers(List<List<MobModifier>> modifiers) {
        return modifiers.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void computeAndApplyModifiers(LivingEntity entity, List<MobModifier> modifiers, List<Player> nearbyPlayers, int diffScale, float bossMultiplier) {
        ArrayList<MobModifier> additionModifiers = new ArrayList<MobModifier>();
        ArrayList<MobModifier> multiplyBaseModifiers = new ArrayList<MobModifier>();
        ArrayList<MobModifier> multiplyTotalModifiers = new ArrayList<MobModifier>();
        modifiers.forEach(mod -> {
            switch (mod.operation()) {
                case ADD_VALUE: {
                    additionModifiers.add((MobModifier)mod);
                    break;
                }
                case ADD_MULTIPLIED_BASE: {
                    multiplyBaseModifiers.add((MobModifier)mod);
                    break;
                }
                case ADD_MULTIPLIED_TOTAL: {
                    multiplyTotalModifiers.add((MobModifier)mod);
                }
            }
        });
        modifiers.clear();
        HashMap<ResourceLocation, Double> collapsedAdditionModifiers = MobAttributeHandler.collapseModifiers(additionModifiers);
        HashMap<ResourceLocation, Double> collapsedMultiplyBaseModifiers = MobAttributeHandler.collapseModifiers(multiplyBaseModifiers);
        HashMap<ResourceLocation, Double> collapsedMultiplyTotalModifiers = MobAttributeHandler.collapseModifiers(multiplyTotalModifiers);
        Map<ResourceLocation, Map<String, Double>> mobScalingMultipliers = Config.server().mobScaling().ratios();
        MobAttributeHandler.applyMobScaling(collapsedAdditionModifiers, entity, mobScalingMultipliers, nearbyPlayers, diffScale);
        MobAttributeHandler.applyBossMultiplier(collapsedAdditionModifiers, bossMultiplier);
        MobAttributeHandler.applyModifiers(entity, ADDITION_MODIFIER_ID, AttributeModifier.Operation.ADD_VALUE, collapsedAdditionModifiers);
        MobAttributeHandler.applyModifiers(entity, MULTIPLY_BASE_MODIFIER_ID, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, collapsedMultiplyBaseModifiers);
        MobAttributeHandler.applyModifiers(entity, MULTIPLY_TOTAL_MODIFIER_ID, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, collapsedMultiplyTotalModifiers);
    }

    private static void applyModifiers(LivingEntity entity, ResourceLocation modifierId, AttributeModifier.Operation operation, Map<ResourceLocation, Double> collapsedModifiers) {
        collapsedModifiers.forEach((attributeID, amount) -> {
            if (Math.abs(amount) < (double)1.0E-4f) {
                return;
            }
            Optional attribute = entity.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(attributeID);
            if (attribute.isEmpty()) {
                return;
            }
            AttributeInstance attributeInstance = entity.getAttribute((Holder)attribute.get());
            if (attributeInstance == null) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier(modifierId, amount.doubleValue(), operation);
            attributeInstance.removeModifier(modifierId);
            attributeInstance.addPermanentModifier(modifier);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Entity={} Attribute={} value={} operation={}", entity.getDisplayName().getString(), attributeID, amount, operation);
        });
    }

    private static HashMap<ResourceLocation, Double> collapseModifiers(List<MobModifier> modifiers) {
        HashMap<ResourceLocation, Double> modifierMap = new HashMap<ResourceLocation, Double>();
        for (MobModifier mod : modifiers) {
            if (modifierMap.containsKey(mod.attribute())) {
                modifierMap.put(mod.attribute(), modifierMap.get(mod.attribute()) + mod.amount());
                continue;
            }
            modifierMap.put(mod.attribute(), mod.amount());
        }
        return modifierMap;
    }

    private static void applyMobScaling(HashMap<ResourceLocation, Double> collapsedModifiers, LivingEntity entity, Map<ResourceLocation, Map<String, Double>> config, List<Player> nearbyPlayers, int difficultyScale) {
        config.forEach((attributeID, configMap) -> {
            Float cap;
            Map attributeScalingConfig = config.getOrDefault(attributeID, new HashMap());
            if (attributeScalingConfig.isEmpty()) {
                return;
            }
            Optional attribute = entity.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(attributeID);
            if (attribute.isEmpty()) {
                return;
            }
            AttributeInstance attributeInstance = entity.getAttribute((Holder)attribute.get());
            if (attributeInstance == null) {
                return;
            }
            double baseValue = MobAttributeHandler.baseValue(entity, attributeID, attributeInstance);
            float bonus = MobAttributeHandler.getBonus(nearbyPlayers, attributeScalingConfig, difficultyScale, baseValue, (cap = CAPS.getOrDefault(attributeID, Float.valueOf(Float.MAX_VALUE))).floatValue());
            if (Math.abs(bonus) < 1.0E-4f) {
                return;
            }
            if (collapsedModifiers.containsKey(attributeID)) {
                collapsedModifiers.put((ResourceLocation)attributeID, (Double)collapsedModifiers.get(attributeID) + (double)bonus);
            } else {
                collapsedModifiers.put((ResourceLocation)attributeID, Double.valueOf(bonus));
            }
        });
    }

    private static void applyBossMultiplier(HashMap<ResourceLocation, Double> collapsedModifiers, float multiplier) {
        if (Math.abs(multiplier - 1.0f) < 1.0E-4f) {
            return;
        }
        collapsedModifiers.replaceAll((attribute, value) -> value * (double)multiplier);
    }

    private static double baseValue(LivingEntity entity, ResourceLocation id, AttributeInstance ai) {
        return switch (id.toString()) {
            case "minecraft:generic.attack_damage" -> 1.0;
            case "minecraft:generic.movement_speed" -> entity.getSpeed();
            default -> ai.getBaseValue();
        };
    }

    private static float getBonus(List<Player> nearbyPlayers, Map<String, Double> config, int scale, double ogValue, float cap) {
        HashMap totalLevel = new HashMap();
        if (nearbyPlayers.isEmpty()) {
            return 0.0f;
        }
        nearbyPlayers.forEach(player -> config.keySet().stream().collect(Collectors.toMap(str -> str, str -> Core.get(player.level()).getData().getLevel((String)str, player.getUUID()))).forEach((skill, level) -> totalLevel.merge(skill, (Long)level, Long::sum)));
        float outValue = 0.0f;
        for (Map.Entry<String, Double> configEntry : config.entrySet()) {
            long averageLevel = totalLevel.getOrDefault(configEntry.getKey(), 0L) / (long)nearbyPlayers.size();
            if (averageLevel < Config.server().mobScaling().baseLevel()) continue;
            outValue = (float)((double)outValue + (Config.server().mobScaling().useExponential() ? Math.pow(Config.server().mobScaling().powerBase(), Config.server().mobScaling().perLevel() * (double)(averageLevel - Config.server().mobScaling().baseLevel())) : (double)(averageLevel - Config.server().mobScaling().baseLevel()) * Config.server().mobScaling().perLevel()));
            outValue = (float)((double)outValue * configEntry.getValue());
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Modifier Value: " + outValue * (float)scale, new Object[0]);
        return (double)outValue + ogValue > (double)cap ? cap : (outValue *= (float)scale);
    }
}

