/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network.clientpackets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CP_SyncData(ObjectType oType, Map<ResourceLocation, ? extends DataSource<?>> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CP_SyncData> TYPE = new CustomPacketPayload.Type(Reference.rl("s2c_sync_data"));
    public static final StreamCodec<FriendlyByteBuf, CP_SyncData> STREAM_CODEC = StreamCodec.of(CP_SyncData::write, CP_SyncData::decode);
    private static final Codec<DataSource<?>> CODEC = Codec.lazyInitialized(() -> ObjectType.CODEC.dispatch("type", s -> {
        DataSource dataSource = s;
        Objects.requireNonNull(dataSource);
        DataSource selector0$temp = dataSource;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ObjectData.class, LocationData.class, EnhancementsData.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                ObjectData data = (ObjectData)selector0$temp;
                yield ObjectType.ITEM;
            }
            case 1 -> {
                LocationData data = (LocationData)selector0$temp;
                yield ObjectType.BIOME;
            }
            case 2 -> {
                EnhancementsData data = (EnhancementsData)selector0$temp;
                yield ObjectType.EFFECT;
            }
            default -> ObjectType.PLAYER;
        };
    }, x -> switch (x) {
        case ObjectType.ITEM -> ObjectData.CODEC;
        case ObjectType.BIOME -> LocationData.CODEC;
        case ObjectType.EFFECT -> EnhancementsData.CODEC;
        default -> PlayerData.CODEC;
    }));
    private static final Codec<CP_SyncData> MAPPER = RecordCodecBuilder.create(instance -> instance.group((App)ObjectType.CODEC.fieldOf("type").forGetter(CP_SyncData::oType), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, CODEC).fieldOf("data").forGetter(pkt -> pkt.data())).apply((Applicative)instance, CP_SyncData::new));

    public static CP_SyncData decode(FriendlyByteBuf buf) {
        return MAPPER.parse((DynamicOps)NbtOps.INSTANCE, (Object)buf.readNbt(NbtAccounter.unlimitedHeap())).result().orElse(new CP_SyncData(ObjectType.ITEM, new HashMap()));
    }

    public static void write(FriendlyByteBuf buf, CP_SyncData packet) {
        buf.writeNbt((Tag)MAPPER.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)packet).result().orElse(new CompoundTag()));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.NETWORK, "Payload for {}/{} is {}", packet.getClass().getSimpleName(), packet.oType().name(), buf.readableBytes());
    }

    public static void handle(CP_SyncData packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Map<ResourceLocation, ?> map = Core.get(LogicalSide.CLIENT).getLoader().getLoader(packet.oType()).getData();
            map.putAll(packet.data());
        });
    }

    public CustomPacketPayload.Type<CP_SyncData> type() {
        return TYPE;
    }
}

