/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.registry;

import com.google.common.base.Preconditions;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class PerkRegistry {
    private final Map<ResourceLocation, Perk> perks = new HashMap<ResourceLocation, Perk>();
    private final List<TickSchedule> tickTracker = new ArrayList<TickSchedule>();
    private final List<PerkCooldown> coolTracker = new ArrayList<PerkCooldown>();

    public void registerPerk(ResourceLocation perkID, Perk perk) {
        Preconditions.checkNotNull((Object)perkID);
        Preconditions.checkNotNull((Object)perk);
        this.perks.put(perkID, perk);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.API, "Registered Perk: " + perkID.toString(), new Object[0]);
    }

    public void registerClientClone(ResourceLocation perkID, Perk perk) {
        Preconditions.checkNotNull((Object)perkID);
        Preconditions.checkNotNull((Object)perk);
        Perk clientCopy = new Perk(perk.conditions(), perk.propertyDefaults(), (a, b) -> new CompoundTag(), (TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(a, b, c) -> new CompoundTag()), (a, b) -> new CompoundTag(), perk.description(), perk.status());
        this.perks.putIfAbsent(perkID, clientCopy);
    }

    public MutableComponent getDescription(ResourceLocation id) {
        return this.perks.getOrDefault(id, Perk.empty()).description();
    }

    public List<MutableComponent> getStatusLines(ResourceLocation id, Player player, CompoundTag settings) {
        return this.perks.getOrDefault(id, Perk.empty()).status().apply(player, settings);
    }

    public CompoundTag executePerk(EventType cause, Player player, @NotNull CompoundTag dataIn) {
        if (player == null) {
            return new CompoundTag();
        }
        CompoundTag output = new CompoundTag();
        ((List)Config.perks().perks().getOrDefault(cause, new ArrayList())).forEach(src -> output.merge(this.processPerk((CompoundTag)src, output, player, dataIn)));
        return output;
    }

    public CompoundTag executePerkFiltered(EventType cause, Player player, String filterTag, String filterValue, @NotNull CompoundTag dataIn) {
        if (player == null) {
            return new CompoundTag();
        }
        CompoundTag output = new CompoundTag();
        ((List)Config.perks().perks().getOrDefault(cause, new ArrayList())).stream().filter(tag -> tag.getString(filterTag).equals(filterValue)).toList().forEach(src -> output.merge(this.processPerk((CompoundTag)src, output, player, dataIn)));
        return output;
    }

    private CompoundTag processPerk(CompoundTag src, CompoundTag output, Player player, @NotNull CompoundTag dataIn) {
        CompoundTag fullSrc;
        ResourceLocation perkID = Reference.of(src.getString("perk"));
        Perk perk = this.perks.getOrDefault(perkID, Perk.empty());
        fullSrc.putLong("level", (fullSrc = new CompoundTag().merge(perk.propertyDefaults().copy()).merge(src.copy()).merge(dataIn.copy()).merge(output.copy())).contains("skill") ? Core.get(player.level()).getData().getLevel(fullSrc.getString("skill"), player.getUUID()) : 0L);
        if (perk.canActivate(player, fullSrc)) {
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Perk Executed: %s".formatted(fullSrc.toString()), new Object[0]);
            CompoundTag executionOutput = perk.start(player, fullSrc);
            this.tickTracker.add(new TickSchedule(perk, player, fullSrc.copy(), new AtomicInteger(0)));
            if (fullSrc.contains("cooldown") && this.isPerkCooledDown(player, fullSrc)) {
                this.coolTracker.add(new PerkCooldown(perkID, player, fullSrc, player.level().getGameTime()));
            }
            output = executionOutput;
        } else {
            output = new CompoundTag();
        }
        return output;
    }

    public void executePerkTicks(LevelTickEvent event) {
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.PERKS, "Perk Tick Tracker:" + MsLoggy.listToString(this.tickTracker), new Object[0]);
        this.coolTracker.removeIf(tracker -> tracker.cooledDown(event.getLevel()));
        new ArrayList<TickSchedule>(this.tickTracker).forEach(schedule -> {
            if (schedule.perk().canActivate(schedule.player(), schedule.src())) {
                if (schedule.shouldTick()) {
                    schedule.tick();
                } else {
                    schedule.perk().stop(schedule.player(), schedule.src());
                    this.tickTracker.remove(schedule);
                }
            } else {
                this.tickTracker.remove(schedule);
            }
        });
    }

    public boolean isPerkCooledDown(Player player, CompoundTag src) {
        ResourceLocation perkID = Reference.of(src.getString("perk"));
        return this.coolTracker.stream().noneMatch(cd -> cd.player().equals((Object)player) && cd.perkID().equals((Object)perkID));
    }

    private record TickSchedule(Perk perk, Player player, CompoundTag src, AtomicInteger ticksElapsed) {
        public boolean shouldTick() {
            return this.src.contains("duration") && this.ticksElapsed.get() <= this.src.getInt("duration");
        }

        public void tick() {
            this.ticksElapsed().getAndIncrement();
            this.perk.tick(this.player, this.src, this.ticksElapsed.get());
        }
    }

    private record PerkCooldown(ResourceLocation perkID, Player player, CompoundTag src, long lastUse) {
        public boolean cooledDown(Level level) {
            return level.getGameTime() > this.lastUse + (long)this.src.getInt("cooldown");
        }
    }
}

