/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.util.MsLoggy;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public abstract class PmmoDataProvider<T extends DataSource<?>>
implements DataProvider {
    private final Path destination;
    private final String dataPath;
    private final PackOutput output;
    private final Codec<T> codec;
    private final Map<ResourceLocation, JsonElement> toSerialize = new HashMap<ResourceLocation, JsonElement>();

    public PmmoDataProvider(PackOutput gen, String packName, String dataPath, Codec<T> codec) {
        this.output = gen;
        this.destination = Path.of("resourcepacks", new String[0]).resolve(packName).resolve("data");
        this.dataPath = dataPath;
        this.codec = codec;
    }

    public void add(ResourceLocation id, T instance) {
        JsonElement json = (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, instance).resultOrPartial(s -> MsLoggy.WARN.log(MsLoggy.LOG_CODE.DATA, (String)s, new Object[0])).get();
        this.toSerialize.put(id, json);
    }

    protected abstract void start();

    protected ResourceLocation getId(Item item) {
        return ((ResourceKey)item.builtInRegistryHolder().unwrapKey().get()).location();
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.start();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.toSerialize.forEach((name, json) -> {
            Path modifierPath = this.output.getOutputFolder().resolve(this.destination).resolve(name.getNamespace()).resolve(this.dataPath).resolve(name.getPath() + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)modifierPath));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }
}

