/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen.easypack;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.setup.datagen.PmmoDataProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class EasyBlockConfigProvider
extends PmmoDataProvider<ObjectData> {
    Map<ResourceLocation, ObjectData.Builder> data = new HashMap<ResourceLocation, ObjectData.Builder>();

    public EasyBlockConfigProvider(PackOutput gen) {
        super(gen, "easy", "pmmo/blocks", ObjectData.CODEC.codec());
    }

    @Override
    protected void start() {
        this.populateData();
        this.data.forEach((id, builder) -> this.add((ResourceLocation)id, builder.end()));
    }

    private void populateData() {
        this.miningBreak(Blocks.COAL_ORE, 250L);
        this.miningBreak(Blocks.DEEPSLATE_COAL_ORE, 500L);
        this.miningBreak(Blocks.COPPER_ORE, 300L);
        this.miningBreak(Blocks.DEEPSLATE_COPPER_ORE, 600L);
        this.miningBreak(Blocks.IRON_ORE, 1500L);
        this.miningBreak(Blocks.DEEPSLATE_IRON_ORE, 3000L);
        this.miningBreak(Blocks.GOLD_ORE, 2000L);
        this.miningBreak(Blocks.DEEPSLATE_GOLD_ORE, 4000L);
        this.miningBreak(Blocks.NETHER_GOLD_ORE, 4000L);
        this.miningBreak(Blocks.REDSTONE_ORE, 1500L);
        this.miningBreak(Blocks.DEEPSLATE_REDSTONE_ORE, 3000L);
        this.miningBreak(Blocks.DIAMOND_ORE, 7500L);
        this.miningBreak(Blocks.DEEPSLATE_DIAMOND_ORE, 7500L);
        this.miningBreak(Blocks.EMERALD_ORE, 4000L);
        this.miningBreak(Blocks.DEEPSLATE_EMERALD_ORE, 100000L);
        this.miningBreak(Blocks.LAPIS_ORE, 500L);
        this.miningBreak(Blocks.DEEPSLATE_LAPIS_ORE, 1000L);
        this.miningBreak(Blocks.NETHER_QUARTZ_ORE, 1000L);
        this.miningBreak(Blocks.ANCIENT_DEBRIS, 15000L);
    }

    private void miningBreak(Block block, long xp) {
        this.get(block).addXpValues(EventType.BLOCK_BREAK, Map.of("mining", xp));
    }

    private ObjectData.Builder get(Block block) {
        return this.data.computeIfAbsent(RegistryUtil.getId(block), i -> ObjectData.build());
    }

    public String getName() {
        return "Project MMO Easy Block Generator";
    }
}

