/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen.easypack;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.ConfigData;
import harmonised.pmmo.config.codecs.ServerData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.features.autovalues.AutoBlock;
import harmonised.pmmo.features.autovalues.AutoItem;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.setup.CommonSetup;
import harmonised.pmmo.setup.datagen.PmmoDataProvider;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class EasyConfigProvider
extends PmmoDataProvider<ConfigData<?>> {
    Map<ConfigListener.ServerConfigs, ConfigData<?>> data = new HashMap();

    public EasyConfigProvider(PackOutput gen) {
        super(gen, "easy", "config", ConfigListener.ServerConfigs.MAPPER);
    }

    @Override
    protected void start() {
        this.populateData();
        this.data.forEach((type, config) -> this.add(Reference.rl(type.filename), config));
    }

    private void populateData() {
        this.data.put(ConfigListener.ServerConfigs.SERVER, new ServerData(new ServerData.General(50.0, Reference.mc("smithing_table"), true, true), new ServerData.Levels(1000000L, List.of(Long.valueOf(-1L)), 0.0, true, 1.0, Map.of(), 3000L, 0.0, 1.0), new ServerData.Requirements(Arrays.stream(ReqType.values()).collect(Collectors.toMap(a -> a, a -> false))), new ServerData.XpGains(0.0, false, EasyConfigProvider.serverDefaults(), Map.of(EventType.DEAL_DAMAGE, Map.of("minecraft:generic_kill", Map.of("combat", 100L), "minecraft:player_attack", Map.of("combat", 100L), "#minecraft:is_projectile", Map.of("combat", 100L), "#pmmo:magic", Map.of("magic", 100L)), EventType.RECEIVE_DAMAGE, Map.of("minecraft:generic_kill", Map.of("endurance", 100L), "#pmmo:environment", Map.of("endurance", 100L), "#pmmo:impact", Map.of("endurance", 150L), "#pmmo:magic", Map.of("endurance", 150L), "#minecraft:is_projectile", Map.of("endurance", 150L)))), new ServerData.Party(200, new SkillsConfig().skills().keySet().stream().collect(Collectors.toMap(str -> str, str -> 1.5))), new ServerData.MobScaling(false, 0, 0L, 1.0, true, 0.0, 1.0, Map.of()), new ServerData.VeinMiner(true, false, 1, 1.5, List.of(Reference.of("silentgear:saw")))));
        this.data.put(ConfigListener.ServerConfigs.PERKS, new PerksConfig(EasyConfigProvider.perkDefaults()));
        AutoValueConfig defaultAutoValues = new AutoValueConfig();
        this.data.put(ConfigListener.ServerConfigs.AUTOVALUES, new AutoValueConfig(true, Arrays.stream(ReqType.values()).collect(Collectors.toMap(req -> req, r -> false)), defaultAutoValues.xpEnabled(), new AutoValueConfig.XpAwards(200.0, Arrays.stream(AutoItem.EVENTTYPES).collect(Collectors.toMap(event -> event, event -> Map.of(event.autoValueSkill, event == EventType.SMELT || event == EventType.BREW ? 100L : 10L))), Arrays.stream(AutoBlock.EVENTTYPES).collect(Collectors.toMap(event -> event, event -> Map.of(event.autoValueSkill, 10L))), Map.of("woodcutting", 100L), Map.of("farming", 100L), Map.of("excavation", 100L), Stream.of(EventType.DEATH, EventType.SHIELD_BLOCK, EventType.TAMING).collect(Collectors.toMap(event -> event, event -> Map.of(event.autoValueSkill, 10L)))), new AutoValueConfig.Requirements(Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of()), defaultAutoValues.tweaks()));
    }

    private static Map<EventType, Map<String, Double>> serverDefaults() {
        HashMap<EventType, Map<String, Double>> map = new HashMap<EventType, Map<String, Double>>();
        map.put(EventType.JUMP, Map.of("agility", 2.5));
        map.put(EventType.SPRINT_JUMP, Map.of("agility", 2.5));
        map.put(EventType.CROUCH_JUMP, Map.of("agility", 2.5));
        map.put(EventType.BREATH_CHANGE, Map.of("endurance", 1.0));
        map.put(EventType.HEALTH_INCREASE, Map.of("endurance", 100.0));
        map.put(EventType.HEALTH_DECREASE, Map.of("endurance", 100.0));
        map.put(EventType.SPRINTING, Map.of("agility", 100.0));
        map.put(EventType.SUBMERGED, Map.of("swimming", 1.0));
        map.put(EventType.SWIMMING, Map.of("swimming", 1.0));
        map.put(EventType.DIVING, Map.of("swimming", 1.0));
        map.put(EventType.SURFACING, Map.of("swimming", 1.0));
        map.put(EventType.SWIM_SPRINTING, Map.of("swimming", 1.0));
        return map;
    }

    private static Map<EventType, List<CompoundTag>> perkDefaults() {
        HashMap<EventType, List<CompoundTag>> defaultSettings = new HashMap<EventType, List<CompoundTag>>();
        ArrayList<CompoundTag> bodyList = new ArrayList<CompoundTag>();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "mining").withDouble("pickaxe_dig", 0.005).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "excavation").withDouble("shovel_dig", 0.005).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "woodcutting").withDouble("axe_dig", 0.005).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:break_speed").withString("skill", "farming").withDouble("sword_dig", 0.005).withDouble("hoe_dig", 0.005).withDouble("shears_dig", 0.005).build());
        defaultSettings.put(EventType.BREAK_SPEED, new ArrayList(bodyList));
        bodyList.clear();
        List.of("mining", "building", "excavation", "woodcutting", "farming", "agility", "endurance", "combat", "smithing", "swimming", "fishing", "crafting", "taming", "cooking", "alchemy").forEach(skill -> bodyList.add(TagBuilder.start().withString("perk", "pmmo:fireworks").withInt("per_x_level", 10).withString("skill", (String)skill).build()));
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "mining").withString("attribute", CommonSetup.VEIN_RECHARGE.getRegisteredName()).withDouble("base", 0.5).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "mining").withString("attribute", CommonSetup.VEIN_CAPACITY.getRegisteredName()).withDouble("base", 15.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "building").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE).toString()).withDouble("per_level", 0.005).withDouble("max_boost", 10.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "agility").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.MOVEMENT_SPEED).toString()).withDouble("per_level", 1.5E-6).withDouble("max_boost", 1.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "endurance").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.MAX_HEALTH).toString()).withDouble("per_level", 0.005).withDouble("max_boost", 20.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "combat").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.ATTACK_DAMAGE).toString()).withDouble("per_level", 5.0E-4).withDouble("max_boost", 3.0).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:command").withString("skill", "crafting").withString("command", "experience add @s 1 levels").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:command").withString("skill", "smithing").withString("command", "experience add @s 1 levels").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:command").withString("skill", "cooking").withString("command", "experience add @s 1 levels").build());
        defaultSettings.put(EventType.SKILL_UP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:jump_boost").withString("skill", "agility").withDouble("per_level", 5.0E-4).build());
        defaultSettings.put(EventType.JUMP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:jump_boost").withString("skill", "agility").withDouble("per_level", 0.001).build());
        defaultSettings.put(EventType.SPRINT_JUMP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:jump_boost").withString("skill", "agility").withDouble("per_level", 0.002).withDouble("max_boost", 0.5).build());
        defaultSettings.put(EventType.CROUCH_JUMP, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:breath").withString("skill", "swimming").build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:effect").withString("skill", "swimming").withString("effect", "minecraft:night_vision").withInt("max_boost", 160).withInt("min_level", 25).build());
        defaultSettings.put(EventType.SUBMERGED, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_reduce").withString("skill", "agility").withString("for_damage", "minecraft:fall").withDouble("per_level", 0.025).build());
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_reduce").withString("skill", "endurance").withString("for_damage", "minecraft:mob_attack").withDouble("per_level", 0.025).build());
        defaultSettings.put(EventType.RECEIVE_DAMAGE, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:attribute").withString("skill", "fishing").withString("attribute", RegistryUtil.getAttributeId((Holder<Attribute>)Attributes.LUCK).toString()).withDouble("chance", 0.05).withDouble("per_level", 0.005).withDouble("max_boost", 100.0).build());
        defaultSettings.put(EventType.FISH, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:tame_boost").build());
        defaultSettings.put(EventType.TAMING, new ArrayList(bodyList));
        bodyList.clear();
        bodyList.add(TagBuilder.start().withString("perk", "pmmo:damage_boost").withString("skill", "combat").withList("applies_to", new Tag[]{StringTag.valueOf((String)"minecraft:bow"), StringTag.valueOf((String)"minecraft:crossbow"), StringTag.valueOf((String)"minecraft:trident")}).build());
        defaultSettings.put(EventType.DEAL_DAMAGE, new ArrayList(bodyList));
        return defaultSettings;
    }

    public String getName() {
        return "Project MMO Easy Config Generator";
    }
}

