/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class Functions<X, Y> {
    public static <X, Y> Function<X, Y> memoize(Function<X, Y> func) {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        return a -> cache.computeIfAbsent(a, func);
    }

    public static <T> void biPermutation(T one, T two, boolean isOneTrue, boolean isTwoTrue, BiConsumer<T, T> either, BiConsumer<T, T> neither, BiConsumer<T, T> both) {
        if (isOneTrue && !isTwoTrue) {
            either.accept(one, two);
        } else if (!isOneTrue && isTwoTrue) {
            either.accept(two, one);
        } else if (!isOneTrue && !isTwoTrue) {
            neither.accept(one, two);
        } else {
            both.accept(one, two);
        }
    }

    @SafeVarargs
    public static <K, V extends Number> Map<K, V> mergeMaps(Map<K, V> ... maps) {
        Map outMap = maps.length >= 2 ? Functions.mergeMaps(maps[0], maps[1]) : (maps.length >= 1 ? maps[0] : new HashMap());
        for (int i = 2; i < maps.length; ++i) {
            outMap = Functions.mergeMaps(outMap, maps[i]);
        }
        return outMap;
    }

    public static <K, V extends Number> Map<K, V> mergeMaps(Map<K, V> one, Map<K, V> two) {
        HashMap outMap = new HashMap(one);
        two.forEach((key, value) -> outMap.merge(key, value, (v1, v2) -> v1.longValue() > v2.longValue() ? (Number)((Number)v1) : (Number)((Number)v2)));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Merged Map: {}", MsLoggy.mapToString(outMap));
        return outMap;
    }

    public static UUID getReliableUUID(String str) {
        Object hashedString = String.valueOf(Math.abs(str.hashCode()));
        while (((String)hashedString).length() < 36) {
            hashedString = (((String)hashedString).length() == 12 || ((String)hashedString).length() == 16 || ((String)hashedString).length() == 20 || ((String)hashedString).length() == 24 ? "-" : "0") + (String)hashedString;
        }
        return UUID.fromString((String)hashedString);
    }

    public static ResourceLocation pathPrepend(ResourceLocation original, String prepend) {
        return Reference.rl(original.getNamespace(), prepend + "/" + original.getPath());
    }
}

