/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import harmonised.pmmo.util.Reference;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RegistryUtil {
    public static ResourceLocation getId(RegistryAccess access, ItemStack stack) {
        return RegistryUtil.getId(access, stack.getItem());
    }

    public static ResourceLocation getId(RegistryAccess access, Item item) {
        return RegistryUtil.getId(access, Registries.ITEM, item);
    }

    public static ResourceLocation getId(BlockState blockState) {
        return RegistryUtil.getId(blockState.getBlock());
    }

    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getId(Holder<?> holder) {
        return ((ResourceKey)holder.unwrapKey().get()).location();
    }

    public static ResourceLocation getId(SoundEvent sound) {
        return BuiltInRegistries.SOUND_EVENT.getKey((Object)sound);
    }

    public static ResourceLocation getId(Entity entity) {
        return RegistryUtil.getId(entity.getType());
    }

    public static ResourceLocation getId(EntityType<?> entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entity);
    }

    public static ResourceLocation getId(MobEffect effect) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
    }

    public static <T> ResourceLocation getId(RegistryAccess access, ResourceKey<Registry<T>> registry, T source) {
        return access.registryOrThrow(registry).getKey(source);
    }

    public static ResourceLocation getAttributeId(Holder<Attribute> attribute) {
        return BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)attribute.value()));
    }

    public static <T> boolean isInTag(RegistryAccess access, ResourceKey<Registry<T>> registry, String objectID, String tagId) {
        return RegistryUtil.isInTag(access, registry, Reference.of(objectID), tagId);
    }

    public static <T> boolean isInTag(RegistryAccess access, ResourceKey<Registry<T>> registry, ResourceLocation objectID, String tagId) {
        Registry reg = access.registryOrThrow(registry);
        TagKey tag = TagKey.create(registry, (ResourceLocation)Reference.of(tagId));
        Optional holder = reg.getHolder(ResourceKey.create(registry, (ResourceLocation)objectID));
        return holder.map(h -> h.is(tag)).orElse(false);
    }
}

