/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.config.codecs.CodecTypes;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class SalvageEvent
extends PlayerEvent {
    ItemStack inputStack;
    CodecTypes.SalvageData salvage;
    ItemStack outputStack;
    private APIUtils.SalvageBuilder salvageBuilder;

    public SalvageEvent(ServerPlayer player, ItemStack inputStack, Map.Entry<ResourceLocation, CodecTypes.SalvageData> salvage) {
        super((Player)player);
        this.inputStack = inputStack;
        this.salvage = salvage.getValue();
        this.outputStack = new ItemStack((ItemLike)player.m_9236_().m_9598_().m_175515_(Registries.f_256913_).m_7745_(salvage.getKey()));
        this.salvageBuilder = APIUtils.SalvageBuilder.start().setChancePerLevel(salvage.getValue().chancePerLevel()).setLevelReq(salvage.getValue().levelReq()).setXpAward(salvage.getValue().xpAward()).setSalvageMax(salvage.getValue().salvageMax()).setBaseChance(salvage.getValue().baseChance()).setMaxChance(salvage.getValue().maxChance());
    }

    public CodecTypes.SalvageData getSalvage() {
        return this.salvageBuilder.build();
    }

    public ItemStack getInputStack() {
        return this.inputStack;
    }

    public APIUtils.SalvageBuilder getBuilder() {
        return this.salvageBuilder;
    }

    public ItemStack getOutputStack() {
        return this.outputStack;
    }

    public void setOutputStack(ItemStack outputStack) {
        this.outputStack = outputStack;
    }

    public boolean isCancelable() {
        return true;
    }
}

