/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SelectionWidget<T extends SelectionEntry<?>>
extends AbstractWidget {
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/resource_packs.png");
    private static final int ENTRY_HEIGHT = 20;
    private final Component title;
    private final Consumer<T> selectCallback;
    private List<T> entries = new ArrayList<T>();
    private T selected = null;
    private boolean extended = false;
    private int scrollOffset = 0;
    private Font font;

    public SelectionWidget(int x, int y, int width, Component title, Consumer<T> selectCallback) {
        super(x, y, width, 20, (Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        this.title = title;
        this.selectCallback = selectCallback;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.m_280027_(f_93617_, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, 66);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selected != null) {
            ((SelectionEntry)this.selected).render(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, false, this.getFGColor(), this.f_93625_);
        } else {
            graphics.m_280430_(this.font, this.title, this.m_252754_() + 6, this.m_252907_() + (this.f_93619_ - 8) / 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }
        if (this.extended) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            int boxHeight = Math.max(1, 20 * Math.min(this.entries.size(), 4)) + 2;
            graphics.m_285944_(RenderType.m_285907_(), this.m_252754_(), this.m_252907_() + 20 - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + 20 + boxHeight - 1, -1);
            graphics.m_285944_(RenderType.m_285907_(), this.m_252754_() + 1, this.m_252907_() + 20, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + 20 + boxHeight - 2, -16777216);
            graphics.m_280218_(ICONS, this.m_252754_() + this.f_93618_ - 17, this.m_252907_() + 6, 114, 5, 11, 7);
            T hoverEntry = this.getEntryAtPosition(mouseX, mouseY);
            for (int i = 0; i < 4; ++i) {
                int idx = i + this.scrollOffset;
                if (idx >= this.entries.size()) continue;
                int entryY = this.m_252907_() + (i + 1) * 20;
                SelectionEntry entry = (SelectionEntry)this.entries.get(idx);
                entry.render(graphics, this.m_252754_() + 1, entryY, this.f_93618_ - 2, entry == hoverEntry, this.getFGColor(), this.f_93625_);
            }
            if (this.entries.size() > 4) {
                float scale = 4.0f / (float)this.entries.size();
                int scrollY = this.m_252907_() + (int)((float)(20 * this.scrollOffset) * scale) + 20;
                int barHeight = (int)(80.0f * scale + 1.0f);
                int scrollBotY = Math.min(scrollY + barHeight, this.m_252907_() + 20 + boxHeight - 2);
                graphics.m_285944_(RenderType.m_285907_(), this.m_252754_() + this.f_93618_ - 5, scrollY, this.m_252754_() + this.f_93618_ - 1, scrollBotY, -10066330);
                graphics.m_285944_(RenderType.m_285907_(), this.m_252754_() + this.f_93618_ - 4, scrollY + 1, this.m_252754_() + this.f_93618_ - 2, scrollBotY - 1, -5592406);
            }
            graphics.m_280168_().m_85849_();
        } else {
            graphics.m_280218_(ICONS, this.m_252754_() + this.f_93618_ - 17, this.m_252907_() + 6, 82, 20, 11, 7);
        }
    }

    public int m_93694_() {
        if (this.extended) {
            return 20 * (Math.min(this.entries.size(), 4) + 1) + 1;
        }
        return 20;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.m_93694_())) {
            int maxX = this.m_252754_() + this.f_93618_ - (this.entries.size() > 4 ? 5 : 0);
            int maxY = this.m_252907_() + 20 * Math.min(this.entries.size() + 1, 5);
            if (this.extended && mouseX < (double)maxX && mouseY > (double)(this.m_252907_() + 20) && mouseY < (double)maxY) {
                this.setSelected(this.getEntryAtPosition(mouseX, mouseY), true);
            }
            if (mouseY < (double)(this.m_252907_() + 20) && mouseX < (double)(this.m_252754_() + this.f_93618_) || mouseX < (double)maxX) {
                this.extended = !this.extended;
                this.scrollOffset = 0;
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        this.extended = false;
        this.scrollOffset = 0;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxY = this.m_252907_() + 20 * Math.min(this.entries.size() + 1, 5);
        if (this.extended && mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_) && mouseY > (double)(this.m_252907_() + 20) && mouseY < (double)maxY) {
            if (delta < 0.0 && this.scrollOffset < this.entries.size() - 4) {
                ++this.scrollOffset;
            } else if (delta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        return pMouseX >= (double)this.m_252754_() && pMouseY >= (double)this.m_252907_() && pMouseX < (double)(this.m_252754_() + this.f_93618_) && pMouseY < (double)(this.m_252907_() + this.m_93694_());
    }

    private T getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.m_252754_() || mouseX > (double)(this.m_252754_() + this.f_93618_) || mouseY < (double)(this.m_252907_() + 20) || mouseY > (double)(this.m_252907_() + 100)) {
            return null;
        }
        double posY = mouseY - (double)(this.m_252907_() + 20);
        int idx = (int)(posY / 20.0) + this.scrollOffset;
        return (T)(idx < this.entries.size() ? (SelectionEntry)this.entries.get(idx) : null);
    }

    public void setEntries(Collection<T> entry) {
        this.entries = new ArrayList<T>(entry);
    }

    public void setSelected(T selected, boolean notify) {
        this.selected = selected;
        if (notify && this.selectCallback != null) {
            this.selectCallback.accept(selected);
        }
    }

    public T getSelected() {
        return this.selected;
    }

    public Stream<T> stream() {
        return this.entries.stream();
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public static class SelectionEntry<T>
    implements GuiEventListener {
        private Font font;
        public final Component message;
        public T reference;

        public SelectionEntry(Component message, T reference) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.message = message;
            this.reference = reference;
        }

        public void render(GuiGraphics graphics, int x, int y, int width, boolean hovered, int fgColor, float alpha) {
            if (hovered) {
                graphics.m_285944_(RenderType.m_285907_(), x, y, x + width, y + 20, -6250336);
            }
            FormattedCharSequence text = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{this.font.m_92854_((FormattedText)this.message, width - 12)}));
            graphics.m_280648_(this.font, text, x + 6, y + 6, fgColor | Mth.m_14167_((float)(alpha * 255.0f)) << 24);
        }

        public void m_93692_(boolean p_265728_) {
        }

        public boolean m_93696_() {
            return false;
        }
    }
}

