/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.GlossarySelectScreen;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import harmonised.pmmo.client.utils.ClientUtils;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.client.utils.DataMirror;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.config.codecs.PlayerData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class StatScrollWidget
extends ScrollPanel {
    Minecraft mc = Minecraft.m_91087_();
    Core core = Core.get(LogicalSide.CLIENT);
    private final List<Element> content = new ArrayList<Element>();
    private Supplier<List<ItemStack>> itemSupplier = () -> CreativeModeTabs.m_258007_().m_260957_().stream().toList();
    private static final String PREDICATE_KEY = "usesPredicate";

    private StatScrollWidget(int width, int height, int top, int left) {
        super(Minecraft.m_91087_(), width, height, top, left, 4);
        CreativeModeTabs.m_269226_((FeatureFlagSet)this.mc.f_91074_.f_108617_.m_247016_(), (boolean)this.mc.f_91074_.m_36337_(), (HolderLookup.Provider)this.mc.f_91074_.f_108545_.m_9598_());
    }

    public StatScrollWidget(int width, int height, int top, int left, int pointless) {
        this(width, height, top, left);
        this.populateLocation(List.of(this.mc.f_91073_.m_46472_().m_135782_()), new ReqType[]{ReqType.TRAVEL}, new ModifierDataType[]{ModifierDataType.DIMENSION}, "", false, true, true);
        this.populateLocation(List.of(((ResourceKey)this.mc.f_91073_.m_204166_(this.mc.f_91074_.m_20183_()).m_203543_().get()).m_135782_()), new ReqType[]{ReqType.TRAVEL}, new ModifierDataType[]{ModifierDataType.BIOME}, "", true, true, true);
    }

    public StatScrollWidget(int width, int height, int top, int left, ItemStack stack) {
        this(width, height, top, left);
        EventType[] events = stack.m_41720_() instanceof BlockItem ? EventType.BLOCKITEM_APPLICABLE_EVENTS : EventType.ITEM_APPLICABLE_EVENTS;
        ReqType[] reqs = stack.m_41720_() instanceof BlockItem ? ReqType.BLOCKITEM_APPLICABLE_EVENTS : ReqType.ITEM_APPLICABLE_EVENTS;
        this.populateItems(List.of(stack), events, reqs, ModifierDataType.values(), "", true, true);
    }

    public StatScrollWidget(int width, int height, int top, int left, Entity entity) {
        this(width, height, top, left);
        this.populateEntity(List.of(entity), EventType.ENTITY_APPLICABLE_EVENTS, ReqType.ENTITY_APPLICABLE_EVENTS, entity instanceof Player, "");
    }

    public StatScrollWidget(int width, int height, int top, int left, BlockPos pos) {
        this(width, height, top, left);
        this.populateBlockFromWorld(pos, EventType.BLOCK_APPLICABLE_EVENTS, ReqType.BLOCK_APPLICABLE_EVENTS);
    }

    public StatScrollWidget(int width, int height, int top, int left, GlossarySelectScreen.SELECTION selection, GlossarySelectScreen.OBJECT object, String skill, GuiEnumGroup type) {
        this(width, height, top, left);
        this.generateGlossary(selection, object, skill, type);
    }

    private int step(int level) {
        return level * 10;
    }

    public void generateGlossary(GlossarySelectScreen.SELECTION selection, GlossarySelectScreen.OBJECT object, String skill, GuiEnumGroup type) {
        block0 : switch (selection) {
            case REQS: {
                EventType[] events = new EventType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        ReqType[] reqTypeArray;
                        if (type == null) {
                            reqTypeArray = ReqType.ITEM_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray2 = new ReqType[1];
                            reqTypeArray = reqTypeArray2;
                            reqTypeArray2[0] = (ReqType)type;
                        }
                        this.populateItems(this.itemSupplier.get(), events, reqTypeArray, bonuses, skill, false, false);
                        break block0;
                    }
                    case BLOCKS: {
                        ReqType[] reqTypeArray;
                        Collection collection = ForgeRegistries.BLOCKS.getValues();
                        if (type == null) {
                            reqTypeArray = ReqType.BLOCK_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray3 = new ReqType[1];
                            reqTypeArray = reqTypeArray3;
                            reqTypeArray3[0] = (ReqType)type;
                        }
                        this.populateBlocks(collection, events, reqTypeArray, false, skill);
                        break block0;
                    }
                    case ENTITY: {
                        ReqType[] reqTypeArray;
                        List<Entity> list = ForgeRegistries.ENTITY_TYPES.getValues().stream().map(entityType -> entityType.m_20615_((Level)this.mc.f_91073_)).filter(entity -> entity != null).toList();
                        if (type == null) {
                            reqTypeArray = ReqType.ENTITY_APPLICABLE_EVENTS;
                        } else {
                            ReqType[] reqTypeArray4 = new ReqType[1];
                            reqTypeArray = reqTypeArray4;
                            reqTypeArray4[0] = (ReqType)type;
                        }
                        this.populateEntity(list, events, reqTypeArray, false, skill);
                        break block0;
                    }
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList(), new ReqType[]{ReqType.TRAVEL}, bonuses, skill, false, false, false);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(this.mc.f_91074_.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_6566_().stream().toList(), new ReqType[]{ReqType.TRAVEL}, bonuses, skill, true, false, false);
                        break block0;
                    }
                    case ENCHANTS: {
                        this.populateEnchants(ForgeRegistries.ENCHANTMENTS.getValues().stream().map(ench -> RegistryUtil.getId(ench)).toList(), skill);
                        break block0;
                    }
                }
                break;
            }
            case XP: {
                ReqType[] reqs = new ReqType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        EventType[] eventTypeArray;
                        if (type == null) {
                            eventTypeArray = EventType.ITEM_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray2 = new EventType[1];
                            eventTypeArray = eventTypeArray2;
                            eventTypeArray2[0] = (EventType)type;
                        }
                        this.populateItems(this.itemSupplier.get(), eventTypeArray, reqs, bonuses, skill, false, false);
                        break block0;
                    }
                    case BLOCKS: {
                        EventType[] eventTypeArray;
                        Collection collection = ForgeRegistries.BLOCKS.getValues();
                        if (type == null) {
                            eventTypeArray = EventType.BLOCK_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray3 = new EventType[1];
                            eventTypeArray = eventTypeArray3;
                            eventTypeArray3[0] = (EventType)type;
                        }
                        this.populateBlocks(collection, eventTypeArray, reqs, false, skill);
                        break block0;
                    }
                    case ENTITY: {
                        EventType[] eventTypeArray;
                        List<Entity> list = ForgeRegistries.ENTITY_TYPES.getValues().stream().map(entityType -> entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_)).filter(entity -> entity != null).toList();
                        if (type == null) {
                            eventTypeArray = EventType.ENTITY_APPLICABLE_EVENTS;
                        } else {
                            EventType[] eventTypeArray4 = new EventType[1];
                            eventTypeArray = eventTypeArray4;
                            eventTypeArray4[0] = (EventType)type;
                        }
                        this.populateEntity(list, eventTypeArray, reqs, false, skill);
                        break block0;
                    }
                    case EFFECTS: {
                        this.populateEffects(ForgeRegistries.MOB_EFFECTS.getValues(), new EventType[]{EventType.EFFECT}, reqs, skill);
                        break block0;
                    }
                }
                break;
            }
            case BONUS: {
                ReqType[] reqs = new ReqType[]{};
                EventType[] events = new EventType[]{};
                switch (object) {
                    case ITEMS: {
                        ModifierDataType[] modifierDataTypeArray;
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray2 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray2;
                            modifierDataTypeArray2[0] = (ModifierDataType)type;
                        }
                        this.populateItems(this.itemSupplier.get(), events, reqs, modifierDataTypeArray, skill, false, false);
                        break block0;
                    }
                    case DIMENSIONS: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ResourceLocation> list = this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray3 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray3;
                            modifierDataTypeArray3[0] = (ModifierDataType)type;
                        }
                        this.populateLocation(list, reqs, modifierDataTypeArray, skill, false, false, false);
                        break block0;
                    }
                    case BIOMES: {
                        ModifierDataType[] modifierDataTypeArray;
                        List<ResourceLocation> list = this.mc.f_91074_.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_6566_().stream().toList();
                        if (type == null) {
                            modifierDataTypeArray = ModifierDataType.values();
                        } else {
                            ModifierDataType[] modifierDataTypeArray4 = new ModifierDataType[1];
                            modifierDataTypeArray = modifierDataTypeArray4;
                            modifierDataTypeArray4[0] = (ModifierDataType)type;
                        }
                        this.populateLocation(list, reqs, modifierDataTypeArray, skill, true, false, false);
                        break block0;
                    }
                }
                break;
            }
            case SALVAGE: {
                if (object != GlossarySelectScreen.OBJECT.ITEMS) break;
                this.populateItems(this.itemSupplier.get(), new EventType[0], new ReqType[0], new ModifierDataType[0], skill, true, false);
                break;
            }
            case VEIN: {
                ReqType[] reqs = new ReqType[]{};
                EventType[] events = new EventType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case ITEMS: {
                        this.populateItems(this.itemSupplier.get(), events, reqs, bonuses, skill, false, true);
                        break block0;
                    }
                    case BLOCKS: {
                        this.populateBlocks(ForgeRegistries.BLOCKS.getValues(), events, reqs, true, skill);
                        break block0;
                    }
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList(), reqs, bonuses, skill, false, true, false);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(this.mc.f_91074_.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_6566_().stream().toList(), reqs, bonuses, skill, true, true, false);
                        break block0;
                    }
                }
                break;
            }
            case MOB_SCALING: {
                ReqType[] reqs = new ReqType[]{};
                ModifierDataType[] bonuses = new ModifierDataType[]{};
                switch (object) {
                    case DIMENSIONS: {
                        this.populateLocation(this.mc.f_91074_.f_108617_.m_105151_().stream().map(key -> key.m_135782_()).toList(), reqs, bonuses, skill, false, false, true);
                        break block0;
                    }
                    case BIOMES: {
                        this.populateLocation(this.mc.f_91074_.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_6566_().stream().toList(), reqs, bonuses, skill, true, false, true);
                        break block0;
                    }
                }
                break;
            }
            case PERKS: {
                this.populatePerks(skill);
                break;
            }
        }
    }

    private void populateItems(List<ItemStack> items, EventType[] events, ReqType[] reqs, ModifierDataType[] modifiers, String skillFilter, boolean includeSalvage, boolean includeVein) {
        for (ItemStack stack : items) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (items.size() > 1) {
                this.content.add(new RenderableElement(stack.m_41611_(), 1, (int)stack.m_41791_().f_43022_.m_126665_(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()), stack));
            }
            this.addEventSection(event -> {
                Map<String, Long> map = this.core.getExperienceAwards((EventType)event, stack, (Player)this.mc.f_91074_, new CompoundTag());
                if (stack.m_41720_() instanceof BlockItem) {
                    map = this.core.getCommonXpAwardData((Map<String, Long>)new HashMap<String, Long>(), (EventType)event, RegistryUtil.getId(stack), (Player)this.mc.f_91074_, ObjectType.BLOCK, TagUtils.stackTag(stack));
                }
                return map;
            }, events, skillFilter);
            this.addReqSection(reqType -> {
                Map<String, Integer> reqMap = this.core.getReqMap((ReqType)reqType, stack, true);
                if (reqType == ReqType.USE_ENCHANTMENT) {
                    this.core.getEnchantReqs(stack).forEach((skill, level) -> reqMap.merge((String)skill, (Integer)level, (o, n) -> o > n ? o : n));
                }
                if (stack.m_41720_() instanceof BlockItem) {
                    reqMap.putAll(this.core.getCommonReqData((Map<String, Integer>)new HashMap<String, Integer>(), ObjectType.BLOCK, RegistryUtil.getId(stack), (ReqType)reqType, TagUtils.stackTag(stack)));
                }
                return reqMap;
            }, CoreUtils.getEffects(this.core.getLoader().getLoader(ObjectType.ITEM).getData(RegistryUtil.getId(stack)).getNegativeEffect(), true), reqs, skillFilter);
            this.addModifierSection(mod -> this.core.getTooltipRegistry().bonusTooltipExists(RegistryUtil.getId(stack), (ModifierDataType)mod) ? this.core.getTooltipRegistry().getBonusTooltipData(RegistryUtil.getId(stack), (ModifierDataType)mod, stack) : this.core.getObjectModifierMap(ObjectType.ITEM, RegistryUtil.getId(stack), (ModifierDataType)mod, TagUtils.stackTag(stack)), modifiers, skillFilter);
            if (includeSalvage) {
                this.addSalvageSection(this.core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).salvage());
            }
            if (includeVein) {
                this.addItemVeinSection(this.core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).veinData(), stack.m_41720_() instanceof BlockItem);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateBlockFromWorld(BlockPos block, EventType[] events, ReqType[] reqs) {
        this.addEventSection(event -> this.core.getExperienceAwards((EventType)event, block, (Level)Minecraft.m_91087_().f_91073_, null, new CompoundTag()), events, "");
        this.addReqSection(reqType -> this.core.getReqMap((ReqType)reqType, block, (Level)Minecraft.m_91087_().f_91073_), new ArrayList<MobEffectInstance>(), reqs, "");
        this.addBlockVeinSection(this.core.getLoader().BLOCK_LOADER.getData(RegistryUtil.getId(Minecraft.m_91087_().f_91073_.m_8055_(block))).veinData());
    }

    private void populateBlocks(Collection<Block> blocks, EventType[] events, ReqType[] reqs, boolean includeVein, String skillFilter) {
        for (Block block : blocks) {
            int lengthBeforeProcessing = this.content.size() + 1;
            ItemStack stack = new ItemStack((ItemLike)block.m_5456_());
            ResourceLocation id = RegistryUtil.getId(block);
            this.content.add(new RenderableElement(stack.m_41611_(), 1, (int)stack.m_41791_().f_43022_.m_126665_(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()), block));
            this.addEventSection(event -> this.core.getTooltipRegistry().xpGainTooltipExists(id, (EventType)event) ? Collections.singletonMap(PREDICATE_KEY, 0L) : this.core.getObjectExperienceMap(ObjectType.BLOCK, id, (EventType)event, new CompoundTag()), events, skillFilter);
            this.addReqSection(reqType -> this.core.getPredicateRegistry().predicateExists(id, (ReqType)reqType) ? Collections.singletonMap(PREDICATE_KEY, 0) : this.core.getObjectSkillMap(ObjectType.BLOCK, id, (ReqType)reqType, new CompoundTag()), new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (includeVein) {
                this.addBlockVeinSection(this.core.getLoader().BLOCK_LOADER.getData(RegistryUtil.getId(block)).veinData());
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateEntity(List<? extends Entity> entities, EventType[] events, ReqType[] reqs, boolean isPlayer, String skillFilter) {
        for (Entity entity : entities) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (entities.size() > 1) {
                this.content.add(new RenderableElement(entity.m_5446_(), 1, 0xEEEEEE, (int)((Integer)Config.SECTION_HEADER_COLOR.get()), entity));
            }
            this.addEventSection(event -> this.core.getExperienceAwards((EventType)event, entity, null, new CompoundTag()), events, skillFilter);
            this.addReqSection(reqType -> this.core.getReqMap((ReqType)reqType, entity), new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (isPlayer) {
                this.addPlayerSection(entity);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private void populateEffects(Collection<MobEffect> effects, EventType[] events, ReqType[] reqs, String skillFilter) {
        for (MobEffect effect : effects) {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (effects.size() > 1) {
                this.content.addAll(TextElement.build(effect.m_19482_(), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (int lvl = 0; lvl <= this.getEffectHighestConfiguration(effect); ++lvl) {
                Map<String, Long> xpMap = this.core.getExperienceAwards(new MobEffectInstance(effect, 30, lvl), null, new CompoundTag());
                if (xpMap.isEmpty() || xpMap.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 0L)) continue;
                holder.addAll(TextElement.build((Component)Component.m_237113_((String)String.valueOf(lvl)), this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : xpMap.entrySet()) {
                    if (map.getValue() == 0L) continue;
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.addAll(TextElement.build((Component)LangProvider.EVENT_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
            if (lengthBeforeProcessing != this.content.size()) continue;
            this.content.remove(this.content.size() - 1);
        }
    }

    private int getEffectHighestConfiguration(MobEffect effect) {
        DataSource data = (DataSource)this.core.getLoader().getLoader(ObjectType.EFFECT).getData().get(RegistryUtil.getId(effect));
        return data == null ? 0 : ((EnhancementsData)data).skillArray().keySet().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    private void populateLocation(List<ResourceLocation> locations, ReqType[] reqs, ModifierDataType[] modifiers, String skillFilter, boolean isBiome, boolean includeVein, boolean includeScaling) {
        locations.forEach(loc -> {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (locations.size() > 1) {
                this.content.addAll(TextElement.build((Component)Component.m_237113_((String)loc.toString()).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            this.addReqSection(reqType -> this.core.getObjectSkillMap(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc, (ReqType)reqType, new CompoundTag()), isBiome ? CoreUtils.getEffects(this.core.getLoader().getLoader(ObjectType.BIOME).getData((ResourceLocation)loc).getNegativeEffect(), true) : new ArrayList<MobEffectInstance>(), reqs, skillFilter);
            if (reqs.length > 0 && isBiome) {
                this.addReqEffectSection(CoreUtils.getEffects(isBiome ? this.core.getLoader().getLoader(ObjectType.BIOME).getData((ResourceLocation)loc).getPositiveEffect() : this.core.getLoader().getLoader(ObjectType.DIMENSION).getData((ResourceLocation)loc).getPositiveEffect(), false), false);
            }
            this.addModifierSection(mod -> this.core.getObjectModifierMap(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc, (ModifierDataType)mod, new CompoundTag()), modifiers, skillFilter);
            if (includeVein) {
                this.addVeinBlacklistSection(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc);
            }
            if (includeScaling) {
                this.addMobModifierSection(isBiome ? ObjectType.BIOME : ObjectType.DIMENSION, (ResourceLocation)loc);
            }
            if (lengthBeforeProcessing == this.content.size()) {
                this.content.remove(this.content.size() - 1);
            }
        });
    }

    private void populateEnchants(List<ResourceLocation> enchants, String skillFilter) {
        enchants.forEach(ench -> {
            int lengthBeforeProcessing = this.content.size() + 1;
            if (enchants.size() > 1) {
                this.content.addAll(TextElement.build((Component)Component.m_237113_((String)ench.toString()).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            }
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (int i = 0; i <= ((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ench)).m_6586_(); ++i) {
                Map<String, Integer> reqMap = this.core.getEnchantmentReqs((ResourceLocation)ench, i).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)e.getValue()));
                if (reqMap.isEmpty() || reqMap.entrySet().stream().allMatch(entry -> (Integer)entry.getValue() == 0)) continue;
                holder.addAll(TextElement.build((Component)Component.m_237113_((String)String.valueOf(i)), this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Integer> map : reqMap.entrySet()) {
                    if (map.getValue() == 0) continue;
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.addAll(TextElement.build((Component)LangProvider.REQ_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
            if (lengthBeforeProcessing == this.content.size()) {
                this.content.remove(this.content.size() - 1);
            }
        });
    }

    private void populatePerks(String skillFilter) {
        for (EventType cause : EventType.values()) {
            ArrayList holder = new ArrayList();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ((List)PerksConfig.PERK_SETTINGS.get().getOrDefault(cause, new ArrayList())).forEach(arg_0 -> this.lambda$populatePerks$30(skillFilter, (Player)player, holder, arg_0));
            if (holder.size() <= 0) continue;
            this.content.addAll(TextElement.build(cause, this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(holder);
        }
        for (DataMirror.GLM glm : ((DataMirror)this.core.getData()).lootModifiers) {
            if (!skillFilter.isEmpty() && !glm.skill().equals(skillFilter)) continue;
            ArrayList elements = new ArrayList();
            glm.getGUILines(this.core).forEach(c -> elements.addAll(TextElement.build(c, this.width, c.m_7383_().m_131154_() ? 0 : 1, c.m_7383_().m_131154_() ? 0xFFFFFF : 0xEEEEEE, c.m_7383_().m_131154_(), (int)((Integer)Config.SECTION_HEADER_COLOR.get()))));
            this.content.addAll(elements);
        }
    }

    private void addEventSection(Function<EventType, Map<String, Long>> xpSrc, EventType[] events, String skillFilter) {
        if (events.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (EventType event : events) {
                Map<String, Long> xpAwards = CoreUtils.processSkillGroupXP(xpSrc.apply(event)).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
                if (xpAwards.containsKey(PREDICATE_KEY)) {
                    holder.addAll(TextElement.build((Component)LangProvider.ADDON_AFFECTED_ATTRIBUTE.asComponent(), this.width, 5, 16751619, false, 0));
                    continue;
                }
                if (xpAwards.isEmpty()) continue;
                holder.addAll(TextElement.build(event, this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Long> map : xpAwards.entrySet()) {
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, 5, CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (holder.size() > 0) {
                this.content.addAll(TextElement.build((Component)LangProvider.EVENT_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
        }
    }

    private void addReqSection(Function<ReqType, Map<String, Integer>> reqSrc, List<MobEffectInstance> reqEffects, ReqType[] reqs, String skillFilter) {
        if (reqs.length > 0) {
            ArrayList<TextElement> holder = new ArrayList<TextElement>();
            for (ReqType reqType : reqs) {
                Map<String, Integer> reqMap = CoreUtils.processSkillGroupReqs(reqSrc.apply(reqType)).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (reqMap.isEmpty() || reqMap.entrySet().stream().allMatch(entry -> (Integer)entry.getValue() == 0)) continue;
                holder.addAll(TextElement.build(reqType, this.width, 1, 0xFFFFFF, false, 0));
                for (Map.Entry<String, Integer> map : reqMap.entrySet()) {
                    if (map.getValue() == 0) continue;
                    holder.addAll(TextElement.build(map.getKey(), map.getValue(), this.width, this.step(1), CoreUtils.getSkillColor(map.getKey())));
                }
            }
            if (!holder.isEmpty()) {
                this.content.addAll(TextElement.build((Component)LangProvider.REQ_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
                this.addReqEffectSection(reqEffects, true);
            }
        }
    }

    private void addReqEffectSection(List<MobEffectInstance> reqEffects, boolean isNegative) {
        if (reqEffects.size() > 0) {
            this.content.addAll(TextElement.build((Component)(isNegative ? LangProvider.REQ_EFFECTS_HEADER.asComponent() : LangProvider.BIOME_EFFECT_POS.asComponent()), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            for (MobEffectInstance mei : reqEffects) {
                this.content.addAll(TextElement.build(mei.m_19544_().m_19482_(), this.width, this.step(1), 0xFFFFFF, false, 0));
            }
        }
    }

    private void addModifierSection(Function<ModifierDataType, Map<String, Double>> bonusSrc, ModifierDataType[] mods, String skillFilter) {
        if (mods.length > 0) {
            ArrayList holder = new ArrayList();
            for (ModifierDataType mod : mods) {
                Map<String, Double> modifiers = bonusSrc.apply(mod).entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(skillFilter)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Double)e.getValue()));
                if (modifiers.isEmpty()) continue;
                this.content.addAll(TextElement.build(mod, this.width, 1, 0xFFFFFF, false, 0));
                modifiers.forEach((key, value) -> this.content.addAll(TextElement.build(key, value, this.width, this.step(1), CoreUtils.getSkillColor(key))));
            }
            if (holder.size() > 0) {
                this.content.addAll(TextElement.build((Component)LangProvider.MODIFIER_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xEEEEEE, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
                this.content.addAll(holder);
            }
        }
    }

    private void addSalvageSection(Map<ResourceLocation, CodecTypes.SalvageData> salvage) {
        if (!salvage.isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> salvageEntry : salvage.entrySet()) {
                CodecTypes.SalvageData data = salvageEntry.getValue();
                ItemStack resultStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(salvageEntry.getKey()));
                this.content.addAll(TextElement.build(resultStack.m_41611_(), this.width, this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get())));
                if (!data.levelReq().isEmpty()) {
                    this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_LEVEL_REQ.asComponent().m_130940_(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                    for (Map.Entry<String, Integer> entry : data.levelReq().entrySet()) {
                        this.content.addAll(TextElement.build(entry.getKey(), entry.getValue(), this.width, this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                    }
                }
                this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).m_130940_(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).m_130940_(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                if (!data.chancePerLevel().isEmpty()) {
                    this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_CHANCE_MOD.asComponent().m_130940_(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                    for (Map.Entry<String, Number> entry : data.chancePerLevel().entrySet()) {
                        this.content.addAll(TextElement.build(entry.getKey(), (Double)entry.getValue(), this.width, this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                    }
                }
                if (data.xpAward().isEmpty()) continue;
                this.content.addAll(TextElement.build((Component)LangProvider.SALVAGE_XP_AWARD.asComponent().m_130940_(ChatFormatting.UNDERLINE), this.width, this.step(1), 0xFFFFFF, false, 0));
                for (Map.Entry<String, Number> entry : data.xpAward().entrySet()) {
                    this.content.addAll(TextElement.build(entry.getKey(), (Long)entry.getValue(), this.width, this.step(2), CoreUtils.getSkillColor(entry.getKey())));
                }
            }
        }
    }

    private void addItemVeinSection(VeinData veinData, boolean isBlockItem) {
        if (!veinData.isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_RATE.asComponent(veinData.chargeRate.orElse(0.0) * 2.0), this.width, this.step(1), 0xFFFFFF, false, 0));
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_CAP.asComponent(veinData.chargeCap.orElse(0)), this.width, this.step(1), 0xFFFFFF, false, 0));
            if (isBlockItem) {
                this.content.addAll(TextElement.build((Component)LangProvider.VEIN_CONSUME.asComponent(veinData.consumeAmount.orElse(0)), this.width, this.step(1), 0xFFFFFF, false, 0));
            }
        }
    }

    private void addBlockVeinSection(VeinData veinData) {
        if (veinData.consumeAmount.orElse(0) != 0) {
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, 1, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_CONSUME.asComponent(veinData.consumeAmount.orElse(0)), this.width, this.step(1), 0xFFFFFF, false, 0));
        }
    }

    private void addPlayerSection(Entity entity) {
        this.content.addAll(TextElement.build((Component)LangProvider.PLAYER_HEADER.asComponent(), this.width, this.step(1), 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
        PlayerData data = this.core.getLoader().PLAYER_LOADER.getData(ResourceLocation.parse((String)entity.m_20148_().toString()));
        this.content.addAll(TextElement.build((Component)LangProvider.PLAYER_IGNORE_REQ.asComponent(data.ignoreReq()), this.width, this.step(2), 0xFFFFFF, false, 0));
        if (!data.bonuses().isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.PLAYER_BONUSES.asComponent(), this.width, this.step(2), 0xFFFFFF, true, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get())));
            for (Map.Entry<String, Double> bonus : data.bonuses().entrySet()) {
                this.content.addAll(TextElement.build(bonus.getKey(), bonus.getValue(), this.width, this.step(3), CoreUtils.getSkillColor(bonus.getKey())));
            }
        }
        Map<String, Long> rawXp = this.core.getData().getXpMap(entity.m_20148_());
        LinkedHashMap orderedMap = new LinkedHashMap();
        ArrayList<String> skillKeys = new ArrayList<String>(rawXp.keySet().stream().toList());
        skillKeys.sort(Comparator.comparingLong(a -> (Long)rawXp.get(a)).reversed());
        skillKeys.forEach(skill -> orderedMap.put(skill, this.core.getData().getLevelFromXP((Long)rawXp.get(skill))));
        this.content.addAll(TextElement.build((Component)LangProvider.SKILL_LIST_HEADER.asComponent(), this.step(1), this.width, 0xFFFFFF, true, (int)((Integer)Config.SECTION_HEADER_COLOR.get())));
        for (Map.Entry rawMap : orderedMap.entrySet()) {
            this.content.addAll(TextElement.build((String)rawMap.getKey(), (Integer)rawMap.getValue(), this.width, this.step(2), CoreUtils.getSkillColor((String)rawMap.getKey())));
        }
    }

    private void addVeinBlacklistSection(ObjectType type, ResourceLocation location) {
        LocationData loader = (LocationData)this.core.getLoader().getLoader(type).getData(location);
        if (!loader.veinBlacklist().isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.VEIN_BLACKLIST_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, this.step(1), 0xFFFFFF, false, 0));
            for (ResourceLocation blockID : loader.veinBlacklist()) {
                this.content.addAll(TextElement.build((Component)Component.m_237113_((String)blockID.toString()), this.width, this.step(2), 0xEEEEEE, false, 0));
            }
        }
    }

    private void addMobModifierSection(ObjectType type, ResourceLocation location) {
        LocationData loader = (LocationData)this.core.getLoader().getLoader(type).getData(location);
        if (!loader.mobModifiers().isEmpty() || !loader.globalMobModifiers().isEmpty()) {
            this.content.addAll(TextElement.build((Component)LangProvider.MOB_MODIFIER_HEADER.asComponent().m_130940_(ChatFormatting.BOLD), this.width, this.step(1), 0xFFFFFF, false, 0));
            for (MobModifier mobModifier : loader.globalMobModifiers()) {
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(mobModifier.attribute());
                MutableComponent text = attribute == null ? Component.m_237113_((String)mobModifier.attribute().toString()) : Component.m_237115_((String)attribute.m_22087_());
                text.m_7220_((Component)Component.m_237113_((String)(": " + mobModifier.display() + mobModifier.amount())));
                this.content.addAll(TextElement.build((Component)text, this.width, this.step(2), 0xFFFFFF, false, 0xFFFFFF));
            }
            for (Map.Entry entry : loader.mobModifiers().entrySet()) {
                Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue((ResourceLocation)entry.getKey())).m_20615_((Level)this.mc.f_91073_);
                this.content.add(new RenderableElement(entity.m_7755_(), this.step(1), 0xFFFFFF, (int)((Integer)Config.SALVAGE_ITEM_COLOR.get()), entity));
                for (MobModifier mobModifier : (List)entry.getValue()) {
                    Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(mobModifier.attribute());
                    MutableComponent text = attribute == null ? Component.m_237113_((String)mobModifier.attribute().toString()) : Component.m_237115_((String)attribute.m_22087_());
                    text.m_7220_((Component)Component.m_237113_((String)(": " + mobModifier.display() + mobModifier.amount())));
                    this.content.addAll(TextElement.build((Component)text, this.width, this.step(2), 0xFFFFFF, false, 0xFFFFFF));
                }
            }
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    protected int getContentHeight() {
        return this.content.size() * 12;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTicks) {
        return super.m_6375_(mouseX, mouseY, partialTicks);
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        for (int i = 0; i < this.content.size(); ++i) {
            this.content.get(i).render(guiGraphics, this.left, (int)((float)(relativeY + i * 12) - this.scrollDistance), this.width, tess);
        }
    }

    private /* synthetic */ void lambda$populatePerks$30(String skillFilter, Player player, List holder, CompoundTag nbt) {
        if (!skillFilter.isEmpty() && nbt.m_128441_("skill") && !nbt.m_128461_("skill").equals(skillFilter)) {
            return;
        }
        ResourceLocation perkID = ResourceLocation.parse((String)nbt.m_128461_("perk"));
        nbt.m_128405_("level", nbt.m_128441_("skill") ? Core.get(player.m_9236_()).getData().getPlayerSkillLevel(nbt.m_128461_("skill"), player.m_20148_()) : 0);
        holder.addAll(TextElement.build((Component)Component.m_237115_((String)("perk." + perkID.m_135827_() + "." + perkID.m_135815_())), this.width, this.step(1), 65280, false, 65280));
        holder.addAll(TextElement.build((Component)this.core.getPerkRegistry().getDescription(perkID).m_6881_(), this.width, this.step(1), 0x99CCFF, false, 0x99CCFF));
        for (MutableComponent line : this.core.getPerkRegistry().getStatusLines(perkID, player, nbt)) {
            holder.addAll(TextElement.build((Component)line, this.width, this.step(2), 0xAAFFFF, false, 0xAAFFFF));
        }
    }

    private record RenderableElement(Component text, int xOffset, int color, int headerColor, ItemStack stack, Block block, Entity entity) implements Element
    {
        RenderableElement(Component text, int xOffset, int color, int headerColor, ItemStack stack) {
            this(text, xOffset, color, headerColor, stack, null, null);
        }

        RenderableElement(Component text, int xOffset, int color, int headerColor, Block block) {
            this(text, xOffset, color, headerColor, null, block, null);
        }

        RenderableElement(Component text, int xOffset, int color, int headerColor, Entity entity) {
            this(text, xOffset, color, headerColor, null, null, entity);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, Tesselator tess) {
            graphics.m_285944_(RenderType.m_285907_(), x, y, x + width, y + 12, this.headerColor());
            Font font = Minecraft.m_91087_().f_91062_;
            if (this.stack() != null || this.block() != null) {
                ItemStack renderStack = this.stack() == null ? new ItemStack((ItemLike)this.block().m_5456_()) : this.stack();
                graphics.m_280480_(renderStack, x + width - 25, y);
                graphics.m_280430_(font, renderStack.m_41611_(), x + 10, y, 0xFFFFFF);
            } else if (this.entity != null && this.entity instanceof LivingEntity) {
                int scale = Math.max(1, 10 / Math.max(1, (int)this.entity.m_20191_().m_82309_()));
                InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)graphics, (int)(x + width - 20), (int)(y + 12), (int)scale, (float)0.0f, (float)0.0f, (LivingEntity)((LivingEntity)this.entity));
                graphics.m_280430_(font, this.entity.m_5446_(), x, y, 0xFFFFFF);
            }
        }
    }

    private record TextElement(ClientTooltipComponent text, int xOffset, int color, boolean isHeader, int headerColor) implements Element
    {
        public static List<TextElement> build(Component component, int width, int xOffset, int color, boolean isHeader, int headerColor) {
            return TextElement.format(component.m_6881_(), width, xOffset, color, isHeader, headerColor);
        }

        public static List<TextElement> build(String key, int value, int width, int xOffset, int color) {
            return TextElement.format(Component.m_237115_((String)("pmmo." + key)).m_7220_((Component)Component.m_237113_((String)(": " + value))), width, xOffset, color, false, 0);
        }

        public static List<TextElement> build(String key, long value, int width, int xOffset, int color) {
            return TextElement.format(Component.m_237115_((String)("pmmo." + key)).m_7220_((Component)Component.m_237113_((String)(": " + value))), width, xOffset, color, false, 0);
        }

        public static List<TextElement> build(String key, double value, int width, int xOffset, int color) {
            return TextElement.format(Component.m_237115_((String)("pmmo." + key)).m_7220_((Component)Component.m_237113_((String)(": " + DP.dp(value * 100.0) + "%"))), width, xOffset, color, false, 0);
        }

        public static List<TextElement> build(Enum<?> type, int width, int xOffset, int color, boolean isHeader, int headerColor) {
            return TextElement.format(Component.m_237115_((String)("pmmo.enum." + type.name())), width - xOffset, xOffset, color, isHeader, headerColor);
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, Tesselator tess) {
            if (this.isHeader()) {
                graphics.m_285944_(RenderType.m_285907_(), x, y, x + width, y + 12, this.headerColor());
            }
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)tess.m_85915_());
            this.text().m_142440_(Minecraft.m_91087_().f_91062_, x + this.xOffset(), y, graphics.m_280168_().m_85850_().m_252922_(), buffer);
            buffer.m_109911_();
        }

        private static List<TextElement> format(MutableComponent component, int width, int xOffset, int color, boolean isHeader, int headerColor) {
            return ClientUtils.ctc(component.m_130948_(component.m_7383_().m_178520_(color)), width).stream().map(line -> new TextElement((ClientTooltipComponent)line, xOffset, color, isHeader, headerColor)).toList();
        }
    }

    private static interface Element {
        public void render(GuiGraphics var1, int var2, int var3, int var4, Tesselator var5);
    }
}

