/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.utils;

import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientUtils {
    private static Minecraft mc = Minecraft.m_91087_();
    private static Map<String, Map<Integer, Map<ReqType, List<Component>>>> cache = new HashMap<String, Map<Integer, Map<ReqType, List<Component>>>>();

    public static List<ClientTooltipComponent> ctc(MutableComponent component, int width) {
        return ClientUtils.mc.f_91062_.m_92923_((FormattedText)component, width).stream().map(fcs -> ClientTooltipComponent.m_169948_((FormattedCharSequence)fcs)).toList();
    }

    public static void invalidateUnlocksCache() {
        cache.clear();
    }

    private static void cacheUnlocks() {
        LocalPlayer player = ClientUtils.mc.f_91074_;
        Core core = Core.get(LogicalSide.CLIENT);
        Arrays.stream(ReqType.values()).forEach(reqType -> {
            if (reqType.itemApplicable) {
                ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).forEach(stack -> core.getReqMap((ReqType)reqType, (ItemStack)stack, false).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(stack.m_41611_())));
            }
            if (reqType.blockApplicable) {
                ForgeRegistries.BLOCKS.getValues().forEach(block -> core.getCommonReqData((Map<String, Integer>)new HashMap<String, Integer>(), ObjectType.BLOCK, RegistryUtil.getId(block), (ReqType)reqType, new CompoundTag()).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(new ItemStack((ItemLike)block.m_5456_()).m_41611_())));
            }
            if (reqType.entityApplicable) {
                ForgeRegistries.ENTITY_TYPES.getValues().stream().map(entity -> entity.m_20615_(player.m_9236_())).forEach(entity -> core.getReqMap((ReqType)reqType, (Entity)entity).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(entity.m_5446_())));
            }
            if (reqType == ReqType.TRAVEL) {
                player.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_6579_().stream().map(entry -> ((ResourceKey)entry.getKey()).m_135782_()).forEach(biomeID -> core.getCommonReqData((Map<String, Integer>)new HashMap<String, Integer>(), ObjectType.BIOME, (ResourceLocation)biomeID, (ReqType)reqType, new CompoundTag()).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(Component.m_237113_((String)biomeID.toString()))));
                player.f_108617_.m_105151_().stream().map(ResourceKey::m_135782_).forEach(dimID -> core.getCommonReqData((Map<String, Integer>)new HashMap<String, Integer>(), ObjectType.DIMENSION, (ResourceLocation)dimID, (ReqType)reqType, new CompoundTag()).forEach((key, value) -> cache.computeIfAbsent((String)key, s -> new HashMap()).computeIfAbsent(value, v -> new HashMap()).computeIfAbsent(reqType, r -> new ArrayList()).add(Component.m_237113_((String)dimID.toString()))));
            }
        });
    }

    public static void sendLevelUpUnlocks(String skill, int level) {
        if (!((Boolean)Config.SKILLUP_UNLOCKS.get()).booleanValue()) {
            return;
        }
        if (cache.isEmpty()) {
            ClientUtils.cacheUnlocks();
        }
        LocalPlayer player = ClientUtils.mc.f_91074_;
        Map reqMap = ((Map)cache.getOrDefault(skill, new HashMap())).getOrDefault(level, new HashMap());
        boolean isEmpty = reqMap.entrySet().stream().allMatch(entry -> ((List)entry.getValue()).isEmpty());
        if (isEmpty && ((Boolean)Config.SKILLUP_UNLOCKS_STRICT.get()).booleanValue()) {
            return;
        }
        player.m_213846_((Component)(isEmpty ? LangProvider.LEVEL_UP_HEADER.asComponent(level, Component.m_237115_((String)("pmmo." + skill))) : LangProvider.LEVEL_UP_HEADER_WITH_UNLOCKS.asComponent(level, Component.m_237115_((String)("pmmo." + skill)))));
        reqMap.entrySet().stream().filter(entry -> (Boolean)Config.reqEnabled((ReqType)entry.getKey()).get() != false && !((List)entry.getValue()).isEmpty()).forEach(entry -> {
            MutableComponent header = Component.m_237115_((String)("pmmo.enum." + ((ReqType)entry.getKey()).name()));
            header.m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            player.m_213846_((Component)header);
            ((List)entry.getValue()).forEach(arg_0 -> ((LocalPlayer)player).m_213846_(arg_0));
        });
    }
}

