/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.utils;

import harmonised.pmmo.client.utils.ClientUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.features.loot_modifiers.RareDropModifier;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionHighestSkill;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionKill;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionPlayer;
import harmonised.pmmo.features.loot_modifiers.TreasureLootModifier;
import harmonised.pmmo.features.loot_modifiers.ValidBlockCondition;
import harmonised.pmmo.mixin.LootTableConditionMixin;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.fml.LogicalSide;

public class DataMirror
implements IDataStorage {
    private Map<String, Long> mySkills = new HashMap<String, Long>();
    private Map<String, Long> otherSkills = new HashMap<String, Long>();
    private Map<String, Long> scheduledXp = new HashMap<String, Long>();
    private List<Long> levelCache = new ArrayList<Long>();
    public final List<GLM> lootModifiers = new ArrayList<GLM>();

    public boolean me(UUID id) {
        return id == null || id.equals(Minecraft.m_91087_().f_91074_.m_20148_());
    }

    public void setLevelCache(List<Long> cache) {
        this.levelCache = cache;
    }

    public long getScheduledXp(String skill) {
        return this.scheduledXp.getOrDefault(skill, 0L);
    }

    @Override
    public int getLevelFromXP(long xp) {
        for (int i = 0; i < this.levelCache.size(); ++i) {
            if (i == (Integer)Config.MAX_LEVEL.get()) {
                return i;
            }
            if (this.levelCache.get(i) <= xp) continue;
            return Core.get(LogicalSide.CLIENT).getLevelProvider().process("", i);
        }
        return (Integer)Config.MAX_LEVEL.get();
    }

    private int getLevelFromXPwithoutLevelProvider(long xp) {
        for (int i = 0; i < this.levelCache.size(); ++i) {
            if (this.levelCache.get(i) <= xp) continue;
            return i;
        }
        return (Integer)Config.MAX_LEVEL.get();
    }

    public double getXpWithPercentToNextLevel(long rawXP) {
        int currentLevel = this.getLevelFromXPwithoutLevelProvider(rawXP);
        currentLevel = currentLevel >= this.levelCache.size() ? this.levelCache.size() - 1 : currentLevel;
        long currentXPThreshold = currentLevel - 1 >= 0 ? this.levelCache.get(currentLevel - 1) : 0L;
        long xpToNextLevel = this.levelCache.get(currentLevel) - currentXPThreshold;
        long progress = rawXP - currentXPThreshold;
        return (double)Core.get(LogicalSide.CLIENT).getLevelProvider().process("", currentLevel) + (double)progress / (double)xpToNextLevel;
    }

    @Override
    public long getXpRaw(UUID playerID, String skillName) {
        return this.me(playerID) ? this.mySkills.getOrDefault(skillName, 0L) : this.otherSkills.getOrDefault(skillName, 0L);
    }

    @Override
    public void setXpRaw(UUID playerID, String skillName, long value) {
        if (!this.me(playerID)) {
            return;
        }
        long oldValue = this.getXpRaw(playerID, skillName);
        if (value > oldValue) {
            this.scheduledXp.merge(skillName, value - oldValue, Long::sum);
        }
        this.mySkills.put(skillName, value);
        int newLevel = this.getLevelFromXP(value);
        int oldLevel = this.getLevelFromXP(oldValue);
        if (oldLevel < newLevel) {
            ClientUtils.sendLevelUpUnlocks(skillName, newLevel);
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "Client Side Skill Map: " + MsLoggy.mapToString(this.mySkills), new Object[0]);
    }

    @Override
    public Map<String, Long> getXpMap(UUID playerID) {
        return this.me(playerID) ? this.mySkills : this.otherSkills;
    }

    @Override
    public void setXpMap(UUID playerID, Map<String, Long> map) {
        if (this.me(playerID)) {
            this.mySkills = map;
        } else {
            this.otherSkills = map;
        }
    }

    @Override
    public int getPlayerSkillLevel(String skill, UUID player) {
        int rawLevel = this.me(player) ? this.getLevelFromXP(this.mySkills.getOrDefault(skill, 0L)) : this.getLevelFromXP(this.otherSkills.getOrDefault(skill, 0L));
        rawLevel = Core.get(LogicalSide.CLIENT).getLevelProvider().process(skill, rawLevel);
        int skillMax = SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault()).getMaxLevel();
        return Math.min(rawLevel, skillMax);
    }

    @Override
    public IDataStorage get() {
        return this;
    }

    @Override
    public long getBaseXpForLevel(int level) {
        return level > 0 && level - 1 < this.levelCache.size() ? this.levelCache.get(level - 1) : 0L;
    }

    public record GLM(Component header, ItemStack drop, int count, double chance, boolean perLevel, String skill, LootItemCondition[] conditions) {
        public static void add(RareDropModifier modifier) {
            DataMirror data = (DataMirror)Core.get(LogicalSide.CLIENT).getData();
            data.lootModifiers.add(new GLM((Component)LangProvider.GLM_HEADER_RARE.asComponent().m_130940_(ChatFormatting.BOLD), modifier.drop, modifier.drop.m_41613_(), modifier.chance, modifier.perLevel, modifier.skill, modifier.getConditions()));
        }

        public static void add(TreasureLootModifier modifier) {
            DataMirror data = (DataMirror)Core.get(LogicalSide.CLIENT).getData();
            data.lootModifiers.add(new GLM((Component)LangProvider.GLM_HEADER_TREASURE.asComponent().m_130940_(ChatFormatting.BOLD), modifier.drop, modifier.count, modifier.chance, modifier.perLevel, modifier.skill, modifier.getConditions()));
        }

        public List<Component> getGUILines(Core core) {
            ArrayList<Component> linesOut = new ArrayList<Component>();
            linesOut.add(this.header);
            MutableComponent dropText = this.drop.m_150930_(Items.f_41852_) ? Component.m_237113_((String)"itself") : this.drop.m_41611_();
            linesOut.add((Component)LangProvider.GLM_DROP_ITEM.asComponent(this.count, dropText));
            double actualChance = this.chance * (this.perLevel ? (double)core.getData().getPlayerSkillLevel(this.skill, null) : 1.0);
            String actualChanceFormated = String.valueOf(actualChance * 100.0);
            linesOut.add((Component)(this.perLevel ? LangProvider.GLM_DROP_CHANCE_SKILL.asComponent(actualChanceFormated, LangProvider.skill(this.skill)) : LangProvider.GLM_DROP_CHANCE.asComponent(actualChanceFormated)));
            int otherConditions = 0;
            for (LootItemCondition condition : this.conditions) {
                if (condition instanceof LootTableConditionMixin) {
                    LootTableConditionMixin lootCondition = (LootTableConditionMixin)condition;
                    linesOut.add((Component)LangProvider.GLM_LOOT_TABLE.asComponent(lootCondition.getTargetLootTableId().m_135815_()));
                    continue;
                }
                if (condition instanceof SkillLootConditionPlayer) {
                    SkillLootConditionPlayer playerSkillCondition = (SkillLootConditionPlayer)condition;
                    int maxLevel = Math.min(playerSkillCondition.levelMax, SkillsConfig.SKILLS.get().getOrDefault(playerSkillCondition.skill, SkillData.Builder.getDefault()).getMaxLevel());
                    linesOut.add((Component)LangProvider.GLM_SKILL_RANGE.asComponent(LangProvider.skill(playerSkillCondition.skill), playerSkillCondition.levelMin, maxLevel));
                    continue;
                }
                if (condition instanceof SkillLootConditionHighestSkill) {
                    SkillLootConditionHighestSkill highSkillCondition = (SkillLootConditionHighestSkill)condition;
                    String skills = highSkillCondition.comparables.stream().map(str -> LangProvider.skill(str).toString()).collect(Collectors.joining(", "));
                    linesOut.add((Component)LangProvider.GLM_HIGHEST_SKILL.asComponent(LangProvider.skill(highSkillCondition.targetSkill), skills));
                    continue;
                }
                if (condition instanceof SkillLootConditionKill) {
                    SkillLootConditionKill killCondition = (SkillLootConditionKill)condition;
                    int maxLevel = Math.min(killCondition.levelMax, SkillsConfig.SKILLS.get().getOrDefault(killCondition.skill, SkillData.Builder.getDefault()).getMaxLevel());
                    linesOut.add((Component)LangProvider.GLM_SKILL_RANGE.asComponent(LangProvider.skill(killCondition.skill), killCondition.levelMin, maxLevel));
                    continue;
                }
                if (condition instanceof ValidBlockCondition) {
                    ValidBlockCondition blockCondition = (ValidBlockCondition)condition;
                    MutableComponent target = blockCondition.tag == null ? blockCondition.block.m_49954_() : Component.m_237113_((String)blockCondition.tag.f_203868_().toString());
                    linesOut.add((Component)LangProvider.GLM_VALID_BLOCK.asComponent(target));
                    continue;
                }
                ++otherConditions;
            }
            if (otherConditions > 0) {
                linesOut.add((Component)LangProvider.GLM_OTHER_CONDITIONS.asComponent(otherConditions));
            }
            return linesOut;
        }
    }
}

