/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.compat.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import harmonised.pmmo.compat.ftb_quests.FTBQHandler;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XpReward
extends Reward {
    public static RewardType XP_REWARD = FTBQHandler.XP_REWARD;
    public String skill = "mining";
    public long amount = 83L;
    public boolean ignoreBonuses = false;

    public XpReward(long id, Quest quest) {
        super(id, quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return XP_REWARD;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("skill", this.skill);
        nbt.m_128356_("amount", this.amount);
        nbt.m_128379_("ignoreBonuses", this.ignoreBonuses);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.skill = nbt.m_128461_("skill");
        this.amount = nbt.m_128454_("amount");
        this.ignoreBonuses = nbt.m_128471_("ignoreBonuses");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130070_(this.skill);
        buffer.writeLong(this.amount);
        buffer.writeBoolean(this.ignoreBonuses);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.skill = buffer.m_130277_();
        this.amount = buffer.readLong();
        this.ignoreBonuses = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)"mining", (Object[])SkillsConfig.SKILLS.get().keySet().toArray()).create());
        config.addLong("amount", this.amount, input -> {
            this.amount = input;
        }, 1L, Long.MIN_VALUE, Long.MAX_VALUE);
        config.addBool("ignoreBonuses", this.ignoreBonuses, v -> {
            this.ignoreBonuses = v;
        }, false).setNameKey("pmmo.ignoreBonuses");
    }

    public void claim(ServerPlayer player, boolean notify) {
        Core.get(player.m_9236_()).getData().setXpDiff(player.m_20148_(), this.skill, this.amount);
    }

    public Component getAltTitle() {
        return LangProvider.FTBQ_XP_TITLE.asComponent(this.amount, LangProvider.skill(this.skill));
    }
}

