/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.CodecTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public record SkillData(Optional<Integer> color, Optional<Boolean> afkExempt, Optional<Boolean> displayGroupName, Optional<Boolean> showInList, Optional<Boolean> useTotalLevels, Optional<Map<String, Double>> groupedSkills, Optional<Integer> maxLevel, Optional<ResourceLocation> icon, Optional<Integer> iconSize) {
    public static Codec<SkillData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("color").forGetter(SkillData::color), (App)Codec.BOOL.optionalFieldOf("noAfkPenalty").forGetter(SkillData::afkExempt), (App)Codec.BOOL.optionalFieldOf("displayGroupName").forGetter(SkillData::displayGroupName), (App)Codec.BOOL.optionalFieldOf("showInList").forGetter(SkillData::showInList), (App)Codec.BOOL.optionalFieldOf("useTotalLevels").forGetter(SkillData::useTotalLevels), (App)CodecTypes.DOUBLE_CODEC.optionalFieldOf("groupFor").forGetter(SkillData::groupedSkills), (App)Codec.INT.optionalFieldOf("maxLevel").forGetter(SkillData::maxLevel), (App)ResourceLocation.f_135803_.optionalFieldOf("icon").forGetter(SkillData::icon), (App)Codec.INT.optionalFieldOf("iconSize").forGetter(SkillData::iconSize)).apply((Applicative)instance, SkillData::new));

    public int getColor() {
        return this.color.orElse(0xFFFFFF);
    }

    public boolean getAfkExempt() {
        return this.afkExempt.orElse(false);
    }

    public boolean getDisplayGroupName() {
        return this.displayGroupName.orElse(false);
    }

    public boolean getShowInList() {
        return this.showInList.orElse(true);
    }

    public boolean getUseTotalLevels() {
        return this.useTotalLevels.orElse(false);
    }

    public int getMaxLevel() {
        return this.maxLevel.orElse((Integer)Config.MAX_LEVEL.get());
    }

    public ResourceLocation getIcon() {
        return this.icon.orElse(new ResourceLocation("pmmo", "textures/skills/missing_icon.png"));
    }

    public int getIconSize() {
        return this.iconSize.orElse(18);
    }

    public boolean isSkillGroup() {
        return !this.getGroup().isEmpty();
    }

    public Map<String, Double> getGroup() {
        return this.groupedSkills.orElse(new HashMap());
    }

    public Map<String, Long> getGroupXP(long xp) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double denominator = this.getGroup().values().stream().mapToDouble(value -> value).sum();
        this.getGroup().forEach((skill, ratio) -> outMap.put((String)skill, Double.valueOf(ratio / denominator * (double)xp).longValue()));
        new HashMap<String, Long>(outMap).forEach((skill, value) -> {
            SkillData skillCheck = SkillsConfig.SKILLS.get().getOrDefault(skill, Builder.getDefault());
            if (skillCheck.isSkillGroup()) {
                outMap.remove(skill);
                skillCheck.getGroupXP((long)value).forEach((s, x) -> outMap.merge((String)s, (Long)x, Long::sum));
            }
        });
        return outMap;
    }

    public Map<String, Integer> getGroupReq(int level) {
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        double denominator = this.getGroup().values().stream().mapToDouble(value -> value).sum();
        this.getGroup().forEach((skill, ratio) -> outMap.put((String)skill, (int)(ratio / denominator * (double)level)));
        new HashMap<String, Integer>(outMap).forEach((skill, value) -> {
            SkillData skillCheck = SkillsConfig.SKILLS.get().getOrDefault(skill, Builder.getDefault());
            if (skillCheck.isSkillGroup()) {
                outMap.remove(skill);
                skillCheck.getGroupReq((int)value).forEach((s, x) -> outMap.merge((String)s, (Integer)x, Integer::sum));
            }
        });
        return outMap;
    }

    public Map<String, Double> getGroupBonus(double bonus) {
        HashMap<String, Double> outMap = new HashMap<String, Double>();
        double denominator = this.getGroup().values().stream().mapToDouble(value -> value).sum();
        double gainLossModifier = bonus >= 1.0 ? 1.0 : 0.0;
        this.getGroup().forEach((skill, ratio) -> outMap.put((String)skill, gainLossModifier + ratio / denominator * bonus));
        new HashMap<String, Double>(outMap).forEach((skill, value) -> {
            SkillData skillCheck = SkillsConfig.SKILLS.get().getOrDefault(skill, Builder.getDefault());
            if (skillCheck.isSkillGroup()) {
                outMap.remove(skill);
                skillCheck.getGroupBonus((double)value).forEach((s, x) -> outMap.merge((String)s, (Double)x, Double::sum));
            }
        });
        return outMap;
    }

    public static class Builder {
        int color = 0xFFFFFF;
        int maxLevel = Integer.MAX_VALUE;
        int iconSize = 18;
        boolean afkExempt = false;
        boolean displayName = false;
        boolean useTotal = false;
        boolean showInList = true;
        ResourceLocation icon = new ResourceLocation("pmmo", "textures/skills/missing_icon.png");
        Map<String, Double> groupOf = new HashMap<String, Double>();

        private Builder() {
        }

        public static SkillData getDefault() {
            return new SkillData(Optional.of(0xFFFFFF), Optional.of(false), Optional.of(false), Optional.of(true), Optional.of(false), Optional.empty(), Optional.of((Integer)Config.MAX_LEVEL.get()), Optional.of(new ResourceLocation("pmmo", "textures/skills/missing_icon.png")), Optional.of(18));
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder withColor(int color) {
            this.color = color;
            return this;
        }

        public Builder withIcon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder withIconSize(int size) {
            this.iconSize = size;
            return this;
        }

        public Builder withMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder withAfkExempt(boolean afkExempt) {
            this.afkExempt = afkExempt;
            return this;
        }

        public Builder withDisplayName(boolean displayGroupName) {
            this.displayName = displayGroupName;
            return this;
        }

        public Builder withUseTotal(boolean useTotalLevels) {
            this.useTotal = useTotalLevels;
            return this;
        }

        public Builder omitFromList() {
            this.showInList = false;
            return this;
        }

        public Builder setGroupOf(Map<String, Double> group) {
            this.groupOf = group;
            return this;
        }

        public SkillData build() {
            return new SkillData(Optional.of(this.color), Optional.of(this.afkExempt), Optional.of(this.displayName), Optional.of(this.showInList), Optional.of(this.useTotal), this.groupOf.isEmpty() ? Optional.empty() : Optional.of(this.groupOf), Optional.of(this.maxLevel), Optional.of(this.icon), Optional.of(this.iconSize));
        }
    }
}

