/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.scripting;

import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.config.scripting.Functions;
import harmonised.pmmo.config.scripting.NodeConsumer;
import harmonised.pmmo.config.scripting.TargetSelector;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public record Expression(ObjectType targetType, ResourceLocation targetID, Map<String, String> value, List<Node> features) {
    public static List<Expression> create(RegistryAccess access, String str) {
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, "Raw Script Line: {}", str);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        String[] nodes = str.replace(";", "").split("\\)\\.");
        ArrayList<Node> features = new ArrayList<Node>();
        HashMap<String, String> values = new HashMap<String, String>();
        List<Object> targetIDs = new ArrayList();
        ObjectType targetType = null;
        for (String node : nodes) {
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, "NODE: {}", node);
            String keyword = node.substring(0, node.indexOf(40));
            String param = node.substring(node.indexOf(40) + 1).replaceAll("[ )]", "");
            if (ObjectType.byName(keyword.toUpperCase()) != null) {
                targetType = ObjectType.byName(keyword.toUpperCase());
                targetIDs = Expression.parseIDs(param, targetType, access);
                continue;
            }
            if (Functions.TARGETORS.containsKey(keyword)) {
                TargetSelector.Selection selection = Functions.TARGETORS.get(keyword).read(param, access);
                targetType = selection.type();
                targetIDs = selection.IDs();
                continue;
            }
            if (Functions.KEYWORDS.containsKey(keyword)) {
                features.add(new Node(param, Functions.KEYWORDS.get(keyword)));
                continue;
            }
            values.put(keyword, param);
        }
        for (ResourceLocation id : targetIDs) {
            expressions.add(new Expression(targetType, id, values, features));
        }
        expressions.forEach(expr -> MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, "Expressions: {}", expr));
        return expressions;
    }

    public boolean isValid() {
        return this.targetType != null && this.targetID != null;
    }

    public void commit() {
        this.features.forEach(c -> c.consumer().consume(c.param(), this.targetID, this.targetType, this.value));
    }

    public static List<ResourceLocation> parseIDs(String raw, ObjectType type, RegistryAccess access) {
        String[] rawSplit;
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (String str : rawSplit = raw.split(",")) {
            if (str.startsWith("#")) {
                ResourceLocation tagID = new ResourceLocation(str.substring(1));
                ids.addAll(Expression.getMembers(true, tagID, access, type));
                continue;
            }
            if (str.endsWith(":*")) {
                ResourceLocation namespace = new ResourceLocation(str.replace("*", "wildcard"));
                ids.addAll(Expression.getMembers(false, namespace, access, type));
                continue;
            }
            ids.add(new ResourceLocation(str));
        }
        return ids;
    }

    private static List<ResourceLocation> getMembers(boolean isTag, ResourceLocation tagID, RegistryAccess access, ObjectType type) {
        return switch (type) {
            case ObjectType.ITEM -> Expression.readRegistry(isTag, access, Registries.f_256913_, tagID);
            case ObjectType.BLOCK -> Expression.readRegistry(isTag, access, Registries.f_256747_, tagID);
            case ObjectType.ENTITY -> Expression.readRegistry(isTag, access, Registries.f_256939_, tagID);
            case ObjectType.BIOME -> Expression.readRegistry(isTag, access, Registries.f_256952_, tagID);
            case ObjectType.ENCHANTMENT -> Expression.readRegistry(isTag, access, Registries.f_256762_, tagID);
            default -> List.of();
        };
    }

    private static <T> List<ResourceLocation> readRegistry(boolean forTags, RegistryAccess access, ResourceKey<Registry<T>> registry, ResourceLocation tagID) {
        Registry reg = access.m_175515_(registry);
        return forTags ? reg.m_203431_(TagKey.m_203882_(registry, (ResourceLocation)tagID)).map(named -> named.m_203614_().map(holder -> ((ResourceKey)holder.m_203543_().get()).m_135782_()).toList()).orElse(List.of()) : reg.m_6566_().stream().filter(id -> id.m_135827_().equals(tagID.m_135827_())).toList();
    }

    public record Node(String param, NodeConsumer consumer) {
        @Override
        public String toString() {
            return this.param;
        }
    }
}

