/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.scripting;

import harmonised.pmmo.config.scripting.Expression;
import harmonised.pmmo.util.MsLoggy;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraftforge.fml.loading.FMLPaths;

public class Scripting {
    public static void readFiles(RegistryAccess access) {
        Path filePath = FMLPaths.CONFIGDIR.get();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(filePath, "*.pmmo");){
            for (Path path : stream) {
                MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Loading script from {}", path);
                Scripting.read(access, new String(Files.readAllBytes(path)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void read(RegistryAccess access, String rawString) {
        Scripting.read(access, rawString.lines().filter(str -> !str.startsWith("//")).toList());
    }

    public static void read(RegistryAccess access, List<String> lines) {
        String currentNode = "";
        StringBuilder multiLine = new StringBuilder();
        ArrayList<Expression> builders = new ArrayList<Expression>();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String str;
            int eolci = (str = iterator.next()).indexOf("//");
            String strippedOfComments = str.substring(0, eolci == -1 ? Math.max(0, str.length()) : eolci);
            String trimmed = strippedOfComments.replaceAll("^[ \\t]+", "").replaceAll("[ \\t]+$", "");
            if (trimmed.isEmpty()) continue;
            if (trimmed.startsWith("WITH")) {
                currentNode = trimmed.replaceAll("^WITH ?", "");
                multiLine = new StringBuilder();
                continue;
            }
            if (trimmed.startsWith("END")) {
                currentNode = "";
                multiLine = new StringBuilder();
                continue;
            }
            if (!trimmed.endsWith(";")) {
                multiLine.append(trimmed);
                continue;
            }
            List<Expression> exprs = Expression.create(access, currentNode + String.valueOf(multiLine) + trimmed).stream().filter(Expression::isValid).toList();
            multiLine = new StringBuilder();
            builders.addAll(exprs);
        }
        builders.forEach(Expression::commit);
    }
}

