/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.registries.ForgeRegistries;

public class AutoEntity {
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.BREED, EventType.DEATH, EventType.ENTITY, EventType.RIDING, EventType.SHIELD_BLOCK, EventType.TAMING};

    public static Map<String, Integer> processReqs(ReqType type, ResourceLocation entityID) {
        return new HashMap<String, Integer>();
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation entityID) {
        if (!type.entityApplicable || !AutoValueConfig.isXpGainEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityID);
        switch (type) {
            case RIDING: {
                if (!entityType.m_204039_(Reference.RIDEABLE_TAG)) break;
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
            case DEATH: 
            case ENTITY: 
            case SHIELD_BLOCK: {
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
            case BREED: {
                if (!entityType.m_204039_(Reference.BREEDABLE_TAG)) break;
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
            case TAMING: {
                if (!entityType.m_204039_(Reference.TAMABLE_TAG)) break;
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
        }
        return outMap;
    }

    private static Map<String, Long> getXpMap(ResourceLocation entityID, EventType type) {
        EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityID);
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double healthScale = AutoEntity.getAttribute((EntityType<? extends LivingEntity>)entity, Attributes.f_22276_) * AutoValueConfig.ENTITY_ATTRIBUTES.get().getOrDefault(AutoValueConfig.AttributeKey.HEALTH.key, 0.0);
        double speedScale = AutoEntity.getAttribute((EntityType<? extends LivingEntity>)entity, Attributes.f_22279_) * AutoValueConfig.ENTITY_ATTRIBUTES.get().getOrDefault(AutoValueConfig.AttributeKey.SPEED.key, 0.0);
        double damageScale = AutoEntity.getAttribute((EntityType<? extends LivingEntity>)entity, Attributes.f_22281_) * AutoValueConfig.ENTITY_ATTRIBUTES.get().getOrDefault(AutoValueConfig.AttributeKey.DMG.key, 0.0);
        double scale = healthScale + speedScale + damageScale;
        AutoValueConfig.getEntityXpAward(type).forEach((skill, value) -> outMap.put((String)skill, Double.valueOf((double)value.longValue() * scale).longValue()));
        return outMap;
    }

    private static double getAttribute(EntityType<? extends LivingEntity> entity, Attribute attribute) {
        if (!DefaultAttributes.m_22301_(entity)) {
            return 0.0;
        }
        AttributeSupplier attSup = DefaultAttributes.m_22297_(entity);
        if (attSup == null) {
            return 0.0;
        }
        return attSup.m_22258_(attribute) ? attSup.m_22253_(attribute) : 0.0;
    }
}

