/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.loot_modifiers.GLMRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SkillLootConditionHighestSkill
implements LootItemCondition {
    public String targetSkill;
    public List<String> comparables;

    public SkillLootConditionHighestSkill(String skill, List<String> comparables) {
        this.targetSkill = skill;
        this.comparables = comparables;
    }

    public boolean test(LootContext t) {
        Entity player = (Entity)t.m_78953_(LootContextParams.f_81455_);
        if (player == null || this.targetSkill == null || this.comparables.isEmpty()) {
            return false;
        }
        int targetLevel = Core.get(player.m_9236_()).getData().getPlayerSkillLevel(this.targetSkill, player.m_20148_());
        for (String comparable : this.comparables) {
            if (comparable.equals(this.targetSkill) || targetLevel >= Core.get(player.m_9236_()).getData().getPlayerSkillLevel(comparable, player.m_20148_())) continue;
            return false;
        }
        return true;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)GLMRegistry.HIGHEST_SKILL.get();
    }

    public static final class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<SkillLootConditionHighestSkill> {
        public void serialize(JsonObject json, SkillLootConditionHighestSkill itemCondition, @Nonnull JsonSerializationContext context) {
            json.addProperty("target_skill", itemCondition.targetSkill);
            JsonArray list = new JsonArray();
            for (String skill : itemCondition.comparables) {
                list.add(skill);
            }
            json.add("comparable_skills", (JsonElement)list);
        }

        @Nonnull
        public SkillLootConditionHighestSkill deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            String targetSkill = GsonHelper.m_13906_((JsonObject)json, (String)"target_skill");
            JsonArray list = GsonHelper.m_13933_((JsonObject)json, (String)"comparable_skills");
            ArrayList<String> comparables = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                comparables.add(list.get(i).getAsString());
            }
            return new SkillLootConditionHighestSkill(targetSkill, comparables);
        }
    }
}

