/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TreasureLootModifier
extends LootModifier {
    public static final Codec<TreasureLootModifier> CODEC = RecordCodecBuilder.create(instance -> TreasureLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ResourceLocation.f_135803_.fieldOf("item").forGetter(tlm -> RegistryUtil.getId(tlm.drop)), (App)Codec.INT.fieldOf("count").forGetter(tlm -> tlm.count), (App)Codec.DOUBLE.fieldOf("chance").forGetter(tlm -> tlm.chance), (App)Codec.BOOL.optionalFieldOf("per_level").forGetter(tlm -> Optional.of(tlm.perLevel)), (App)Codec.STRING.optionalFieldOf("skill").forGetter(tlm -> Optional.of(tlm.skill)))).apply((Applicative)instance, TreasureLootModifier::new));
    public ItemStack drop;
    public final int count;
    public double chance;
    public boolean perLevel;
    public String skill;

    public TreasureLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance) {
        this(conditionsIn, lootItemID, count, chance, Optional.of(false), Optional.empty());
    }

    public TreasureLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance, Optional<Boolean> perLevel, Optional<String> skill) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = lootItemID.equals((Object)new ResourceLocation("air")) ? Items.f_41852_.m_7968_() : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(lootItemID));
        this.drop.m_41764_(count);
        this.count = count;
        this.perLevel = perLevel.orElse(false);
        this.skill = skill.orElse("");
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object;
        if (!((Boolean)Config.TREASURE_ENABLED.get()).booleanValue()) {
            return generatedLoot;
        }
        if (this.perLevel && (object = context.m_165124_(LootContextParams.f_81455_)) instanceof Player) {
            Player player = (Player)object;
            this.chance *= (double)Core.get(player.m_9236_()).getData().getPlayerSkillLevel(this.skill, player.m_20148_());
        }
        if (context.m_230907_().m_188500_() <= this.chance) {
            Entity breaker;
            BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            if (state != null && this.drop.m_41720_() == Items.f_41852_) {
                this.drop = (ItemStack)state.m_287290_(this.builderFromContext(context)).get(0);
                this.drop.m_41764_(this.count);
            }
            if ((breaker = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof Player) {
                Player player = (Player)breaker;
                player.m_213846_((Component)LangProvider.FOUND_TREASURE.asComponent());
            }
            generatedLoot.add((Object)this.drop.m_41777_());
        }
        return generatedLoot;
    }

    private LootParams.Builder builderFromContext(LootContext context) {
        return new LootParams.Builder(context.m_78952_()).m_287286_(LootContextParams.f_81460_, (Object)((Vec3)context.m_165124_(LootContextParams.f_81460_))).m_287286_(LootContextParams.f_81463_, (Object)((ItemStack)context.m_165124_(LootContextParams.f_81463_)));
    }
}

