/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.party;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class PartyUtils {
    private static final Map<UUID, Invite> invites = new HashMap<UUID, Invite>();

    public static List<ServerPlayer> getPartyMembersInRange(ServerPlayer player) {
        ArrayList<ServerPlayer> inRange = new ArrayList<ServerPlayer>();
        for (ServerPlayer member : PartyUtils.getPartyMembers(player)) {
            if ((Integer)Config.PARTY_RANGE.get() != -2 && ((Integer)Config.PARTY_RANGE.get() != -1 || !player.m_9236_().equals(member.m_9236_())) && !(player.m_20182_().m_82554_(member.m_20182_()) <= (double)((Integer)Config.PARTY_RANGE.get()).intValue())) continue;
            inRange.add(member);
        }
        return inRange;
    }

    public static List<ServerPlayer> getPartyMembers(ServerPlayer player) {
        if (player.m_5647_() == null) {
            return List.of(player);
        }
        return player.m_5647_().m_6809_().stream().map(str -> player.m_20194_().m_6846_().m_11255_(str)).filter(Objects::nonNull).toList();
    }

    public static void inviteToParty(ServerPlayer member, Player invitee) {
        UUID requestID = UUID.randomUUID();
        Style acceptStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pmmo party accept " + requestID.toString())).m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true));
        MutableComponent accept = LangProvider.PARTY_ACCEPT.asComponent().m_130948_(acceptStyle);
        Style declineStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pmmo party decline " + requestID.toString())).m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED).m_131162_(Boolean.valueOf(true));
        MutableComponent decline = LangProvider.PARTY_DECLINE_INVITE.asComponent().m_130948_(declineStyle);
        invitee.m_213846_((Component)LangProvider.PARTY_PLAYER_INVITED.asComponent(member.m_5446_(), accept, decline));
        invites.put(requestID, new Invite((PlayerTeam)member.m_5647_(), invitee.m_20148_()));
    }

    public static void uninviteToParty(ServerPlayer member, Player invitee) {
        Team memberParty = member.m_5647_();
        if (memberParty == null) {
            member.m_213846_((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return;
        }
        List<UUID> inviteToRemove = invites.entrySet().stream().filter(entry -> ((Invite)entry.getValue()).team() == memberParty && ((Invite)entry.getValue()).player().equals(invitee.m_20148_())).map(Map.Entry::getKey).toList();
        inviteToRemove.forEach(invites::remove);
        member.m_213846_((Component)LangProvider.PARTY_RESCIND_INVITE.asComponent(invitee.m_5446_()));
    }

    public static void acceptInvite(ServerPlayer invitee, UUID requestID) {
        Invite invite;
        if (invites.get(requestID) == null) {
            invitee.m_213846_((Component)LangProvider.PARTY_NO_INVITES.asComponent());
        }
        if (!(invite = invites.get(requestID)).player().equals(invitee.m_20148_())) {
            return;
        }
        invitee.m_36329_().m_6546_(invitee.m_6302_(), invite.team());
        invites.remove(requestID);
        invitee.m_213846_((Component)LangProvider.PARTY_JOINED.asComponent());
    }

    public static boolean declineInvite(UUID requestID) {
        return invites.remove(requestID) != null;
    }

    public static boolean isInParty(ServerPlayer player) {
        return MsLoggy.DEBUG.logAndReturn(player.m_5647_() != null, MsLoggy.LOG_CODE.FEATURE, "Is In Party: {}", new Object[0]);
    }

    private record Invite(PlayerTeam team, UUID player) {
    }
}

