/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryUtil {
    public static ResourceLocation getId(ItemStack stack) {
        return RegistryUtil.getId(stack.m_41720_());
    }

    public static ResourceLocation getId(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getId(BlockState blockState) {
        return RegistryUtil.getId(blockState.m_60734_());
    }

    public static ResourceLocation getId(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getId(Holder<Biome> biome) {
        return ((ResourceKey)biome.m_203543_().get()).m_135782_();
    }

    public static ResourceLocation getId(SoundEvent sound) {
        return ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
    }

    public static ResourceLocation getId(Entity entity) {
        return RegistryUtil.getId(entity.m_6095_());
    }

    public static ResourceLocation getId(EntityType<?> entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entity);
    }

    public static ResourceLocation getId(Enchantment enchant) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
    }

    public static ResourceLocation getId(MobEffect effect) {
        return ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
    }

    public static ResourceLocation getId(DamageSource source) {
        return ((ResourceKey)source.m_269150_().m_203543_().get()).m_135782_();
    }

    public static <T> boolean isInTag(RegistryAccess access, ResourceKey<Registry<T>> registry, String objectID, String tagId) {
        return RegistryUtil.isInTag(access, registry, new ResourceLocation(objectID), tagId);
    }

    public static <T> boolean isInTag(RegistryAccess access, ResourceKey<Registry<T>> registry, ResourceLocation objectID, String tagId) {
        Registry reg = access.m_175515_(registry);
        TagKey tag = TagKey.m_203882_(registry, (ResourceLocation)new ResourceLocation(tagId));
        Optional holder = reg.m_203636_(ResourceKey.m_135785_(registry, (ResourceLocation)objectID));
        return holder.map(h -> h.m_203656_(tag)).orElse(false);
    }
}

