/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TagUtils {
    public static CompoundTag mergeTags(CompoundTag tag1, CompoundTag tag2) {
        CompoundTag output = new CompoundTag();
        ArrayList<String> allKeys = new ArrayList<String>();
        tag1.m_128431_().forEach(s -> allKeys.add((String)s));
        for (String key : tag2.m_128431_()) {
            if (allKeys.contains(key) || key == null) continue;
            allKeys.add(key);
        }
        for (String key : allKeys) {
            if (tag1.m_128441_(key) && tag2.m_128441_(key)) {
                Tag tag = tag1.m_128423_(key);
                if (tag instanceof NumericTag) {
                    NumericTag numTag = (NumericTag)tag;
                    if (numTag instanceof DoubleTag) {
                        output.m_128347_(key, tag1.m_128459_(key) + tag2.m_128459_(key));
                        continue;
                    }
                    if (numTag instanceof FloatTag) {
                        output.m_128350_(key, tag1.m_128457_(key) + tag2.m_128457_(key));
                        continue;
                    }
                    if (numTag instanceof IntTag) {
                        output.m_128405_(key, tag1.m_128451_(key) + tag2.m_128451_(key));
                        continue;
                    }
                    if (numTag instanceof LongTag) {
                        output.m_128356_(key, tag1.m_128454_(key) + tag2.m_128454_(key));
                        continue;
                    }
                    if (numTag instanceof ShortTag) {
                        output.m_128376_(key, (short)(tag1.m_128448_(key) + tag2.m_128448_(key)));
                        continue;
                    }
                    output.m_128365_(key, tag1.m_128423_(key));
                    continue;
                }
                output.m_128365_(key, tag1.m_128423_(key));
                continue;
            }
            if (tag1.m_128441_(key) && !tag2.m_128441_(key)) {
                output.m_128365_(key, tag1.m_128423_(key));
                continue;
            }
            if (tag1.m_128441_(key) || !tag2.m_128441_(key)) continue;
            output.m_128365_(key, tag2.m_128423_(key));
        }
        return output;
    }

    public static CompoundTag stackTag(ItemStack stack) {
        return stack == null || stack.m_41783_() == null ? new CompoundTag() : stack.m_41783_();
    }

    public static CompoundTag entityTag(Entity entity) {
        CompoundTag data = new CompoundTag();
        return entity == null ? data : entity.m_20240_(data);
    }

    public static CompoundTag tileTag(BlockEntity tile) {
        return tile == null ? new CompoundTag() : tile.m_187480_();
    }

    public static CompoundTag stateTag(BlockState state) {
        CompoundTag dataOut = new CompoundTag();
        state.m_61147_().forEach(prop -> dataOut.m_128359_(prop.m_61708_(), state.m_61143_(prop).toString()));
        return dataOut;
    }

    public static float getFloat(CompoundTag nbt, String key, float ifAbsent) {
        return nbt.m_128441_(key) ? nbt.m_128457_(key) : ifAbsent;
    }

    public static BlockPos getBlockPos(CompoundTag nbt, String key, BlockPos ifAbsent) {
        return nbt.m_128441_(key) ? BlockPos.m_122022_((long)nbt.m_128454_(key)) : ifAbsent;
    }
}

