/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import team.recrafted.blastfromthepast.client.models.block.AntlerDisplayBlockModel;
import team.recrafted.blastfromthepast.client.models.boats.BFTPBoatModel;
import team.recrafted.blastfromthepast.client.models.boats.BFTPChestBoatModel;
import team.recrafted.blastfromthepast.client.renderers.block.BearTrapRenderer;
import team.recrafted.blastfromthepast.client.renderers.boat.BFTPBoatRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.BurrelRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.FrostomperRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.GlacerosRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.HollowRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.PsychoBearRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.SapRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.SnowdoRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.SpeartoothRenderer;
import team.recrafted.blastfromthepast.client.renderers.projectile.TarArrowRenderer;
import team.recrafted.blastfromthepast.client.renderers.projectile.ThrownIceSpearRenderer;
import team.recrafted.blastfromthepast.entity.boats.BFTPBoat;
import team.recrafted.blastfromthepast.entity.pack.EntityPacks;
import team.recrafted.blastfromthepast.events.CuriosCompat;
import team.recrafted.blastfromthepast.init.ModArmorMaterials;
import team.recrafted.blastfromthepast.init.ModBlockEntities;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModDecoratedPatterns;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModFeatures;
import team.recrafted.blastfromthepast.init.ModFoliageTypes;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModMobEffects;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.init.ModStructureProcessors;
import team.recrafted.blastfromthepast.init.ModTabs;

@Mod(value="blastfromthepast")
public class BlastFromThePast {
    public static final String MODID = "blastfromthepast";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean CURIOS_LOADED = ModList.get().isLoaded("curios");

    public BlastFromThePast(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModEntities.ENTITIES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModTabs.CREATIVE_TABS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModDecoratedPatterns.PATTERNS.register(modEventBus);
        ModArmorMaterials.ARMOR_MATERIAL.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModDataSerializers.DATA_SERIALIZERS.register(modEventBus);
        ModFoliageTypes.FOLIAGE_PLACER_TYPES.register(modEventBus);
        ModMobEffects.MOB_EFFECTS.register(modEventBus);
        ModStructureProcessors.STRUCTURE_PROCESSORS.register(modEventBus);
        if (CURIOS_LOADED) {
            NeoForge.EVENT_BUS.register(CuriosCompat.class);
        }
    }

    public static EntityPacks getEntityPacks(ServerLevel level) {
        return (EntityPacks)level.getDataStorage().computeIfAbsent(EntityPacks.factory(level), EntityPacks.getFileId());
    }

    public static EntityPacks getUniversalEntityPacks(MinecraftServer server) {
        return BlastFromThePast.getEntityPacks(server.overworld());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onServerTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getLevel().dimension().equals(Level.OVERWORLD) && serverLevel.tickRateManager().runsNormally()) {
                BlastFromThePast.getEntityPacks(serverLevel).tick();
            }
        }
    }

    public static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    @EventBusSubscriber(modid="blastfromthepast", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                EntityRenderers.register((EntityType)((EntityType)ModEntities.GLACEROS.get()), GlacerosRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.SNOWDO.get()), SnowdoRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.FROSTOMPER.get()), FrostomperRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.PSYCHO_BEAR.get()), PsychoBearRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.SPEARTOOTH.get()), SpeartoothRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.BURREL.get()), BurrelRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.HOLLOW.get()), HollowRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.TAR_ARROW.get()), TarArrowRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.SAP.get()), SapRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.BFTPBOAT.get()), pContext -> new BFTPBoatRenderer(pContext, false));
                EntityRenderers.register((EntityType)((EntityType)ModEntities.BFTPCHEST_BOAT.get()), pContext -> new BFTPBoatRenderer(pContext, true));
                EntityRenderers.register((EntityType)((EntityType)ModEntities.ICE_SPEAR.get()), ThrownIceSpearRenderer::new);
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntities.BEAR_TRAP.get()), BearTrapRenderer::new);
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntities.SIGN.get()), SignRenderer::new);
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HANGING_SIGN.get()), HangingSignRenderer::new);
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntities.ANTLER_DISPLAY.get()), context -> new GeoBlockRenderer((GeoModel)new AntlerDisplayBlockModel()));
                ItemProperties.register((Item)((Item)ModItems.ICE_SPEAR.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BlastFromThePast.MODID, (String)"throwing"), (stack, level, living, j) -> living != null && living.isUsingItem() && living.getUseItem() == stack ? 1.0f : 0.0f);
            });
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (BFTPBoat.BoatType boat$type : BFTPBoat.BoatType.values()) {
                event.registerLayerDefinition(BFTPBoatRenderer.createBoatModelName(boat$type), BFTPBoatModel::createBodyModel);
                event.registerLayerDefinition(BFTPBoatRenderer.createChestBoatModelName(boat$type), BFTPChestBoatModel::createBodyModel);
            }
        }
    }
}

