/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.util.ShapeUtils;

public class BeastChopsBlock
extends RotatedPillarBlock {
    public static final IntegerProperty STATES = IntegerProperty.create((String)"states", (int)0, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape FULL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape FIRST = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)});
    private static final VoxelShape SECOND = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)});
    private static final VoxelShape THIRD = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static VoxelShape FOURTH = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static int levelModifier = 2;
    protected static float saturationmodifier = 0.1f;

    public BeastChopsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)STATES, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BeastChopsBlock setLevelAndSaturation(int pLevelModifier, float pSaturationModifier) {
        levelModifier = pLevelModifier;
        saturationmodifier = pSaturationModifier;
        return this;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape = this.getVoxelShapeForState((Integer)state.getValue((Property)STATES));
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return ShapeUtils.rotateShape(baseShape, axis, facing);
    }

    private VoxelShape getVoxelShapeForState(int state) {
        switch (state) {
            case 1: {
                return FIRST;
            }
            case 2: {
                return SECOND;
            }
            case 3: {
                return THIRD;
            }
            case 4: {
                return FOURTH;
            }
        }
        return FULL;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        if ((Integer)state.getValue((Property)STATES) == 0) {
            return super.getDrops(state, params);
        }
        return Collections.emptyList();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)STATES) == 4) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            if (BeastChopsBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return BeastChopsBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() == ModItems.SAP_BALL.get()) {
            if (this != ModBlocks.BEAST_CHOPS_COOKED.get() || (Integer)state.getValue((Property)STATES) == 4) {
                return ItemInteractionResult.FAIL;
            }
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.BEAST_CHOPS_GLAZED.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)))).setValue((Property)STATES, (Comparable)((Integer)state.getValue((Property)STATES))), 3);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected static InteractionResult eat(LevelAccessor pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pPlayer.canEat(false)) {
            return InteractionResult.PASS;
        }
        pPlayer.getFoodData().eat(levelModifier, saturationmodifier);
        int i = (Integer)pState.getValue((Property)STATES);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.EAT, pPos);
        if (i < 5) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)STATES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            pLevel.removeBlock(pPos, false);
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_DESTROY, pPos);
        }
        pPlayer.playSound(SoundEvents.GENERIC_EAT, 1.0f, Mth.randomBetween((RandomSource)pLevel.getRandom(), (float)0.8f, (float)1.2f));
        return InteractionResult.SUCCESS;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STATES, FACING, AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getClickedFace().getAxis() == Direction.Axis.X ? context.getClickedFace().getOpposite() : context.getClickedFace()))).setValue((Property)AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

