/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.recrafted.blastfromthepast.util.EntityHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TarBlock
extends Block {
    public static FogType FOG_TYPE;
    public static final MapCodec<TarBlock> CODEC;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.25f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 0.1f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE;
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;
    private static final float DROWNING_DAMAGE = 2.0f;
    public static final BooleanProperty COVER;

    public TarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)COVER, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is((Block)this) && state.getValue((Property)COVER) == adjacentState.getValue((Property)COVER) || super.skipRendering(state, adjacentState, direction);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected void entityInside(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (entity.getInBlockState().is((Block)this)) {
            entity.makeStuckInBlock(state, new Vec3(0.25, (double)0.1f, 0.25));
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            if (entity.invulnerableTime == 0 && !entity.isInvulnerable()) {
                Vec3 checkPos = entity.getEyePosition();
                if (((Boolean)state.getValue((Property)COVER)).booleanValue()) {
                    checkPos = checkPos.add(0.0, 0.07, 0.0);
                }
                if (BlockPos.containing((Position)checkPos).equals((Object)blockPos)) {
                    entity.hurt(entity.damageSources().drown(), 2.0f);
                }
            }
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!((double)fallDistance < 4.0) && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallSounds = livingentity.getFallSounds();
            SoundEvent soundevent = (double)fallDistance < 7.0 ? fallSounds.small() : fallSounds.big();
            entity.playSound(soundevent, 1.0f, 1.0f);
        }
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)context).getEntity()) != null) {
            if (entity.fallDistance > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean flag = entity instanceof FallingBlockEntity;
            if (flag || TarBlock.canEntityWalkOn(entity) && context.isAbove(Shapes.block(), pos, false) && !context.isDescending()) {
                return super.getCollisionShape(state, level, pos, context);
            }
        }
        return Shapes.empty();
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public static boolean canEntityWalkOn(Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && EntityHelper.canWalkOnTarBlocks(living = (LivingEntity)entity);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{COVER});
    }

    static {
        CODEC = TarBlock.simpleCodec(TarBlock::new);
        FALLING_COLLISION_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
        COVER = BooleanProperty.create((String)"cover");
    }
}

