/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelClimbTreeGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelEatGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelGoToTreesGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelRandomStrollGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelSleepGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;

public class BurrelEntity
extends TamableAnimal
implements GeoEntity {
    public static final ResourceLocation STEP_ATTRIBUTE = ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"burrel_jump");
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.burrel.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.burrel.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation LOOK = RawAnimation.begin().then("animation.burrel.look", Animation.LoopType.DEFAULT);
    public static final RawAnimation CLIMB = RawAnimation.begin().then("animation.burrel.climb", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.burrel.dance", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAT = RawAnimation.begin().then("animation.burrel.eat", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP = RawAnimation.begin().then("animation.burrel.sleep", Animation.LoopType.DEFAULT);
    private static final EntityDataAccessor<Integer> TYPES = SynchedEntityData.defineId(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.defineId(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WANTS_TO_BE_ON_GROUND = SynchedEntityData.defineId(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.defineId(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final Direction[] POSSIBLE_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public BlockPos targetTree;
    private float wantsToBeOnGroundTicks = 0.0f;
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    private boolean partyBurrel;
    @javax.annotation.Nullable
    private BlockPos jukebox;
    public Direction prevAttachDir = Direction.DOWN;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BurrelEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.getAttribute(Attributes.STEP_HEIGHT).addOrReplacePermanentModifier(new AttributeModifier(STEP_ATTRIBUTE, 0.6, AttributeModifier.Operation.ADD_VALUE));
    }

    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BurrelSleepGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BurrelEatGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BurrelClimbTreeGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BurrelGoToTreesGoal(this, 1.2));
        this.goalSelector.addGoal(4, (Goal)new BurrelRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    protected PathNavigation createNavigation(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(ATTACHED_FACE, (Object)Direction.from3DDataValue((int)compound.getByte("attachface")));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("attachface", (byte)((Direction)this.entityData.get(ATTACHED_FACE)).get3DDataValue());
    }

    public void aiStep() {
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 7.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.partyBurrel = false;
            this.jukebox = null;
        }
        super.aiStep();
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.partyBurrel = isPartying;
    }

    public void tick() {
        super.tick();
        this.prevAttachChangeProgress = this.attachChangeProgress;
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.25f;
        }
        if (this.prevAttachDir != this.getAttachmentFacing()) {
            this.attachChangeProgress = 1.0f;
        }
        this.prevAttachDir = this.getAttachmentFacing();
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.level().isClientSide()) {
            if (this.level().isNight()) {
                this.setWantsToBeOnGround(false);
                this.wantsToBeOnGroundTicks = 0.0f;
            } else {
                if (this.wantsToBeOnGround()) {
                    this.wantsToBeOnGroundTicks += 1.0f;
                }
                if (this.wantsToBeOnGroundTicks >= 4800.0f) {
                    this.setWantsToBeOnGround(false);
                }
                if (!this.wantsToBeOnGround() && this.random.nextIntBetweenInclusive(1, 6000) == 1) {
                    this.wantsToBeOnGroundTicks = 0.0f;
                    this.setWantsToBeOnGround(true);
                }
            }
            if (this.onGround() || this.isInWater() || this.isInLava()) {
                this.setDirectionFacing(Direction.DOWN);
            } else {
                Direction closestDirection = Direction.DOWN;
                double closesDistance = 100.0;
                for (Direction direction : POSSIBLE_DIRECTIONS) {
                    BlockPos antPos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
                    BlockPos offsetPos = antPos.relative(direction);
                    Vec3 offset = Vec3.atCenterOf((Vec3i)offsetPos);
                    if (!(closesDistance > this.position().distanceTo(offset)) || !this.level().loadedAndEntityCanStandOnFace(offsetPos, (Entity)this, direction.getOpposite())) continue;
                    closesDistance = this.position().distanceTo(offset);
                    closestDirection = direction;
                }
                this.entityData.set(ATTACHED_FACE, (Object)(closesDistance > (double)(this.getBbWidth() * 0.5f + 0.7f) ? Direction.DOWN : closestDirection));
            }
        }
        if (this.getAttachmentFacing() != Direction.DOWN && !this.horizontalCollision && this.getAttachmentFacing() != Direction.UP) {
            Vec3 vec3 = Vec3.atLowerCornerOf((Vec3i)this.getAttachmentFacing().getNormal());
            this.setDeltaMovement(vector3d.add(vec3.normalize().multiply((double)0.1f, (double)0.1f, (double)0.1f)));
        }
        if (this.getAttachmentFacing() != Direction.DOWN) {
            this.setDeltaMovement(vector3d.multiply(0.6, 0.4, 0.6));
        }
        if (!this.isSleeping() && this.random.nextIntBetweenInclusive(1, 2000) == 1) {
            this.makeSound((SoundEvent)ModSounds.BURREL_IDLE.get());
        }
        if (!this.isBesideClimbableBlock() && !this.isSleeping() && this.wantsToBeOnGround() && this.random.nextIntBetweenInclusive(1, 500) == 1) {
            this.triggerAnim("second", "look");
        }
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.BURREL_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.BURREL_HURT.get();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isFood(itemStack)) {
            if (!this.isBaby()) {
                this.setInLove(player);
            }
            if (!this.level().isClientSide) {
                this.makeSound((SoundEvent)ModSounds.BURREL_EAT.get());
                this.getNavigation().stop();
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, itemStack);
            }
            itemStack.consume(1, (LivingEntity)this);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BABY, (Object)false);
        builder.define(TYPES, (Object)0);
        builder.define(CLIMBING, (Object)false);
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(WANTS_TO_BE_ON_GROUND, (Object)false);
        builder.define(SLEEPING, (Object)false);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.jukebox = null;
        this.partyBurrel = false;
        return super.hurt(source, amount);
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void setDirectionFacing(Direction directionFacing) {
        this.entityData.set(ATTACHED_FACE, (Object)directionFacing);
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    public boolean onClimbable() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.entityData.get(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.entityData.set(CLIMBING, (Object)climbing);
    }

    public boolean wantsToBeOnGround() {
        return (Boolean)this.entityData.get(WANTS_TO_BE_ON_GROUND);
    }

    public void setWantsToBeOnGround(boolean bool) {
        this.entityData.set(WANTS_TO_BE_ON_GROUND, (Object)bool);
    }

    public boolean isBaby() {
        return (Boolean)this.entityData.get(BABY);
    }

    public void setBaby(boolean b) {
        this.entityData.set(BABY, (Object)b);
    }

    public int getTypes() {
        return (Integer)this.entityData.get(TYPES);
    }

    public void setTypes(int i) {
        this.entityData.set(TYPES, (Object)i);
    }

    public boolean getSpawnBabyChance(RandomSource p) {
        return this.random.nextFloat() < 0.05f;
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setSleeping(boolean bool) {
        this.entityData.set(SLEEPING, (Object)bool);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Object sg = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        if (!(sg instanceof BurrelGroupData)) {
            int variant = 0;
            if (this.random.nextIntBetweenInclusive(1, 5) == 5) {
                variant = 1;
            }
            sg = new BurrelGroupData(variant);
        }
        this.setTypes(((BurrelGroupData)((Object)sg)).variant);
        return sg;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(ModBlocks.PINECONE.asItem());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        BurrelEntity burrel = new BurrelEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.BURREL.get()), (Level)serverLevel);
        burrel.setBaby(true);
        return burrel;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Animal.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, (double)0.22f);
        builder = builder.add(Attributes.MAX_HEALTH, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        return builder;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            if (this.isSleeping()) {
                return state.setAndContinue(SLEEP);
            }
            if (this.isBesideClimbableBlock()) {
                return state.setAndContinue(CLIMB);
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            if (this.partyBurrel) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "second", state -> PlayState.STOP).triggerableAnim("eat", EAT).triggerableAnim("look", LOOK));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class BurrelGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final int variant;

        public BurrelGroupData(int variant) {
            super(false);
            this.variant = variant;
        }
    }
}

