/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.datagen.server.ModEntityLootGen;
import team.recrafted.blastfromthepast.entity.PsychoBearEntity;
import team.recrafted.blastfromthepast.entity.ai.goal.EatDelphiniumGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.GlacerosAlertPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.GlacerosSparGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.MoveAwayFromBlockGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackAgeableMobData;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;

public class GlacerosEntity
extends Animal
implements GeoEntity,
VariantHolder<Variant>,
EntityPackHolder<GlacerosEntity> {
    public static final ResourceLocation STEP_ATTRIBUTE = ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"glaceros_jump");
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> PANICKING = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> RUSHING = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<UUID>> SPARRING_PARTNER = SynchedEntityData.defineId(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public int antlerGrowCooldown;
    public int alertCooldown;
    public boolean shouldSparInstantly;
    public int sparringCooldown = 150 + this.getRandom().nextInt(50);
    public int chargeTimer;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    private EntityPack<GlacerosEntity> pack;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.glaceros.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAT = RawAnimation.begin().then("animation.glaceros.eat", Animation.LoopType.DEFAULT);
    public static final RawAnimation CHARGE = RawAnimation.begin().then("animation.glaceros.charge", Animation.LoopType.DEFAULT);
    public static final RawAnimation CHARGE_PREPARE = RawAnimation.begin().then("animation.glaceros.charge_prepare", Animation.LoopType.DEFAULT);
    public static final RawAnimation TAIL = RawAnimation.begin().then("animation.glaceros.tail", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.glaceros.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation FLEE = RawAnimation.begin().then("animation.glaceros.flee", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.glaceros.dance", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GlacerosEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.getAttribute(Attributes.STEP_HEIGHT).addOrReplacePermanentModifier(new AttributeModifier(STEP_ATTRIBUTE, 0.6, AttributeModifier.Operation.ADD_VALUE));
    }

    @NotNull
    protected PathNavigation createNavigation(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 0.0);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GlacerosAlertPanicGoal(this, 3.5));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, itemStack -> itemStack.is(this.getVariant().getDelphinium().asItem()), false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new EatDelphiniumGoal(this, 1.0, 15));
        this.goalSelector.addGoal(7, (Goal)new GlacerosLookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(7, (Goal)new MoveAwayFromBlockGoal((PathfinderMob)this, Blocks.FIRE, 1.7, 12));
        this.goalSelector.addGoal(8, (Goal)new GlacerosLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new GlacerosSparGoal(this));
        this.targetSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, PsychoBearEntity.class, 20.0f, (double)1.2f, 2.0));
        this.targetSelector.addGoal(5, (Goal)new AvoidSpeartoothGoal(this, (PathfinderMob)this, 20.0f, 1.2f, 2.0));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData) {
        Variant glaceros$variant;
        RandomSource randomsource = level.getRandom();
        if (spawnGroupData instanceof GlacerosGroupData) {
            GlacerosGroupData glacerosGroupData = (GlacerosGroupData)spawnGroupData;
            glaceros$variant = ((GlacerosGroupData)spawnGroupData).variant;
            glacerosGroupData.addPackMember((Mob)this);
        } else {
            glaceros$variant = this.getVariantFromChance(randomsource);
            spawnGroupData = new GlacerosGroupData(BlastFromThePast.getUniversalEntityPacks(level.getLevel().getServer()).createFreshPack(), glaceros$variant);
        }
        this.setVariant(glaceros$variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private Variant getVariantFromChance(RandomSource random) {
        float chance = random.nextFloat();
        if ((double)chance <= 0.25) {
            return Variant.STRAIGHT;
        }
        if (0.25 < (double)chance && (double)chance <= 0.5) {
            return Variant.SPIKEY;
        }
        if (0.5 < (double)chance && (double)chance <= 0.75) {
            return Variant.CURLY;
        }
        return Variant.BROAD;
    }

    public void aiStep() {
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 7.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        super.aiStep();
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            if (this.isRushing()) {
                return state.setAndContinue(CHARGE);
            }
            if (this.isCharging()) {
                return state.setAndContinue(CHARGE_PREPARE);
            }
            if (this.isEating()) {
                return state.setAndContinue(EAT);
            }
            if (this.isPanicking() || this.isRunning()) {
                return state.setAndContinue(FLEE);
            }
            if (this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.isBaby()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        })).add(new AnimationController((GeoAnimatable)this, "second", 5, state -> PlayState.STOP).triggerableAnim("tail", TAIL));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public EntityPack<GlacerosEntity> getPack() {
        return this.pack;
    }

    @Override
    public void setPack(@org.jetbrains.annotations.Nullable EntityPack<GlacerosEntity> pack) {
        this.pack = pack;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.hurt(source, amount);
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        List glacerosEntities;
        super.actuallyHurt(damageSource, damageAmount);
        if (damageSource.is(DamageTypeTags.PANIC_CAUSES) && !(glacerosEntities = this.level().getEntitiesOfClass(GlacerosEntity.class, this.getBoundingBox().inflate(16.0))).isEmpty()) {
            for (GlacerosEntity glaceros : glacerosEntities) {
                glaceros.setPanicking(true);
                glaceros.alertCooldown = 150 + glaceros.getRandom().nextInt(100);
            }
        }
    }

    @NotNull
    public ResourceKey<LootTable> getDefaultLootTable() {
        if (this.isSheared()) {
            return this.getType().getDefaultLootTable();
        }
        ResourceKey<LootTable> key = switch (this.getVariant().ordinal()) {
            case 1 -> ModEntityLootGen.GLACEROS_BROAD;
            case 2 -> ModEntityLootGen.GLACEROS_CURLY;
            case 3 -> ModEntityLootGen.GLACEROS_SPIKEY;
            case 0 -> ModEntityLootGen.GLACEROS_STRAIGHT;
            default -> throw new MatchException(null, null);
        };
        return key;
    }

    public void tick() {
        super.tick();
        if (this.sparringCooldown > 0) {
            --this.sparringCooldown;
        }
        if (!this.level().isClientSide) {
            if (this.alertCooldown != 0) {
                --this.alertCooldown;
            } else {
                this.setPanicking(false);
            }
            this.setRunning(this.moveControl.getSpeedModifier() > 1.1 && !this.isSparring());
            if (this.isCharging()) {
                this.setZza(0.0f);
                this.getNavigation().stop();
            }
            if (this.isSparring() && this.getSparringPartner() != null) {
                this.getLookControl().setLookAt(this.getSparringPartner());
            }
            if (this.getSparringPartner() == null) {
                this.setCharging(false);
                this.setRushing(false);
            }
            if (this.isSheared()) {
                if (this.antlerGrowCooldown != 0) {
                    --this.antlerGrowCooldown;
                } else {
                    this.setSheared(false);
                }
            }
            if (!this.isPanicking() && this.getRandom().nextInt(this.isBaby() ? 30 : 100) == 0) {
                this.triggerAnim("second", "tail");
            }
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(this.getVariant().getDelphinium().asItem());
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        GlacerosEntity child = (GlacerosEntity)((EntityType)ModEntities.GLACEROS.get()).create((Level)level);
        child.setBaby(true);
        child.setVariant(this.getVariant());
        GlacerosEntity otherGlaceros = (GlacerosEntity)otherParent;
        if (otherGlaceros.getVariant() != this.getVariant() && (double)this.getRandom().nextFloat() < 0.5) {
            child.setVariant(otherGlaceros.getVariant());
        }
        return child;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)0);
        builder.define(PANICKING, (Object)false);
        builder.define(EATING, (Object)false);
        builder.define(SHEARED, (Object)false);
        builder.define(RUNNING, (Object)false);
        builder.define(CHARGING, (Object)false);
        builder.define(RUSHING, (Object)false);
        builder.define(SPARRING_PARTNER, Optional.empty());
    }

    @org.jetbrains.annotations.Nullable
    public UUID getSparringPartnerUUID() {
        return ((Optional)this.entityData.get(SPARRING_PARTNER)).orElse(null);
    }

    public void setSparringPartnerUUID(UUID sparringPartner) {
        this.entityData.set(SPARRING_PARTNER, Optional.ofNullable(sparringPartner));
    }

    @org.jetbrains.annotations.Nullable
    public Entity getSparringPartner() {
        UUID id = this.getSparringPartnerUUID();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setSparringPartner(@org.jetbrains.annotations.Nullable Entity sparringPartner) {
        if (sparringPartner == null) {
            this.setSparringPartnerUUID(null);
        } else {
            this.setSparringPartnerUUID(sparringPartner.getUUID());
        }
    }

    public boolean isPanicking() {
        return (Boolean)this.entityData.get(PANICKING);
    }

    public void setPanicking(boolean panicking) {
        this.entityData.set(PANICKING, (Object)panicking);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(CHARGING, (Object)charging);
    }

    public boolean isRushing() {
        return (Boolean)this.entityData.get(RUSHING);
    }

    public void setRushing(boolean rushing) {
        this.entityData.set(RUSHING, (Object)rushing);
    }

    public boolean isSparring() {
        return this.isRushing() || this.isCharging();
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(EATING, (Object)eating);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(SHEARED, (Object)sheared);
    }

    public boolean isRunning() {
        return (Boolean)this.entityData.get(RUNNING);
    }

    public void setRunning(boolean running) {
        this.entityData.set(RUNNING, (Object)running);
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public boolean canSparWith(GlacerosEntity glaceros) {
        return !glaceros.isSparring() && !glaceros.isSheared() && !glaceros.isBaby() && glaceros.getSparringPartnerUUID() == null && glaceros.sparringCooldown == 0;
    }

    public void knockBackSparring(GlacerosEntity glacerosEntity, float strength) {
        this.applyKnockbackFromGlaceros(strength, glacerosEntity.getX() - this.getX(), glacerosEntity.getZ() - this.getZ());
    }

    private void applyKnockbackFromGlaceros(float strength, double ratioX, double ratioZ) {
        if (!(strength <= 0.0f)) {
            this.playSound((SoundEvent)ModSounds.GLACEROS_CLASH.get(), 5.0f, 5.0f);
            this.hasImpulse = true;
            Vec3 vector3d = this.getDeltaMovement();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).normalize().scale((double)strength);
            this.setDeltaMovement(vector3d.x / 2.0 - vector3d1.x, 0.3f, vector3d.z / 2.0 - vector3d1.z);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant().id);
        compound.putBoolean("Panicking", this.isPanicking());
        compound.putBoolean("Eating", this.isEating());
        compound.putBoolean("Sheared", this.isSheared());
        compound.putBoolean("Charging", this.isCharging());
        compound.putBoolean("Rushing", this.isRushing());
        compound.putInt("AntlerCooldown", this.antlerGrowCooldown);
        compound.putInt("AlertCooldown", this.alertCooldown);
        compound.putInt("SparringCooldown", this.sparringCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId(compound.getInt("Variant")));
        this.setPanicking(compound.getBoolean("Panicking"));
        this.setEating(compound.getBoolean("Eating"));
        this.setSheared(compound.getBoolean("Sheared"));
        this.setCharging(compound.getBoolean("Charging"));
        this.setRushing(compound.getBoolean("Rushing"));
        this.antlerGrowCooldown = compound.getInt("AntlerCooldown");
        this.alertCooldown = compound.getInt("AlertCooldown");
        this.sparringCooldown = compound.getInt("SparringCooldown");
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.GLACEROS_HURT.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.GLACEROS_IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.GLACEROS_DEATH.get();
    }

    public class GlacerosLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public GlacerosLookAtPlayerGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
        }

        public boolean canUse() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.canContinueToUse();
        }
    }

    public class GlacerosLookAroundGoal
    extends RandomLookAroundGoal {
        public GlacerosLookAroundGoal(Mob mob) {
            super(mob);
        }

        public boolean canUse() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.canContinueToUse();
        }
    }

    public class AvoidSpeartoothGoal
    extends AvoidEntityGoal<SpeartoothEntity> {
        private final TargetingConditions avoidEntityTargeting;

        public AvoidSpeartoothGoal(GlacerosEntity this$0, PathfinderMob mob, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
            super(mob, SpeartoothEntity.class, maxDistance, walkSpeedModifier, sprintSpeedModifier);
            this.avoidEntityTargeting = TargetingConditions.forCombat().range((double)maxDistance).selector(this.predicateOnAvoidEntity.and(this.avoidPredicate));
        }

        public boolean canUse() {
            this.toAvoid = this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.avoidClass, this.mob.getBoundingBox().inflate((double)this.maxDist, 3.0, (double)this.maxDist), p_148078_ -> true), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ());
            if (this.toAvoid == null || ((SpeartoothEntity)this.toAvoid).getState() == SpeartoothEntity.State.STALK || ((SpeartoothEntity)this.toAvoid).isTame()) {
                return false;
            }
            Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)((SpeartoothEntity)this.toAvoid).position());
            if (vec3 == null) {
                return false;
            }
            if (((SpeartoothEntity)this.toAvoid).distanceToSqr(vec3.x, vec3.y, vec3.z) < ((SpeartoothEntity)this.toAvoid).distanceToSqr((Entity)this.mob)) {
                return false;
            }
            this.path = this.pathNav.createPath(vec3.x, vec3.y, vec3.z, 0);
            return this.path != null;
        }
    }

    static class GlacerosGroupData
    extends EntityPackAgeableMobData<GlacerosEntity> {
        public final Variant variant;

        GlacerosGroupData(EntityPack<GlacerosEntity> pack, Variant variant) {
            super(pack, true);
            this.variant = variant;
        }
    }

    public static enum Variant implements StringRepresentable
    {
        STRAIGHT(0, "normal", (Block)ModBlocks.SNOW_LARKSPUR.get(), (Item)ModItems.STRAIGHT_GLACEROS_ANTLERS.get()),
        BROAD(1, "broad", (Block)ModBlocks.SHIVER_LARKSPUR.get(), (Item)ModItems.BROAD_GLACEROS_ANTLERS.get()),
        CURLY(2, "curly", (Block)ModBlocks.BLUSH_LARKSPUR.get(), (Item)ModItems.CURLY_GLACEROS_ANTLERS.get()),
        SPIKEY(3, "spikey", (Block)ModBlocks.ROYAL_LARKSPUR.get(), (Item)ModItems.SPIKEY_GLACEROS_ANTLERS.get());

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;
        private final Block delphinium;
        private final Item antlerItem;

        private Variant(int id, String name, Block delphinium, Item antlerItem) {
            this.id = id;
            this.name = name;
            this.delphinium = delphinium;
            this.antlerItem = antlerItem;
        }

        public Block getDelphinium() {
            return this.delphinium;
        }

        public Item getAntlerItem() {
            return this.antlerItem;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

