/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.access.PlayerBFTPDataAccess;
import team.recrafted.blastfromthepast.entity.misc.TransitioningState;
import team.recrafted.blastfromthepast.events.CuriosCompat;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;

public class HollowEntity
extends LivingEntity
implements GeoEntity {
    private static final EntityDataAccessor<TransitioningState> STATE = SynchedEntityData.defineId(HollowEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.TRANSITIONING_STATE.get()));
    @Nullable
    private StoredInventory storedInventory;
    @Nullable
    private Player trackedPlayer;
    private int transitionTicks = -1;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.hollow.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation IDLE_ORBLESS = RawAnimation.begin().then("animation.hollow.idle_orbless", Animation.LoopType.DEFAULT);
    public static final RawAnimation ORB_SPAWN = RawAnimation.begin().then("animation.hollow.orb_spawn", Animation.LoopType.DEFAULT);
    public static final RawAnimation ORB_DESPAWN = RawAnimation.begin().then("animation.hollow.orb_despawn", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HollowEntity(EntityType<? extends HollowEntity> hollowEntityEntityType, Level level) {
        super(hollowEntityEntityType, level);
    }

    public static HollowEntity create(ServerPlayer player) {
        HollowEntity hollow = (HollowEntity)((EntityType)ModEntities.HOLLOW.get()).create(player.level());
        assert (hollow != null);
        hollow.setPos(player.position());
        BlockPos safePos = EntityHelper.findSafeSpot(hollow);
        if (safePos != null) {
            hollow.setPos(safePos.getX(), safePos.getY(), safePos.getZ());
        }
        if (DebugFlags.DEBUG_HOLLOW) {
            hollow.addEffect(new MobEffectInstance(MobEffects.GLOWING, -1, 0, true, false));
            player.getServer().getPlayerList().getPlayers().forEach(p -> p.sendSystemMessage((Component)Component.literal((String)("Hollow created at " + String.valueOf(hollow.position()) + " for " + String.valueOf(player.getName())))));
        }
        hollow.setRot(player.getYRot(), 0.0f);
        hollow.storeInventory(player);
        return hollow;
    }

    public void storeInventory(ServerPlayer player) {
        ListTag inventoryData = new ListTag();
        player.getInventory().save(inventoryData);
        List<ItemStack> additionalItems = BlastFromThePast.CURIOS_LOADED ? CuriosCompat.getCuriosItems(player) : null;
        this.storedInventory = new StoredInventory(player.getUUID(), inventoryData, Optional.ofNullable(additionalItems));
        ((PlayerBFTPDataAccess)player).bftp$markInventoryStored();
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        TransitioningState state = (TransitioningState)this.getEntityData().get(STATE);
        if (this.transitionTicks > 0) {
            --this.transitionTicks;
        } else if (this.transitionTicks == 0) {
            if (state.isTransitional()) {
                switch (state) {
                    case INACTIVE_TO_ACTIVE: {
                        this.getEntityData().set(STATE, (Object)TransitioningState.ACTIVE);
                        this.transitionTicks = 40;
                        break;
                    }
                    case ACTIVE_TO_INACTIVE: {
                        this.getEntityData().set(STATE, (Object)TransitioningState.INACTIVE);
                    }
                }
            } else {
                this.transitionTicks = -1;
            }
        } else if (this.storedInventory != null) {
            Player owner = this.getOwnerNearby();
            if (state == TransitioningState.INACTIVE && owner != null) {
                this.trackedPlayer = owner;
                this.getEntityData().set(STATE, (Object)TransitioningState.INACTIVE_TO_ACTIVE);
                this.transitionTicks = 20;
            } else if (state == TransitioningState.ACTIVE && owner == null) {
                this.trackedPlayer = null;
                this.getEntityData().set(STATE, (Object)TransitioningState.ACTIVE_TO_INACTIVE);
                this.transitionTicks = 10;
            }
        }
    }

    @Nullable
    public Player getOwnerNearby() {
        if (this.storedInventory == null) {
            return null;
        }
        List nearbyPlayer = this.level().getNearbyEntities(Player.class, TargetingConditions.forNonCombat().selector(p -> p.isAlive() && p.getUUID().equals(this.storedInventory.playerUuid)), (LivingEntity)this, this.getBoundingBox().inflate(5.0));
        return nearbyPlayer.isEmpty() ? null : (Player)nearbyPlayer.getFirst();
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)TransitioningState.INACTIVE);
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return super.interact(player, hand);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.storedInventory != null && player.getUUID().equals(this.storedInventory.playerUuid)) {
            FakePlayer fakePlayer = EntityHelper.getFakePlayer(serverLevel);
            fakePlayer.getInventory().load(this.storedInventory.inventoryData);
            for (int i = 0; i < fakePlayer.getInventory().getContainerSize(); ++i) {
                ItemStack stack2 = fakePlayer.getInventory().getItem(i);
                if (stack2.isEmpty() || !player.getInventory().getItem(i).isEmpty()) continue;
                player.getInventory().setItem(i, stack2);
                fakePlayer.getInventory().setItem(i, ItemStack.EMPTY);
            }
            List additionalItems = this.storedInventory.additionalItems.orElse(Collections.emptyList());
            additionalItems.removeIf(stack -> player.getInventory().add(stack));
            if (fakePlayer.getInventory().isEmpty() && additionalItems.isEmpty()) {
                this.storedInventory = null;
                this.discard();
            } else {
                if (!fakePlayer.getInventory().isEmpty()) {
                    for (int i = 0; i < fakePlayer.getInventory().getContainerSize(); ++i) {
                        int slot;
                        ItemStack stack3 = fakePlayer.getInventory().getItem(i);
                        if (stack3.isEmpty()) continue;
                        if (player.getInventory().add(stack3)) {
                            fakePlayer.getInventory().setItem(i, ItemStack.EMPTY);
                            continue;
                        }
                        if (stack3.getMaxStackSize() <= 1 || (slot = player.getInventory().findSlotMatchingItem(stack3)) == -1) continue;
                        ItemStack existing = player.getInventory().getItem(slot);
                        int count = Math.min(stack3.getCount(), existing.getMaxStackSize() - existing.getCount());
                        existing.grow(count);
                        stack3.shrink(count);
                        fakePlayer.getInventory().setItem(i, stack3);
                    }
                }
                if (fakePlayer.getInventory().isEmpty() && additionalItems.isEmpty()) {
                    this.storedInventory = null;
                    this.discard();
                } else {
                    ListTag inventoryData = new ListTag();
                    fakePlayer.getInventory().save(inventoryData);
                    this.storedInventory = new StoredInventory(player.getUUID(), inventoryData, Optional.of(additionalItems));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void restoreAdditionalItems(ServerPlayer player) {
        if (this.storedInventory == null) {
            return;
        }
        List additionalItems = this.storedInventory.additionalItems.orElse(Collections.emptyList());
        additionalItems.removeIf(stack -> player.getInventory().add(stack));
        this.storedInventory = new StoredInventory(player.getUUID(), this.storedInventory.inventoryData, Optional.of(additionalItems));
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return !source.is(DamageTypes.GENERIC_KILL);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of(ItemStack.EMPTY);
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("stored_inventory")) {
            this.storedInventory = StoredInventory.fromSaveData(this.registryAccess(), compound.getCompound("stored_inventory"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.storedInventory != null) {
            compound.put("stored_inventory", (Tag)this.storedInventory.getSaveData(this.registryAccess()));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            TransitioningState state1 = (TransitioningState)this.getEntityData().get(STATE);
            if (state1 == TransitioningState.INACTIVE_TO_ACTIVE) {
                return state.setAndContinue(ORB_SPAWN);
            }
            if (state1 == TransitioningState.ACTIVE_TO_INACTIVE) {
                return state.setAndContinue(ORB_DESPAWN);
            }
            if (state1 == TransitioningState.INACTIVE) {
                return state.setAndContinue(IDLE_ORBLESS);
            }
            if (state1 == TransitioningState.ACTIVE) {
                return state.setAndContinue(IDLE);
            }
            return PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public record StoredInventory(UUID playerUuid, ListTag inventoryData, Optional<List<ItemStack>> additionalItems) {
        public CompoundTag getSaveData(RegistryAccess registryAccess) {
            CompoundTag data = new CompoundTag();
            data.putUUID("player", this.playerUuid);
            data.put("items", (Tag)this.inventoryData);
            ListTag additionalItems = new ListTag();
            this.additionalItems.ifPresent(items -> items.forEach(item -> additionalItems.add((Object)item.saveOptional((HolderLookup.Provider)registryAccess))));
            if (!additionalItems.isEmpty()) {
                data.put("additional_items", (Tag)additionalItems);
            }
            return data;
        }

        public static StoredInventory fromSaveData(RegistryAccess registryAccess, CompoundTag data) {
            ArrayList additionalItems = new ArrayList();
            if (data.contains("additional_items")) {
                ListTag additionalItemsData = data.getList("additional_items", 10);
                for (Tag tag : additionalItemsData) {
                    ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)tag).ifPresent(additionalItems::add);
                }
            }
            return new StoredInventory(data.getUUID("player"), data.getList("items", 10), Optional.of(additionalItems));
        }
    }
}

