/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableBodyRotationControl;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableLookControl;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableMoveControl;
import team.recrafted.blastfromthepast.entity.ai.goal.AgeableHurtByTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedBreedGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedFollowParentGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.PredicatedGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.RaidFoodContainerGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.ScratchBackOnTreeGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.attacker.AnimatedMeleeAttackGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.complex_animal.MoveToOrSitWithItemGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.complex_animal.SeekShelterGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.complex_animal.SleepGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.roar.RoarAtTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.BFTPGroundPathNavigation;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.BackScratcher;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.entity.misc.OverrideAnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.Pacifiable;
import team.recrafted.blastfromthepast.entity.misc.TransitioningState;
import team.recrafted.blastfromthepast.init.ModCriteriaTriggers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.init.ModTags;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class PsychoBearEntity
extends Animal
implements GeoEntity,
OverrideAnimatedAttacker<PsychoBearEntity, PsychoBearAttackType>,
ComplexAnimal,
Pacifiable,
Roaring,
BackScratcher {
    public static final EntityDimensions PSYCHO_BEAR_BABY_DIMENSIONS = EntityDimensions.scalable((float)HitboxHelper.pixelsToBlocks(18.0f), (float)HitboxHelper.pixelsToBlocks(13.0f));
    private static final EntityDataAccessor<OptionalInt> DATA_ACTIVE_ATTACK_TYPE = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_PACIFIED = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_EATING = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> DATA_SLEEP_STATE = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_BACK_SCRATCH_STATE = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_PREPARING_TO_SCRATCH_BACK = SynchedEntityData.defineId(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final byte SITTING_FLAG = 1;
    private static final int ROARING_FLAG = 2;
    private static final int MAX_EAT_TIME = Mth.floor((float)50.0f);
    public static final int FINISH_CHEWING_ACTION_POINT = Mth.floor((float)35.0f);
    public static final int START_CHEWING_ACTION_POINT = Mth.floor((float)15.0f);
    public static final int MAX_ROAR_TICKS = Mth.floor((float)50.0f);
    private static final TargetingConditions ALERT_CONDITIONS = TargetingConditions.forCombat().ignoreLineOfSight();
    public static final float ADULT_VERTICAL_WIDTH = HitboxHelper.pixelsToBlocks(21.0f);
    private final AnimatedAttacker.AttackTicker<PsychoBearEntity, PsychoBearAttackType> attackTicker = new AnimatedAttacker.AttackTicker(this);
    private int pacifiedTicks = 0;
    private int eatCounter = 0;
    private Player lastFedPlayer;
    private int moreFoodTicks;
    private int itchReliefTicks;
    private int roarCounter;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    private static final int LIE_DOWN_DURATION = Mth.floor((float)20.0f);
    private static final int WAKE_UP_DURATION = Mth.floor((float)20.0f);
    private static final int BACK_SCRATCH_START_DURATION = Mth.floor((float)10.0f);
    private static final int BACK_SCRATCH_END_DURATION = Mth.floor((float)10.0f);
    private final TransitioningState.TransitionTicker sleepTicker = new TransitioningState.TransitionTicker(this::getSleepState, this::setSleepState, LIE_DOWN_DURATION, WAKE_UP_DURATION);
    private final TransitioningState.TransitionTicker backScratchTicker = new TransitioningState.TransitionTicker(this::getBackScratchState, this::setBackScratchState, BACK_SCRATCH_START_DURATION, BACK_SCRATCH_END_DURATION);
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.psycho_bear.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation ROAR = RawAnimation.begin().then("animation.psycho_bear.roar", Animation.LoopType.DEFAULT);
    public static final RawAnimation ATTACK_FLIPPED = RawAnimation.begin().then("animation.psycho_bear.attack_flipped", Animation.LoopType.DEFAULT);
    public static final RawAnimation ATTACK = RawAnimation.begin().then("animation.psycho_bear.attack", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAT = RawAnimation.begin().then("animation.psycho_bear.eat", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP_START = RawAnimation.begin().then("animation.psycho_bear.sleep_start", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP = RawAnimation.begin().then("animation.psycho_bear.sleep", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP_END = RawAnimation.begin().then("animation.psycho_bear.sleep_end", Animation.LoopType.DEFAULT);
    public static final RawAnimation SCRATCH_START = RawAnimation.begin().then("animation.psycho_bear.back_scratch_start", Animation.LoopType.DEFAULT);
    public static final RawAnimation SCRATCH_LOOP = RawAnimation.begin().then("animation.psycho_bear.back_scratch_loop", Animation.LoopType.DEFAULT);
    public static final RawAnimation SCRATCH_STOP = RawAnimation.begin().then("animation.psycho_bear.back_scratch_stop", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.psycho_bear.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.psycho_bear.dance", Animation.LoopType.DEFAULT);
    private static final double MINIMUM_ATTACK_SIZE = HitboxHelper.calculateMinimumAttackHitboxWidth(((EntityType)ModEntities.PSYCHO_BEAR.get()).getWidth());
    private static final Vec3 DEFAULT_ATTACK_SIZE = new Vec3(MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PsychoBearEntity(EntityType<? extends PsychoBearEntity> entityType, Level level) {
        super(entityType, level);
        this.lookControl = new OverridableLookControl<PsychoBearEntity>(this);
        this.moveControl = new OverridableMoveControl<PsychoBearEntity>(this);
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.MAX_HEALTH, 70.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ACTIVE_ATTACK_TYPE, (Object)OptionalInt.empty());
        builder.define(DATA_FLAGS, (Object)0);
        builder.define(DATA_PACIFIED, (Object)false);
        builder.define(DATA_EATING, (Object)false);
        builder.define(DATA_SLEEP_STATE, (Object)((byte)TransitioningState.INACTIVE.ordinal()));
        builder.define(DATA_BACK_SCRATCH_STATE, (Object)((byte)TransitioningState.INACTIVE.ordinal()));
        builder.define(DATA_PREPARING_TO_SCRATCH_BACK, (Object)false);
    }

    protected boolean getFlag(int flag) {
        return ((Byte)this.entityData.get(DATA_FLAGS) & flag) != 0;
    }

    protected void setFlag(int flagId, boolean value) {
        byte flags = (Byte)this.entityData.get(DATA_FLAGS);
        if (value) {
            this.entityData.set(DATA_FLAGS, (Object)((byte)(flags | flagId)));
        } else {
            this.entityData.set(DATA_FLAGS, (Object)((byte)(flags & ~flagId)));
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (DATA_ACTIVE_ATTACK_TYPE.equals(pKey)) {
            this.attackTicker.reset();
        }
        if (!this.firstTick && DATA_EATING.equals(pKey)) {
            this.eatCounter = 0;
        }
        if (DATA_SLEEP_STATE.equals(pKey)) {
            this.sleepTicker.triggerStateChange();
        }
        if (DATA_BACK_SCRATCH_STATE.equals(pKey)) {
            this.refreshDimensions();
            this.backScratchTicker.triggerStateChange();
        }
        if (DATA_PREPARING_TO_SCRATCH_BACK.equals(pKey)) {
            this.refreshDimensions();
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new OverridableBodyRotationControl<PsychoBearEntity>(this);
    }

    protected PathNavigation createNavigation(Level level) {
        return new BFTPGroundPathNavigation((Mob)this, level);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isBackScratching() || this.isPreparingToScratchBack()) {
            EntityDimensions normalDimensions = this.getType().getDimensions();
            return EntityDimensions.scalable((float)ADULT_VERTICAL_WIDTH, (float)normalDimensions.width());
        }
        return this.isBaby() ? PSYCHO_BEAR_BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new RoarAtTargetGoal<PsychoBearEntity>(this, 3.0));
        this.goalSelector.addGoal(2, new PredicatedGoal<PsychoBearEntity>((Goal)new AnimatedMeleeAttackGoal(this, 1.0, true), this, Predicate.not(OverrideAnimatedAttacker::isAllActionBlocked)));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 2.0, EntityHelper::getPanicInducingDamageTypes));
        this.goalSelector.addGoal(4, new SeekShelterGoal<PsychoBearEntity>(this, 1.0));
        this.goalSelector.addGoal(5, new SleepGoal<PsychoBearEntity>(this));
        this.goalSelector.addGoal(6, (Goal)new HitboxAdjustedBreedGoal(this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this::isTemptItem, false));
        this.goalSelector.addGoal(8, new MoveToOrSitWithItemGoal<PsychoBearEntity>(this, this::isWantedItem, 1.0));
        this.goalSelector.addGoal(9, (Goal)new HitboxAdjustedFollowParentGoal(this, 1.25));
        this.goalSelector.addGoal(10, new RaidFoodContainerGoal<PsychoBearEntity>(this, 1.0, 16, 1));
        this.goalSelector.addGoal(11, new ScratchBackOnTreeGoal<PsychoBearEntity>(this, 1.0, 16, 1, this::isBackScratchBlock));
        this.goalSelector.addGoal(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(13, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new AgeableHurtByTargetGoal<PsychoBearEntity>(this));
        this.targetSelector.addGoal(2, new PredicatedGoal<PsychoBearEntity>((Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null), this, PsychoBearEntity::canBeAggressive, true));
        this.targetSelector.addGoal(3, new PredicatedGoal<PsychoBearEntity>((Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, this::canTarget), this, PsychoBearEntity::canBeAggressive, true));
    }

    private boolean isBackScratchBlock(BlockState blockState) {
        return blockState.is(ModTags.Blocks.PSYCHO_BEAR_SCRATCHES_BACK_ON);
    }

    protected boolean canBeAggressive() {
        return !this.isPacified() && !this.isBaby() && !this.isSleeping();
    }

    protected boolean canTarget(LivingEntity target) {
        return target.attackable() && !target.getType().is(ModTags.EntityTypes.PSYCHO_BEAR_IGNORES);
    }

    private boolean isTemptItem(ItemStack stack) {
        return stack.is(this.isBaby() ? ModTags.Items.BABY_PSYCHO_BEAR_TEMPT_ITEMS : ModTags.Items.PSYCHO_BEAR_TEMPT_ITEMS);
    }

    public boolean isFood(ItemStack itemStack) {
        return this.isBaby() ? itemStack.is(ModTags.Items.BABY_PSYCHO_BEAR_FOOD) : itemStack.is(ModTags.Items.PSYCHO_BEAR_FOOD);
    }

    public boolean isPacifier(ItemStack stack) {
        return stack.is(ModTags.Items.PSYCHO_BEAR_PACIFIER);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack playerItemInHand = player.getItemInHand(hand);
        if (playerItemInHand.is(Items.DEBUG_STICK)) {
            player.displayClientMessage((Component)Component.literal((String)String.format("%s %s states: Eating[%s], Sitting[%s], Sleeping[%s], Pacified[%s], Roaring[%s]", this.getDisplayName().getString(), this.level().isClientSide ? "Client" : "Server", this.isEating(), this.isSitting(), this.isSleeping(), this.isPacified(), this.isRoaring())), false);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        boolean canEat = false;
        if (this.isPacifier(playerItemInHand) && !this.isBaby() && !this.isPacified()) {
            canEat = true;
        } else if (this.isFood(playerItemInHand)) {
            if (this.isBaby()) {
                this.usePlayerItem(player, hand, playerItemInHand);
                this.ageUp(PsychoBearEntity.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.level().isClientSide && this.getAge() == 0 && this.canFallInLove()) {
                this.usePlayerItem(player, hand, playerItemInHand);
                this.setInLove(player);
                return InteractionResult.SUCCESS;
            }
            canEat = true;
        }
        if (canEat) {
            if (!this.canMove() || this.isBaby()) {
                return InteractionResult.PASS;
            }
            if (!this.level().isClientSide) {
                this.tryToSit();
                this.lastFedPlayer = player;
                this.setEating(true);
                ItemStack mainHandItem = this.getItemInMouth();
                if (!mainHandItem.isEmpty() && !player.hasInfiniteMaterials()) {
                    this.spawnAtLocation(mainHandItem);
                }
                this.putItemInMouth(new ItemStack((ItemLike)playerItemInHand.getItem(), 1), false);
                this.usePlayerItem(player, hand, playerItemInHand);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)ModEntities.PSYCHO_BEAR.get()).create((Level)serverLevel);
    }

    @Override
    public void setActiveAttackType(@org.jetbrains.annotations.Nullable PsychoBearAttackType attackType) {
        this.entityData.set(DATA_ACTIVE_ATTACK_TYPE, (Object)(attackType == null ? OptionalInt.empty() : OptionalInt.of(attackType.ordinal())));
        if (attackType != null && !this.level().isClientSide) {
            if (this.isRoaring()) {
                this.setRoaring(false);
            }
            if (this.isEating()) {
                this.setEating(false);
            }
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public PsychoBearAttackType getActiveAttackType() {
        OptionalInt ordinal = (OptionalInt)this.entityData.get(DATA_ACTIVE_ATTACK_TYPE);
        return ordinal.isEmpty() ? null : PsychoBearAttackType.byOrdinal(ordinal.getAsInt());
    }

    @Override
    public PsychoBearAttackType selectAttackTypeForTarget(@org.jetbrains.annotations.Nullable LivingEntity target) {
        return PsychoBearAttackType.SLASH;
    }

    public void tick() {
        super.tick();
        if (this.isEffectiveAi()) {
            boolean inWater = this.isInWater();
            if (this.getTarget() != null && this.isSleeping()) {
                this.setTarget(null);
            }
            if (inWater || this.level().isThundering()) {
                this.setSleeping(false);
            }
            if (inWater || this.isSleeping()) {
                this.setSitting(false);
                this.setEating(false);
            }
        }
        if (!this.canRotateHead()) {
            this.clampHeadRotationToBody();
        }
        if (this.isSitting()) {
            this.setXRot(0.0f);
        }
        this.attackTicker.tick();
        if (this.pacifiedTicks > 0) {
            --this.pacifiedTicks;
            if (this.pacifiedTicks == 0 && !this.level().isClientSide) {
                this.setPacified(false);
            }
        }
        this.handleEating();
        if (this.roarCounter > 0 && ++this.roarCounter > MAX_ROAR_TICKS) {
            this.roarCounter = 0;
            if (!this.level().isClientSide) {
                this.setRoaring(false);
            }
        }
        this.sleepTicker.tick(!this.level().isClientSide);
        this.backScratchTicker.tick(!this.level().isClientSide);
    }

    @Override
    public boolean isRoaring() {
        return this.getFlag(2);
    }

    @Override
    public void setRoaring(boolean roaring) {
        this.setFlag(2, roaring);
    }

    @Override
    public void roarIfPossible() {
        if (this.canRoar() && !this.level().isClientSide) {
            this.roarCounter = 1;
            this.setRoaring(true);
            this.playSound((SoundEvent)ModSounds.PSYCHO_BEAR_ROAR.get(), 6.0f, this.getVoicePitch());
            for (Player player : this.level().getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate((double)(((SoundEvent)ModSounds.PSYCHO_BEAR_ROAR.get()).getRange(6.0f) - 1.0f)))) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ScreenShakePayload(20.0f, 60), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public boolean canRoar() {
        return this.getActiveAttackType() == null && this.canPerformAction();
    }

    public void aiStep() {
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 7.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        super.aiStep();
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.moreFoodTicks > 0) {
            --this.moreFoodTicks;
        }
        if (this.itchReliefTicks > 0) {
            --this.itchReliefTicks;
        }
    }

    @Override
    public void tryToSit() {
        if (!this.isInWater()) {
            this.setZza(0.0f);
            this.getNavigation().stop();
            this.setSitting(true);
        }
    }

    @Override
    public boolean isSitting() {
        return this.getFlag(1);
    }

    @Override
    public void setSitting(boolean sitting) {
        this.setFlag(1, sitting);
    }

    @Override
    public boolean canPerformAction() {
        return !this.isEating() && !this.isSitting() && !this.isSleeping() && !this.isBackScratching();
    }

    @Override
    public boolean isEating() {
        return (Boolean)this.entityData.get(DATA_EATING);
    }

    @Override
    public void setEating(boolean eating) {
        this.entityData.set(DATA_EATING, (Object)eating);
    }

    @Override
    public ItemStack getItemInMouth() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    private void handleEating() {
        ItemStack eatItem = this.getItemInMouth();
        if (!this.isEating() && this.isSitting() && !eatItem.isEmpty() && !this.level().isClientSide) {
            if (DebugFlags.DEBUG_BEAR_EAT) {
                BlastFromThePast.LOGGER.info("Started eating animation for {}", (Object)this);
            }
            this.setEating(true);
        } else if (this.isEating() && (eatItem.isEmpty() && !this.isAboutToFinishEating() || !this.isSitting()) && !this.level().isClientSide) {
            if (DebugFlags.DEBUG_BEAR_EAT) {
                BlastFromThePast.LOGGER.info("Stopped in-progress {}/{} eating animation for {}", new Object[]{this.eatCounter, MAX_EAT_TIME, this});
            }
            this.setEating(false);
        }
        if (this.isEating()) {
            if (this.isChewing()) {
                this.addEatingParticles();
            }
            if (!this.level().isClientSide) {
                if (this.finishedChewing() && this.isFoodOrPacifier(eatItem)) {
                    if (this.isPacifier(eatItem)) {
                        this.setPacified(true);
                        this.setTarget(null);
                        if (this.lastFedPlayer != null) {
                            ModCriteriaTriggers.PACIFY_BEAR_TRIGGER.trigger((ServerPlayer)this.lastFedPlayer, this);
                        }
                    }
                    this.putItemInMouth(ItemStack.EMPTY, false);
                    this.gameEvent((Holder)GameEvent.EAT);
                    this.gotFood(40);
                    if (DebugFlags.DEBUG_BEAR_EAT) {
                        BlastFromThePast.LOGGER.info("Finished chewing part of eating animation for {}", (Object)this);
                    }
                } else if (this.finishedEating()) {
                    this.setSitting(false);
                    this.setEating(false);
                    if (DebugFlags.DEBUG_BEAR_EAT) {
                        BlastFromThePast.LOGGER.info("Finished eating animation for {}", (Object)this);
                    }
                }
            }
            ++this.eatCounter;
        }
    }

    private boolean finishedEating() {
        return this.eatCounter >= MAX_EAT_TIME;
    }

    private boolean isChewing() {
        return this.startedChewing() && !this.finishedChewing();
    }

    private boolean isAboutToFinishEating() {
        return this.finishedChewing() && this.eatCounter <= MAX_EAT_TIME;
    }

    private boolean finishedChewing() {
        return this.eatCounter >= FINISH_CHEWING_ACTION_POINT;
    }

    private boolean startedChewing() {
        return this.eatCounter >= START_CHEWING_ACTION_POINT;
    }

    public boolean isFoodOrPacifier(ItemStack stack) {
        return this.isFood(stack) || this.isPacifier(stack);
    }

    protected boolean isWantedItem(ItemEntity itemEntity) {
        return itemEntity.isAlive() && !itemEntity.hasPickUpDelay() && this.isFoodOrPacifier(itemEntity.getItem());
    }

    public boolean canTakeItem(ItemStack itemstack) {
        EquipmentSlot slotForItem = this.getEquipmentSlotForItem(itemstack);
        return this.getItemBySlot(slotForItem).isEmpty() && slotForItem == EquipmentSlot.MAINHAND && super.canTakeItem(itemstack);
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (this.getItemInMouth().isEmpty() && this.isWantedItem(itemEntity)) {
            this.onItemPickup(itemEntity);
            ItemStack item = itemEntity.getItem();
            this.putItemInMouth(item, true);
            this.take((Entity)itemEntity, item.getCount());
            itemEntity.discard();
        }
    }

    @Override
    public void putItemInMouth(ItemStack item, boolean guaranteeDrop) {
        this.setItemSlot(EquipmentSlot.MAINHAND, item);
        if (guaranteeDrop) {
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.setPersistenceRequired();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        if (!this.level().isClientSide) {
            this.clearStates();
        }
        return super.hurt(source, amount);
    }

    private void addEatingParticles() {
        if (this.eatCounter % 5 == 0) {
            this.playSound((SoundEvent)ModSounds.PSYCHO_BEAR_EAT.get(), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vec3 particleSpeedVec = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
                particleSpeedVec = particleSpeedVec.xRot(-this.getXRot() * ((float)Math.PI / 180));
                particleSpeedVec = particleSpeedVec.yRot(-this.getYRot() * ((float)Math.PI / 180));
                double randomYOffset = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
                Vec3 particlePosVec = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.8, randomYOffset, 1.0 + ((double)this.random.nextFloat() - 0.5) * 0.4);
                particlePosVec = particlePosVec.yRot(-this.yBodyRot * ((float)Math.PI / 180));
                particlePosVec = particlePosVec.add(this.getX(), this.getEyeY() + 1.0, this.getZ());
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInMouth()), particlePosVec.x, particlePosVec.y, particlePosVec.z, particleSpeedVec.x, particleSpeedVec.y + 0.05, particleSpeedVec.z);
            }
        }
    }

    public void travel(Vec3 travelVector) {
        if (!this.canMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            travelVector = travelVector.multiply(0.0, 1.0, 0.0);
        }
        super.travel(travelVector);
    }

    public boolean isAlliedTo(Entity other) {
        if (other == null) {
            return false;
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (this.isAlliedToDefault(other)) {
            return this.getTeam() == null && other.getTeam() == null;
        }
        return false;
    }

    protected boolean isAlliedToDefault(Entity other) {
        return other.getType().equals(this.getType());
    }

    protected SoundEvent getAmbientSound() {
        if (this.isSleeping()) {
            return (SoundEvent)ModSounds.PSYCHO_BEAR_SNORE.get();
        }
        return (SoundEvent)ModSounds.PSYCHO_BEAR_IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.PSYCHO_BEAR_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.PSYCHO_BEAR_HURT.get();
    }

    @Override
    public boolean isAllActionBlocked() {
        return !this.canPerformAction();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPacifiedData(compound);
        this.readAnimalStates(compound);
    }

    @Override
    public void readAnimalStates(CompoundTag compound) {
        if (compound.contains("Sleeping", 1)) {
            this.setSleepState(TransitioningState.byOrdinal(compound.getByte("Sleeping")));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.writePacifiedData(compound);
        this.writeAnimalStates(compound);
    }

    @Override
    public void writeAnimalStates(CompoundTag compound) {
        TransitioningState sleepState = this.getSleepState();
        if (!sleepState.isTransitional()) {
            compound.putByte("Sleeping", (byte)sleepState.ordinal());
        }
    }

    @Override
    public void setPacifiedTicks(int pacifiedTicks) {
        int previousPacifiedTicks = this.getPacifiedTicks();
        this.pacifiedTicks = pacifiedTicks;
        if (previousPacifiedTicks > 0 && pacifiedTicks <= 0 || previousPacifiedTicks <= 0 && pacifiedTicks > 0) {
            this.entityData.set(DATA_PACIFIED, (Object)(pacifiedTicks > 0 ? 1 : 0));
        }
    }

    @Override
    public int getPacifiedTicks() {
        if (this.level().isClientSide) {
            return (Boolean)this.entityData.get(DATA_PACIFIED) != false ? 1 : -1;
        }
        return this.pacifiedTicks;
    }

    @Override
    public boolean wantsMoreFood() {
        return this.moreFoodTicks <= 0 && !this.isWantedFood(this.getItemInMouth()) && !this.isEating();
    }

    @Override
    public void gotFood(int ticks) {
        this.moreFoodTicks = ticks;
    }

    @Override
    public boolean isWantedFood(ItemStack stack) {
        return this.isFoodOrPacifier(stack);
    }

    @Override
    public void takeFood(ItemStack stack) {
        this.putItemInMouth(stack, true);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        TransitioningState.transition(sleeping, this::getSleepState, this::setSleepState);
    }

    private void setSleepState(TransitioningState sleepState) {
        this.entityData.set(DATA_SLEEP_STATE, (Object)((byte)sleepState.ordinal()));
    }

    @Override
    public boolean isSleepingFlag() {
        return this.getSleepState() != TransitioningState.INACTIVE;
    }

    private TransitioningState getSleepState() {
        return TransitioningState.byOrdinal(((Byte)this.entityData.get(DATA_SLEEP_STATE)).byteValue());
    }

    public boolean isSleeping() {
        return this.isSleepingFlag();
    }

    @Override
    public void prepareToStartSleeping() {
        this.setSitting(false);
        this.setEating(false);
        this.setJumping(false);
    }

    @Override
    public boolean canSleep() {
        return this.level().isNight() && this.zza == 0.0f && this.hasShelter() && !this.alertable() && !this.isInPowderSnow && this.getTarget() == null && this.getLastDamageSource() == null;
    }

    @Override
    public boolean shouldFindShelter(boolean urgent) {
        if (urgent) {
            return this.level().isThundering() && this.level().canSeeSky(this.blockPosition());
        }
        return this.level().isNight() && this.level().canSeeSky(this.blockPosition()) && !((ServerLevel)this.level()).isVillage(this.blockPosition());
    }

    @Override
    public void clearStates() {
        this.setSitting(false);
        this.setEating(false);
        this.setSleeping(false);
        this.setBackScratching(false);
    }

    @Override
    public boolean canAnimateWalk() {
        if (this.isRoaring() || this.isBackScratching()) {
            return false;
        }
        return OverrideAnimatedAttacker.super.canAnimateWalk();
    }

    @Override
    public boolean canAnimateLook() {
        if (this.isRoaring() || this.isBackScratching() || this.isEating()) {
            return false;
        }
        return OverrideAnimatedAttacker.super.canAnimateLook();
    }

    protected boolean hasShelter() {
        BlockPos topOfSelfPos = BlockPos.containing((double)this.getX(), (double)this.getBoundingBox().maxY, (double)this.getZ());
        return EntityHelper.hasBlocksAbove((PathfinderMob)this, topOfSelfPos);
    }

    protected boolean alertable() {
        return false;
    }

    @Override
    public boolean isBackScratching() {
        return this.getBackScratchState() != TransitioningState.INACTIVE;
    }

    private TransitioningState getBackScratchState() {
        return TransitioningState.byOrdinal(((Byte)this.entityData.get(DATA_BACK_SCRATCH_STATE)).byteValue());
    }

    @Override
    public void setBackScratching(boolean backScratching) {
        TransitioningState.transition(backScratching, this::getBackScratchState, this::setBackScratchState);
    }

    @Override
    public boolean wantsToScratchBack() {
        return this.itchReliefTicks <= 0;
    }

    @Override
    public void scratchedBack() {
        this.itchReliefTicks = 100;
    }

    @Override
    public void playBackScratchSound() {
        this.makeSound((SoundEvent)ModSounds.PSYCHO_BEAR_SCRATCH.get());
    }

    @Override
    public void setPreparingToScratchBack(boolean prepare) {
        this.entityData.set(DATA_PREPARING_TO_SCRATCH_BACK, (Object)prepare);
    }

    @Override
    public boolean isPreparingToScratchBack() {
        return (Boolean)this.entityData.get(DATA_PREPARING_TO_SCRATCH_BACK);
    }

    private void setBackScratchState(TransitioningState backScratchState) {
        this.entityData.set(DATA_BACK_SCRATCH_STATE, (Object)((byte)backScratchState.ordinal()));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            PsychoBearAttackType activeAttackType = this.getActiveAttackType();
            if (!this.isBaby()) {
                if (this.isRoaring()) {
                    return state.setAndContinue(ROAR);
                }
                if (activeAttackType == PsychoBearAttackType.SLASH && !this.isLeftHanded()) {
                    return state.setAndContinue(ATTACK_FLIPPED);
                }
                if (activeAttackType == PsychoBearAttackType.SLASH && this.isLeftHanded()) {
                    return state.setAndContinue(ATTACK);
                }
                if (activeAttackType == null && this.isEating()) {
                    return state.setAndContinue(EAT);
                }
                if (activeAttackType == null && this.getSleepState() == TransitioningState.INACTIVE_TO_ACTIVE) {
                    return state.setAndContinue(SLEEP_START);
                }
                if (activeAttackType == null && this.getSleepState() == TransitioningState.ACTIVE) {
                    return state.setAndContinue(SLEEP);
                }
                if (activeAttackType == null && this.getSleepState() == TransitioningState.ACTIVE_TO_INACTIVE) {
                    return state.setAndContinue(SLEEP_END);
                }
                if (activeAttackType == null && this.getBackScratchState() == TransitioningState.INACTIVE_TO_ACTIVE) {
                    return state.setAndContinue(SCRATCH_START);
                }
                if (activeAttackType == null && this.getBackScratchState() == TransitioningState.ACTIVE) {
                    return state.setAndContinue(SCRATCH_LOOP);
                }
                if (activeAttackType == null && this.getBackScratchState() == TransitioningState.ACTIVE_TO_INACTIVE) {
                    return state.setAndContinue(SCRATCH_STOP);
                }
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.isBaby()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum PsychoBearAttackType implements AnimatedAttacker.AttackType<PsychoBearEntity, PsychoBearAttackType>
    {
        BITE(Mth.floor((float)7.6f), 20, DEFAULT_ATTACK_SIZE, 8.0f, 0.0f),
        SLASH(Mth.floor((float)7.6f), 20, DEFAULT_ATTACK_SIZE, 8.0f, 0.0f);

        private final int attackPoint;
        private final int attackDuration;
        private final Vec3 attackSize;
        private final float attackDamage;
        private final float attackKnockback;

        private PsychoBearAttackType(int attackPoint, int attackDuration, Vec3 attackSize, float attackDamage, float attackKnockback) {
            this.attackPoint = attackPoint;
            this.attackDuration = attackDuration;
            this.attackSize = attackSize;
            this.attackDamage = attackDamage;
            this.attackKnockback = attackKnockback;
        }

        @Override
        public void executeAttackPoint(PsychoBearEntity attacker, int attackTicker) {
            Vec3 attackSize = this.getAttackSize().scale((double)attacker.getScale());
            AABB attackBounds = HitboxHelper.createHitboxRelativeToFront((LivingEntity)attacker, attackSize.x(), attackSize.y(), attackSize.z());
            if (this == SLASH) {
                attacker.makeSound((SoundEvent)ModSounds.PSYCHO_BEAR_SLASH.get());
                EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), false);
            }
        }

        @Override
        public int getAttackPoint() {
            return this.attackPoint;
        }

        @Override
        public int getAttackDuration() {
            return this.attackDuration;
        }

        @Override
        public Vec3 getAttackSize() {
            return this.attackSize;
        }

        @Override
        public float getAttackDamage() {
            return this.attackDamage;
        }

        @Override
        public float getAttackKnockback() {
            return this.attackKnockback;
        }

        public static PsychoBearAttackType byOrdinal(int pOrdinal) {
            if (pOrdinal < 0 || pOrdinal > PsychoBearAttackType.values().length) {
                pOrdinal = 0;
            }
            return PsychoBearAttackType.values()[pOrdinal];
        }
    }
}

