/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import team.recrafted.blastfromthepast.entity.BurrelEntity;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;

public class BurrelEatGoal
extends TargetGoal {
    private final BurrelEntity burrel;
    private int unseenTicks;
    ItemEntity itemTarget;

    public BurrelEatGoal(BurrelEntity burrel) {
        super((Mob)burrel, true);
        this.burrel = burrel;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.burrel.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) && this.burrel.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getDuration() <= 40) {
            return false;
        }
        this.findTarget();
        return this.itemTarget != null;
    }

    public void start() {
        this.unseenTicks = 0;
        this.burrel.setTarget(null);
        this.burrel.setWantsToBeOnGround(true);
    }

    public void stop() {
        this.itemTarget = null;
        this.burrel.getNavigation().stop();
    }

    public void tick() {
        if (this.itemTarget == null || this.itemTarget.isRemoved()) {
            return;
        }
        float entityDistance = this.burrel.distanceTo((Entity)this.itemTarget);
        if ((double)entityDistance < 1.5) {
            this.burrel.makeSound((SoundEvent)ModSounds.BURREL_EAT.get());
            this.burrel.triggerAnim("second", "eat");
            this.itemTarget.discard();
            this.burrel.getNavigation().stop();
            this.burrel.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 255, false, false, false));
        }
    }

    protected void findTarget() {
        List itemEntityList = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.burrel.getBoundingBox().inflate(20.0, 30.0, 20.0), livingEntity -> true);
        ItemEntity targetCandidate = null;
        float distance = 0.0f;
        for (ItemEntity entry : itemEntityList) {
            if (!this.burrel.isFood(entry.getItem()) && !entry.getItem().is(ModItems.SAP_BALL) || !this.burrel.hasLineOfSight((Entity)entry)) continue;
            float entityDistance = this.burrel.distanceTo((Entity)entry);
            if ((double)entityDistance < 1.5) {
                this.burrel.makeSound((SoundEvent)ModSounds.BURREL_EAT.get());
                this.burrel.triggerAnim("second", "eat");
                this.burrel.getNavigation().stop();
                entry.discard();
                this.burrel.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 255, false, false, false));
                return;
            }
            if (targetCandidate != null && !(entityDistance < distance)) continue;
            targetCandidate = entry;
            distance = this.burrel.distanceTo((Entity)entry);
        }
        this.itemTarget = targetCandidate;
        if (targetCandidate != null) {
            this.burrel.getNavigation().moveTo((Entity)this.itemTarget, 1.0);
            this.burrel.getLookControl().setLookAt((Entity)this.itemTarget);
        }
    }

    public boolean canContinueToUse() {
        if (this.itemTarget == null || this.itemTarget.isRemoved() || !this.burrel.hasLineOfSight((Entity)this.itemTarget)) {
            this.findTarget();
            if (this.itemTarget == null || this.itemTarget.isRemoved()) {
                return false;
            }
        }
        double d = this.getFollowDistance();
        if (this.mob.distanceToSqr((Entity)this.itemTarget) > d * d) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.getSensing().hasLineOfSight((Entity)this.itemTarget)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > BurrelEatGoal.reducedTickDelay((int)this.unseenMemoryTicks)) {
                return false;
            }
        }
        return true;
    }
}

