/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import team.recrafted.blastfromthepast.client.init.ModLayerLocations;
import team.recrafted.blastfromthepast.client.layers.FrostbiteAntlersLayer;

@EventBusSubscriber(value={Dist.CLIENT}, modid="blastfromthepast", bus=EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModLayerLocations.ANTLERS, FrostbiteAntlersLayer.AntlersModel::createHeadLayer);
    }

    @SubscribeEvent
    public static void construct(EntityRenderersEvent.AddLayers event) {
        ClientEvents.addLayerToHumanoid(event, EntityType.ARMOR_STAND, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.ZOMBIE, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.SKELETON, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.HUSK, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.DROWNED, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.STRAY, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToPlayerSkin(event, PlayerSkin.Model.SLIM, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToPlayerSkin(event, PlayerSkin.Model.WIDE, FrostbiteAntlersLayer::new);
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, PlayerSkin.Model skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(skinName);
        if (renderer != null) {
            renderer.addLayer(factory.apply(renderer));
        }
    }

    private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayerToHumanoid(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = (LivingEntityRenderer)event.getRenderer(entityType);
        if (renderer != null) {
            renderer.addLayer(factory.apply(renderer));
        }
    }
}

