/*
 * Decompiled with CFR 0.152.
 */
package com.yanghao.effect_display.gui.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanghao.effect_display.EffectDisplayConfig;
import com.yanghao.effect_display.gui.config.ConfigLabel;
import com.yanghao.effect_display.network.ClientEntityEffectsStorage;
import com.yanghao.effect_display.utils.EffectRenderUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class RenderConfigScreen
extends Screen {
    private static final Logger log = LoggerFactory.getLogger(RenderConfigScreen.class);
    private double originalHorizontalOffset;
    private double originalVerticalOffset;
    private double originalRenderScale;
    private LivingEntity previewEntity;
    private ExtendedSlider entitySizeSlider;
    private float previewYaw = 0.0f;
    private float entitySize = 60.0f;
    private float rotationOffset = 0.1f;
    private PoseStack poseStack;
    private static final double POSITION_STEP = 0.1;
    private int previewLeft;
    private int previewTop;
    private int previewWidth;
    private int previewHeight;
    private int selectedEntityIndex = 0;
    private final List<EntityType<?>> previewEntities = RenderConfigScreen.getAllEntityTypes();
    private CycleButton<Integer> entitySelectorButton;

    public RenderConfigScreen(Component title) {
        super(title);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void init() {
        this.originalHorizontalOffset = (Double)EffectDisplayConfig.HORIZONTAL_OFFSET.get();
        this.originalVerticalOffset = (Double)EffectDisplayConfig.VERTICAL_OFFSET.get();
        this.originalRenderScale = (Double)EffectDisplayConfig.RENDER_SCALE.get();
        this.previewWidth = Math.min(this.width / 2, 300);
        this.previewHeight = 200;
        this.previewLeft = (this.width - this.previewWidth) / 2;
        this.previewTop = 40;
        int controlLeft = 20;
        int controlTop = this.previewTop + this.previewHeight + 20;
        this.addControlSection(controlLeft, controlTop, Component.translatable((String)"effect_display.render_config.position_offset").getString(), () -> (Double)EffectDisplayConfig.HORIZONTAL_OFFSET.get(), v -> EffectDisplayConfig.HORIZONTAL_OFFSET.set(v), () -> (Double)EffectDisplayConfig.VERTICAL_OFFSET.get(), v -> EffectDisplayConfig.VERTICAL_OFFSET.set(v));
        CycleButton<Integer> cycleButton = this.addEntitySelector(this.width / 2 - 75, controlTop);
        this.entitySizeSlider = new ExtendedSlider(this.width / 2 - 75, controlTop + 25, 150, 20, (Component)Component.translatable((String)"effect_display.render_config.preview_entity_scale"), (Component)Component.literal((String)""), 0.1, 2.0, 1.0, 0.01, 4, true){

            protected void applyValue() {
                RenderConfigScreen.this.entitySize = (float)(60.0 * this.getValue());
            }
        };
        this.addRenderableWidget((GuiEventListener)this.entitySizeSlider);
        ExtendedSlider scaleSlider = new ExtendedSlider(this, this.width / 2 - 75, controlTop + 50, 150, 20, (Component)Component.translatable((String)"effect_display.render_config.buff_scale"), (Component)Component.literal((String)""), 0.1, 2.0, (Double)EffectDisplayConfig.RENDER_SCALE.get(), 0.01, 4, true){

            protected void applyValue() {
                EffectDisplayConfig.RENDER_SCALE.set((Object)this.getValue());
            }
        };
        this.addRenderableWidget((GuiEventListener)scaleSlider);
        this.createPreviewEntity(cycleButton);
        MutableComponent text = Component.translatable((String)"effect_display.render_config.entity_rotation");
        Checkbox checkbox = Checkbox.builder((Component)text, (Font)this.font).pos(cycleButton.getX() + cycleButton.getWidth() + 10, cycleButton.getY()).maxWidth(20).onValueChange((bth, booleanValue) -> {
            if (!booleanValue) {
                this.poseStack.mulPose(new Quaternionf().rotateY(0.0f));
                this.previewYaw = 0.0f;
                this.rotationOffset = 0.0f;
            } else {
                this.rotationOffset = 0.1f;
            }
        }).selected(true).build();
        checkbox.setHeight(20);
        this.addRenderableWidget((GuiEventListener)checkbox);
        int bottom = this.height - 30;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.save"), btn -> {
            EffectDisplayConfig.savaNoGUIBuilder();
            this.originalHorizontalOffset = (Double)EffectDisplayConfig.HORIZONTAL_OFFSET.get();
            this.originalVerticalOffset = (Double)EffectDisplayConfig.VERTICAL_OFFSET.get();
            this.originalRenderScale = (Double)EffectDisplayConfig.RENDER_SCALE.get();
        }).pos(this.width / 2 - 130, bottom).size(80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.reset"), btn -> {
            this.resetConfig();
            scaleSlider.setValue(EffectDisplayConfig.getRenderScale());
        }).pos(this.width / 2 - 40, bottom).size(80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.cancel"), btn -> this.onClose()).pos(this.width / 2 + 50, bottom).size(80, 20).build());
    }

    private void createPreviewEntity(CycleButton<Integer> cycleButton) {
        if (this.previewEntity != null) {
            ClientEntityEffectsStorage.removeEntityEffects(this.previewEntity.getId());
            this.previewEntity.discard();
            this.previewEntity = null;
        }
        int attempts = 0;
        int maxAttempts = this.previewEntities.size();
        int originalIndex = this.selectedEntityIndex;
        while (this.previewEntity == null && attempts < maxAttempts) {
            this.selectedEntityIndex = (originalIndex + attempts) % this.previewEntities.size();
            EntityType<?> entityType = this.previewEntities.get(this.selectedEntityIndex);
            if (this.minecraft != null && this.minecraft.level != null) {
                this.previewEntity = (LivingEntity)entityType.create((Level)this.minecraft.level);
            }
            if (this.previewEntity != null) continue;
            ++attempts;
        }
        if (cycleButton != null && this.previewEntity != null) {
            cycleButton.setValue((Object)this.selectedEntityIndex);
        } else if (this.entitySelectorButton != null && this.previewEntity != null) {
            this.entitySelectorButton.setValue((Object)this.selectedEntityIndex);
        }
        if (this.previewEntity != null) {
            if (EffectRenderUtil.isWarframeModLoaded()) {
                // empty if block
            }
            ClientEntityEffectsStorage.updateEntityEffects(this.previewEntity.getId(), Arrays.asList(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, 0), new MobEffectInstance(MobEffects.JUMP, 100, 1)));
            this.previewEntity.setYRot(0.0f);
            this.previewEntity.setYBodyRot(0.0f);
        }
    }

    private void addControlSection(int x, int y, String title, Supplier<Double> horizontalSupplier, Consumer<Double> horizontalConsumer, Supplier<Double> verticalSupplier, Consumer<Double> verticalConsumer) {
        this.addRenderableWidget((GuiEventListener)new ConfigLabel(x, y - 20, 100, 20, () -> title));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.up"), btn -> this.adjustValue(verticalSupplier, verticalConsumer, 0.1)).pos(x + 70, y).size(30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.down"), btn -> this.adjustValue(verticalSupplier, verticalConsumer, -0.1)).pos(x + 70, y + 50).size(30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.left"), btn -> this.adjustValue(horizontalSupplier, horizontalConsumer, -0.1)).pos(x + 20, y + 25).size(30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"effect_display.render_config.right"), btn -> this.adjustValue(horizontalSupplier, horizontalConsumer, 0.1)).pos(x + 120, y + 25).size(30, 20).build());
        this.addRenderableWidget((GuiEventListener)new ConfigLabel(x + 70, y + 25, 60, 20, () -> String.format(Component.translatable((String)"effect_display.render_config.x_value").getString(), (double)Math.round((Double)horizontalSupplier.get() * 10000.0) / 10000.0)));
        this.addRenderableWidget((GuiEventListener)new ConfigLabel(x + 70, y + 25 + 20 - 9, 60, 20, () -> String.format(Component.translatable((String)"effect_display.render_config.y_value").getString(), (double)Math.round((Double)verticalSupplier.get() * 10000.0) / 10000.0)));
    }

    private CycleButton<Integer> addEntitySelector(int x, int y) {
        CycleButton cycleButton = CycleButton.builder(value -> {
            EntityType<?> entityType = this.previewEntities.get((int)value);
            return Component.literal((String)String.format(Component.translatable((String)"effect_display.render_config.preview_entity").getString(), entityType.getDescription().getString()));
        }).withValues((Object[])((Integer[])IntStream.range(0, this.previewEntities.size()).boxed().toArray(Integer[]::new))).withInitialValue((Object)this.selectedEntityIndex).displayOnlyValue().create(x, y, 150, 20, (Component)Component.translatable((String)"effect_display.render_config.entity_type"), (btn, value) -> {
            this.selectedEntityIndex = value;
            this.createPreviewEntity((CycleButton<Integer>)btn);
        });
        this.addRenderableWidget((GuiEventListener)cycleButton);
        this.entitySelectorButton = cycleButton;
        return cycleButton;
    }

    private void adjustValue(Supplier<Double> supplier, Consumer<Double> consumer, double amount) {
        double newValue = supplier.get() + amount;
        consumer.accept(newValue);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.poseStack = guiGraphics.pose();
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.fill(this.previewLeft - 1, this.previewTop - 1, this.previewLeft + this.previewWidth + 1, this.previewTop + this.previewHeight + 1, 0xFFFFFF);
        guiGraphics.fill(this.previewLeft, this.previewTop, this.previewLeft + this.previewWidth, this.previewTop + this.previewHeight, 0xFFFFFF);
        guiGraphics.fill(10, this.previewTop + this.previewHeight + 10, this.width - 10, this.height - 40, -2145378272);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.previewEntity != null) {
            this.renderPreviewEntity(guiGraphics.pose(), partialTick);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"effect_display.render_config.buff_preview"), this.previewLeft, this.previewTop - 10, -1, false);
    }

    private void renderPreviewEntity(PoseStack poseStack, float partialTick) {
        if (this.previewEntity == null) {
            return;
        }
        if (this.minecraft != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            poseStack.pushPose();
            int entityX = this.previewLeft + this.previewWidth / 2;
            int entityY = this.previewTop + this.previewHeight - 10;
            this.previewYaw += this.rotationOffset;
            poseStack.translate((double)entityX, (double)entityY, 50.0);
            poseStack.scale(1.0f, -1.0f, 1.0f);
            poseStack.scale(this.entitySize, this.entitySize, this.entitySize);
            PoseStack effectPoseStack = new PoseStack();
            effectPoseStack.mulPose(poseStack.last().pose());
            EntityRenderDispatcher entityRenderDispatcher = this.minecraft.getEntityRenderDispatcher();
            Camera mainCamera = this.minecraft.gameRenderer.getMainCamera();
            MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
            EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer((Entity)this.previewEntity);
            List<MobEffectInstance> entityEffects = ClientEntityEffectsStorage.getEntityEffects(this.previewEntity.getId());
            if (this.minecraft != null) {
                EffectRenderUtil.renderAllMobEffects((Entity)this.previewEntity, effectPoseStack, (MultiBufferSource)bufferSource, mainCamera, (EntityRenderer<? super Entity>)entityRenderer, partialTick, 0.0, 0.0, 0.0, entityEffects, true);
                EffectRenderUtil.renderHealthBar((Entity)this.previewEntity, effectPoseStack, (MultiBufferSource)bufferSource, mainCamera, (EntityRenderer<? super Entity>)entityRenderer, partialTick, 0.0, 0.0, 0.0);
            }
            poseStack.pushPose();
            poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI / 180 * this.previewYaw));
            entityRenderer.render((Entity)this.previewEntity, 0.0f, partialTick, poseStack, (MultiBufferSource)this.minecraft.renderBuffers().bufferSource(), 0xF000F0);
            poseStack.popPose();
            if (this.minecraft != null) {
                this.minecraft.renderBuffers().bufferSource().endBatch();
            }
            poseStack.popPose();
        }
    }

    private void resetConfig() {
        this.entitySize = 60.0f;
        this.entitySizeSlider.setValue(1.0);
        EffectDisplayConfig.RENDER_SCALE.set((Object)1.0);
        EffectDisplayConfig.VERTICAL_OFFSET.set((Object)0.0);
        EffectDisplayConfig.HORIZONTAL_OFFSET.set((Object)0.0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.previewLeft && mouseX < (double)(this.previewLeft + this.previewWidth) && mouseY >= (double)this.previewTop && mouseY < (double)(this.previewTop + this.previewHeight)) {
            this.previewYaw = 0.0f;
            return true;
        }
        if (this.entitySelectorButton != null && button == 1 && mouseX >= (double)this.entitySelectorButton.getX() && mouseX < (double)(this.entitySelectorButton.getX() + this.entitySelectorButton.getWidth()) && mouseY >= (double)this.entitySelectorButton.getY() && mouseY < (double)(this.entitySelectorButton.getY() + this.entitySelectorButton.getHeight())) {
            int currentValue = (Integer)this.entitySelectorButton.getValue();
            int newValue = (currentValue - 1 + this.previewEntities.size()) % this.previewEntities.size();
            this.entitySelectorButton.setValue((Object)newValue);
            this.selectedEntityIndex = newValue;
            this.createPreviewEntity(this.entitySelectorButton);
            if (this.minecraft != null) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClose() {
        EffectDisplayConfig.HORIZONTAL_OFFSET.set((Object)this.originalHorizontalOffset);
        EffectDisplayConfig.VERTICAL_OFFSET.set((Object)this.originalVerticalOffset);
        EffectDisplayConfig.RENDER_SCALE.set((Object)this.originalRenderScale);
        if (this.previewEntity != null) {
            ClientEntityEffectsStorage.removeEntityEffects(this.previewEntity.getId());
            this.previewEntity.discard();
            this.previewEntity = null;
        }
        super.onClose();
    }

    public static List<EntityType<?>> getAllEntityTypes() {
        ArrayList types = new ArrayList();
        try {
            Field[] fields;
            Class<?> clazz = Class.forName("net.minecraft.world.entity.EntityType");
            for (Field field : fields = clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || field.getType() != EntityType.class) continue;
                EntityType entityType = (EntityType)field.get(null);
                if (Minecraft.getInstance().level == null || !(entityType.create((Level)Minecraft.getInstance().level) instanceof LivingEntity)) continue;
                types.add(entityType);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            e.printStackTrace();
        }
        return types;
    }
}

