/*
 * Decompiled with CFR 0.152.
 */
package com.yanghao.effect_display.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanghao.effect_display.network.ClientEntityEffectsStorage;
import com.yanghao.effect_display.utils.EffectRenderUtil;
import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public class LivingEntityRendererMixin {
    private static final Logger log = LoggerFactory.getLogger(LivingEntityRendererMixin.class);
    @Shadow
    @Final
    private EntityRenderDispatcher entityRenderDispatcher;

    @Inject(method={"renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", shift=At.Shift.AFTER)})
    private void renderMobEffectsAboveHead(Entity entity, double camX, double camY, double camZ, float partialTick, PoseStack poseStack, MultiBufferSource buffers, CallbackInfo ci) {
        double d0 = Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX());
        double d1 = Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY());
        double d2 = Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Level level = entity.level();
            if (level.isClientSide && ClientEntityEffectsStorage.hasEntityEffects(entity.getId())) {
                List<MobEffectInstance> effects = ClientEntityEffectsStorage.getEntityEffects(entity.getId());
                if (effects == null || effects.isEmpty()) {
                    ClientEntityEffectsStorage.removeEntityEffects(entity.getId());
                    return;
                }
                EffectRenderUtil.renderAllMobEffects(entity, poseStack, buffers, this.entityRenderDispatcher.camera, (EntityRenderer<? super Entity>)this.entityRenderDispatcher.getRenderer(entity), partialTick, d0 - camX, d1 - camY, d2 - camZ, effects, false);
            }
        }
    }
}

