/*
 * Decompiled with CFR 0.152.
 */
package com.yanghao.effect_display.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffectInstance;

public class ClientEntityEffectsStorage {
    private static final Map<Integer, List<MobEffectInstance>> entityEffects = new HashMap<Integer, List<MobEffectInstance>>();

    public static void updateEntityEffects(int entityId, List<MobEffectInstance> newEffects) {
        List<MobEffectInstance> currentEffects = entityEffects.get(entityId);
        if (currentEffects == null || currentEffects.isEmpty()) {
            entityEffects.put(entityId, new ArrayList<MobEffectInstance>(newEffects));
            return;
        }
        ArrayList<MobEffectInstance> mergedEffects = new ArrayList<MobEffectInstance>(currentEffects);
        for (MobEffectInstance newEffect : newEffects) {
            boolean effectExists = false;
            for (int i = 0; i < mergedEffects.size(); ++i) {
                MobEffectInstance existingEffect2 = (MobEffectInstance)mergedEffects.get(i);
                if (!existingEffect2.getEffect().equals((Object)newEffect.getEffect())) continue;
                mergedEffects.set(i, newEffect);
                effectExists = true;
                break;
            }
            if (effectExists) continue;
            mergedEffects.add(newEffect);
        }
        mergedEffects.removeIf(existingEffect -> newEffects.stream().noneMatch(newEffect -> newEffect.getEffect().equals((Object)existingEffect.getEffect())));
        entityEffects.put(entityId, mergedEffects);
    }

    public static List<MobEffectInstance> getEntityEffects(int entityId) {
        return entityEffects.getOrDefault(entityId, new ArrayList());
    }

    public static void removeEntityEffects(int entityId) {
        entityEffects.remove(entityId);
    }

    public static boolean hasEntityEffects(int entityId) {
        return entityEffects.containsKey(entityId);
    }

    public static void clearAll() {
        entityEffects.clear();
    }
}

