/*
 * Decompiled with CFR 0.152.
 */
package com.yanghao.effect_display.network;

import com.yanghao.effect_display.network.ClientEntityEffectsStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="effect_display")
public record SyncEntityEffectsMessage(int entityId, List<MobEffectInstance> effects) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"effect_display", (String)"sync_entity_effects");
    public static final StreamCodec<FriendlyByteBuf, SyncEntityEffectsMessage> STREAM_CODEC = StreamCodec.ofMember(SyncEntityEffectsMessage::encode, SyncEntityEffectsMessage::new);
    public static final CustomPacketPayload.Type<SyncEntityEffectsMessage> TYPE = new CustomPacketPayload.Type(ID);

    public SyncEntityEffectsMessage(FriendlyByteBuf buf) {
        this(buf.readInt(), SyncEntityEffectsMessage.readEffects(buf));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.effects.size());
        for (MobEffectInstance effect : this.effects) {
            SyncEntityEffectsMessage.writeEffectInstance(buf, effect);
        }
    }

    private static List<MobEffectInstance> readEffects(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(size);
        for (int i = 0; i < size; ++i) {
            MobEffectInstance effect = SyncEntityEffectsMessage.readEffectInstance(buf);
            if (effect == null) continue;
            effects.add(effect);
        }
        return effects;
    }

    private static MobEffectInstance readEffectInstance(FriendlyByteBuf buf) {
        CompoundTag tag = buf.readNbt();
        if (tag != null) {
            return MobEffectInstance.load((CompoundTag)tag);
        }
        return null;
    }

    private static void writeEffectInstance(FriendlyByteBuf buf, MobEffectInstance effect) {
        buf.writeNbt(effect.save());
    }

    public static SyncEntityEffectsMessage decode(FriendlyByteBuf buf) {
        return new SyncEntityEffectsMessage(buf);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level level;
            Entity entity;
            Player player = ctx.player();
            if (player != null && (entity = (level = player.level()).getEntity(this.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.effects.isEmpty()) {
                    ClientEntityEffectsStorage.removeEntityEffects(this.entityId);
                } else {
                    ClientEntityEffectsStorage.updateEntityEffects(this.entityId, this.effects);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getEntity().level().isClientSide() && event.getTarget() instanceof LivingEntity && event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            LivingEntity targetEntity = (LivingEntity)event.getTarget();
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(targetEntity.getActiveEffects());
            if (effects.isEmpty()) {
                return;
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncEntityEffectsMessage(targetEntity.getId(), effects), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void updateAllEntityEffects(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide && entity.level() instanceof ServerLevel) {
            ArrayList<MobEffectInstance> currentEffects = new ArrayList<MobEffectInstance>(entity.getActiveEffects());
            boolean effectExists = currentEffects.stream().anyMatch(effect -> effect.getEffect().equals((Object)Objects.requireNonNull(event.getEffectInstance()).getEffect()));
            if (!effectExists) {
                currentEffects.add(event.getEffectInstance());
            }
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncEntityEffectsMessage(entity.getId(), new ArrayList<MobEffectInstance>(currentEffects)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void updateAllEntityEffects(MobEffectEvent.Remove event) {
        SyncEntityEffectsMessage.syncEffectsAfterRemoval(event.getEffectInstance(), event.getEntity());
    }

    @SubscribeEvent
    public static void updateAllEntityEffects(MobEffectEvent.Expired event) {
        LivingEntity target = event.getEntity();
        SyncEntityEffectsMessage.syncEffectsAfterRemoval(event.getEffectInstance(), target);
    }

    public static void syncEffectsAfterRemoval(MobEffectInstance effectInstance, LivingEntity entity2) {
        if (!entity2.level().isClientSide()) {
            LivingEntity entity = entity2;
            List<MobEffectInstance> effects = entity.getActiveEffects().stream().filter(effect -> effect.getEffect().value() != effectInstance.getEffect().value()).toList();
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncEntityEffectsMessage(entity.getId(), effects), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

