/*
 * Decompiled with CFR 0.152.
 */
package com.yanghao.effect_display.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.yanghao.effect_display.EffectDisplayConfig;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class EffectRenderUtil {
    private static final ResourceLocation HEALTH_BAR_TEXTURE = EffectRenderUtil.isNeatModLoaded() ? ResourceLocation.fromNamespaceAndPath((String)"neat", (String)"textures/ui/health_bar_texture.png") : null;
    private static final RenderType HEALTH_BAR_RENDER_TYPE = EffectRenderUtil.createHealthBarRenderType();

    private static RenderType createHealthBarRenderType() {
        if (HEALTH_BAR_TEXTURE == null) {
            return null;
        }
        RenderType.CompositeState renderTypeState = RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(HEALTH_BAR_TEXTURE, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false);
        return RenderType.create((String)"warframe_health_bar", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)renderTypeState);
    }

    public static void renderHealthBar(Entity entity, PoseStack poseStack, MultiBufferSource buffers, Camera camera, EntityRenderer<? super Entity> entityRenderer, float partialTicks, double x, double y, double z) {
        if (!EffectRenderUtil.isNeatModLoaded()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        float textScale = 0.5f;
        int barHeight = 4;
        String name = living.getDisplayName().getString();
        float nameLen = (float)Minecraft.getInstance().font.width(name) * 0.5f;
        float halfSize = Math.max(20.0f, nameLen / 2.0f + 10.0f);
        Vec3 renderOffset = entityRenderer.getRenderOffset(entity, partialTicks);
        double d2 = x + renderOffset.x();
        double d3 = y + renderOffset.y();
        double d0 = z + renderOffset.z();
        poseStack.pushPose();
        poseStack.translate(d2, d3, d0);
        Vec3 attachmentPoint = entity.getAttachments().get(EntityAttachment.NAME_TAG, 0, entity.getViewYRot(partialTicks));
        poseStack.translate(attachmentPoint.x, attachmentPoint.y + (double)0.6f, attachmentPoint.z);
        poseStack.mulPose(new Quaternionf());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.pushPose();
        poseStack.scale(-0.0267f, -0.0267f, 0.0267f);
        float padding = 2.0f;
        int bgHeight = 6;
        VertexConsumer builder = buffers.getBuffer(HEALTH_BAR_RENDER_TYPE);
        builder.addVertex(poseStack.last().pose(), -halfSize - padding, (float)(-bgHeight), 0.01f).setColor(0, 0, 0, 60).setUv(0.0f, 0.0f).setLight(0xF000F0);
        builder.addVertex(poseStack.last().pose(), -halfSize - padding, 4.0f + padding, 0.01f).setColor(0, 0, 0, 60).setUv(0.0f, 0.5f).setLight(0xF000F0);
        builder.addVertex(poseStack.last().pose(), halfSize + padding, 4.0f + padding, 0.01f).setColor(0, 0, 0, 60).setUv(1.0f, 0.5f).setLight(0xF000F0);
        builder.addVertex(poseStack.last().pose(), halfSize + padding, (float)(-bgHeight), 0.01f).setColor(0, 0, 0, 60).setUv(1.0f, 0.0f).setLight(0xF000F0);
        int argb = EffectRenderUtil.getHealthColor(living);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float maxHealth = Math.max(living.getHealth(), living.getMaxHealth());
        float healthHalfSize = halfSize * (living.getHealth() / maxHealth);
        VertexConsumer builder2 = buffers.getBuffer(HEALTH_BAR_RENDER_TYPE);
        builder2.addVertex(poseStack.last().pose(), -halfSize, 0.0f, 0.001f).setColor(r, g, b, 127).setUv(0.0f, 0.75f).setLight(0xF000F0);
        builder2.addVertex(poseStack.last().pose(), -halfSize, 4.0f, 0.001f).setColor(r, g, b, 127).setUv(0.0f, 1.0f).setLight(0xF000F0);
        builder2.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, 4.0f, 0.001f).setColor(r, g, b, 127).setUv(1.0f, 1.0f).setLight(0xF000F0);
        builder2.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).setColor(r, g, b, 127).setUv(1.0f, 0.75f).setLight(0xF000F0);
        if (healthHalfSize < halfSize) {
            builder2.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).setColor(0, 0, 0, 127).setUv(0.0f, 0.5f).setLight(0xF000F0);
            builder2.addVertex(poseStack.last().pose(), -halfSize + 2.0f * healthHalfSize, 4.0f, 0.001f).setColor(0, 0, 0, 127).setUv(0.0f, 0.75f).setLight(0xF000F0);
            builder2.addVertex(poseStack.last().pose(), halfSize, 4.0f, 0.001f).setColor(0, 0, 0, 127).setUv(1.0f, 0.75f).setLight(0xF000F0);
            builder2.addVertex(poseStack.last().pose(), halfSize, 0.0f, 0.001f).setColor(0, 0, 0, 127).setUv(1.0f, 0.5f).setLight(0xF000F0);
        }
        int textColor = 0xFFFFFF;
        boolean black = false;
        poseStack.pushPose();
        poseStack.translate(-halfSize, -4.5f, 0.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        Minecraft.getInstance().font.drawInBatch(name, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
        float healthValueTextScale = 0.375f;
        poseStack.pushPose();
        poseStack.translate(-halfSize, -4.5f, 0.0f);
        poseStack.scale(0.375f, 0.375f, 0.375f);
        int h = 14;
        DecimalFormat health_format = new DecimalFormat("#.##");
        String hpStr = health_format.format(living.getHealth());
        Minecraft.getInstance().font.drawInBatch(hpStr, 2.0f, (float)h, 0xFFFFFF, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        String maxHpStr = health_format.format(living.getMaxHealth());
        Minecraft.getInstance().font.drawInBatch(maxHpStr, (float)((int)(halfSize / 0.375f * 2.0f) - Minecraft.getInstance().font.width(maxHpStr) - 2), (float)h, 0xFFFFFF, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        String percStr = (int)(100.0f * living.getHealth() / living.getMaxHealth()) + "%";
        Minecraft.getInstance().font.drawInBatch(percStr, (float)((int)(halfSize / 0.375f)) - (float)Minecraft.getInstance().font.width(percStr) / 2.0f, (float)h, 0xFFFFFF, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
        poseStack.popPose();
    }

    public static void renderAllMobEffects(Entity entity, PoseStack poseStack, MultiBufferSource buffers, Camera camera, EntityRenderer<? super Entity> entityRenderer, float partialTicks, double x, double y, double z, List<MobEffectInstance> effects, boolean isGuiEnvironment) {
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        Vec3 renderOffset = entityRenderer.getRenderOffset(entity, partialTicks);
        double d2 = x + renderOffset.x();
        double d3 = y + renderOffset.y();
        double d0 = z + renderOffset.z();
        poseStack.pushPose();
        poseStack.translate(d2, d3, d0);
        poseStack.translate(0.0, (double)EffectRenderUtil.getVerticalOffset(entity), 0.0);
        if (isGuiEnvironment) {
            poseStack.mulPose(new Quaternionf());
        } else {
            poseStack.mulPose(camera.rotation());
        }
        poseStack.translate(EffectDisplayConfig.getHorizontalOffset(), 0.0, 0.0);
        poseStack.mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(180.0), 0.0f, 1.0f, 0.0f)));
        poseStack.scale(-0.0267f, -0.0267f, 0.0267f);
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        float iconWidth = 10.0f * (float)EffectDisplayConfig.getRenderScale();
        float iconHeight = 10.0f * (float)EffectDisplayConfig.getRenderScale();
        float iconSpacing = 2.0f;
        float entityWidthInBlocks = entity.getBbWidth();
        float entityWidthInRenderUnits = entityWidthInBlocks / 0.0267f;
        float maxAllowedWidth = entityWidthInRenderUnits * 3.0f;
        int maxIconsPerRow = (int)Math.floor((maxAllowedWidth + iconSpacing) / (iconWidth + iconSpacing));
        if (maxIconsPerRow < 1) {
            maxIconsPerRow = 1;
        }
        int totalRows = (int)Math.ceil((double)effects.size() / (double)maxIconsPerRow);
        float rowSpacing = iconHeight + 2.0f;
        for (int row = 0; row < totalRows; ++row) {
            int startIndex = row * maxIconsPerRow;
            int endIndex = Math.min(startIndex + maxIconsPerRow, effects.size());
            int iconsInCurrentRow = endIndex - startIndex;
            float currentRowWidth = (float)iconsInCurrentRow * iconWidth + (float)(iconsInCurrentRow - 1) * iconSpacing;
            float startX = -currentRowWidth / 2.0f + iconWidth / 2.0f;
            float currentRowY = (float)(-row) * rowSpacing;
            for (int i = startIndex; i < endIndex; ++i) {
                MobEffectInstance effectInstance = effects.get(i);
                Holder effectHolder = effectInstance.getEffect();
                TextureAtlasSprite sprite = minecraft.getMobEffectTextures().get(effectHolder);
                float halfWidth = iconWidth / 2.0f;
                float halfHeight = iconHeight / 2.0f;
                PoseStack iconPoseStack = new PoseStack();
                iconPoseStack.mulPose(poseStack.last().pose());
                int iconIndexInRow = i - startIndex;
                float iconX = startX + (float)iconIndexInRow * (iconWidth + iconSpacing);
                iconPoseStack.translate(iconX, currentRowY, 0.0f);
                float backgroundOpacity = 0.25f;
                font.drawInBatch("", -halfWidth, -halfHeight, (int)(backgroundOpacity * 255.0f) << 24, false, iconPoseStack.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                try {
                    RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(sprite.atlasLocation(), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(false);
                    RenderType.CompositeRenderType renderType = RenderType.create((String)"buffered_effect_icon", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (RenderType.CompositeState)state);
                    VertexConsumer buffer = buffers.getBuffer((RenderType)renderType);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    Matrix4f iconMatrix = iconPoseStack.last().pose();
                    buffer.addVertex(iconMatrix, -halfWidth, -halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV0()).setUv1(0, 10).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
                    buffer.addVertex(iconMatrix, -halfWidth, halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV1()).setUv1(0, 10).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
                    buffer.addVertex(iconMatrix, halfWidth, halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV1()).setUv1(0, 10).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
                    buffer.addVertex(iconMatrix, halfWidth, -halfHeight, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV0()).setUv1(0, 10).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
                }
                catch (Exception e) {
                    String text = effectInstance.getDescriptionId();
                    float scaledTextWidth = font.width(text);
                    float textHalfSize = scaledTextWidth / 2.0f;
                    font.drawInBatch(text, -textHalfSize, 0.0f, (int)(backgroundOpacity * 255.0f) << 24, false, iconPoseStack.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                    font.drawInBatch(text, -textHalfSize, 0.0f, 0xFF0000, false, iconPoseStack.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                }
                String levelText = "" + (effectInstance.getAmplifier() + 1);
                iconPoseStack.scale(0.5f, 0.5f, 1.0f);
                float scaledLevelWidth = (float)font.width(levelText) * 0.5f;
                Objects.requireNonNull(font);
                float scaledLevelHeight = 9.0f * 0.5f;
                float textX = halfWidth - scaledLevelWidth;
                float textY = halfHeight - scaledLevelHeight;
                int textColor = -1;
                font.drawInBatch(levelText, textX, textY, textColor, false, iconPoseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
        poseStack.popPose();
    }

    public static float getVerticalOffset(Entity entity) {
        if (EffectRenderUtil.isNeatModLoaded()) {
            return entity.getBbHeight() + 0.92f + (float)EffectDisplayConfig.getVerticalOffset();
        }
        return entity.getBbHeight() + 0.6f;
    }

    public static boolean isNeatModLoaded() {
        try {
            if (ModList.get() != null) {
                return ModList.get().isLoaded("neat");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWarframeModLoaded() {
        try {
            if (ModList.get() != null) {
                return ModList.get().isLoaded("warframe");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getHealthColor(LivingEntity entity) {
        float health = Mth.clamp((float)entity.getHealth(), (float)0.0f, (float)entity.getMaxHealth());
        float hue = Math.max(0.0f, health / entity.getMaxHealth() / 3.0f - 0.07f);
        return Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f);
    }
}

